/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.http;

import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.jetty.io.AsyncEndPoint;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.spdy.ByteBufferPool;
import org.eclipse.jetty.spdy.EmptyAsyncEndPoint;
import org.eclipse.jetty.spdy.SPDYAsyncConnection;
import org.eclipse.jetty.spdy.ServerSPDYAsyncConnectionFactory;
import org.eclipse.jetty.spdy.api.DataInfo;
import org.eclipse.jetty.spdy.api.Headers;
import org.eclipse.jetty.spdy.api.HeadersInfo;
import org.eclipse.jetty.spdy.api.ReplyInfo;
import org.eclipse.jetty.spdy.api.Stream;
import org.eclipse.jetty.spdy.api.StreamFrameListener;
import org.eclipse.jetty.spdy.api.SynInfo;
import org.eclipse.jetty.spdy.api.server.ServerSessionFrameListener;
import org.eclipse.jetty.spdy.http.ServerHTTPSPDYAsyncConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerHTTPSPDYAsyncConnectionFactory
extends ServerSPDYAsyncConnectionFactory {
    private static final String CONNECTION_ATTRIBUTE = "org.eclipse.jetty.spdy.http.connection";
    private static final Logger logger = LoggerFactory.getLogger(ServerHTTPSPDYAsyncConnectionFactory.class);
    private final Connector connector;

    public ServerHTTPSPDYAsyncConnectionFactory(short version, ByteBufferPool bufferPool, Executor threadPool, ScheduledExecutorService scheduler, Connector connector) {
        super(version, bufferPool, threadPool, scheduler);
        this.connector = connector;
    }

    protected ServerSessionFrameListener newServerSessionFrameListener(AsyncEndPoint endPoint, Object attachment) {
        return new HTTPServerFrameListener(endPoint);
    }

    private class HTTPSPDYAsyncEndPoint
    extends EmptyAsyncEndPoint {
        private final Stream stream;

        public HTTPSPDYAsyncEndPoint(Stream stream) {
            this.stream = stream;
        }

        public void asyncDispatch() {
            ServerHTTPSPDYAsyncConnection connection = (ServerHTTPSPDYAsyncConnection)((Object)this.stream.getAttribute(ServerHTTPSPDYAsyncConnectionFactory.CONNECTION_ATTRIBUTE));
            connection.async();
        }
    }

    private class HTTPServerFrameListener
    extends ServerSessionFrameListener.Adapter
    implements StreamFrameListener {
        private final AsyncEndPoint endPoint;

        public HTTPServerFrameListener(AsyncEndPoint endPoint) {
            this.endPoint = endPoint;
        }

        public StreamFrameListener onSyn(Stream stream, SynInfo synInfo) {
            logger.debug("Received {} on {}", (Object)synInfo, (Object)stream);
            HTTPSPDYAsyncEndPoint asyncEndPoint = new HTTPSPDYAsyncEndPoint(stream);
            ServerHTTPSPDYAsyncConnection connection = new ServerHTTPSPDYAsyncConnection(ServerHTTPSPDYAsyncConnectionFactory.this.connector, (AsyncEndPoint)asyncEndPoint, ServerHTTPSPDYAsyncConnectionFactory.this.connector.getServer(), (SPDYAsyncConnection)this.endPoint.getConnection(), stream);
            asyncEndPoint.setConnection((Connection)connection);
            stream.setAttribute(ServerHTTPSPDYAsyncConnectionFactory.CONNECTION_ATTRIBUTE, (Object)connection);
            Headers headers = synInfo.getHeaders();
            connection.beginRequest(headers);
            if (headers.isEmpty()) {
                return this;
            }
            if (synInfo.isClose()) {
                connection.endRequest();
                return null;
            }
            return this;
        }

        public void onReply(Stream stream, ReplyInfo replyInfo) {
        }

        public void onHeaders(Stream stream, HeadersInfo headersInfo) {
            logger.debug("Received {} on {}", (Object)headersInfo, (Object)stream);
            ServerHTTPSPDYAsyncConnection connection = (ServerHTTPSPDYAsyncConnection)((Object)stream.getAttribute(ServerHTTPSPDYAsyncConnectionFactory.CONNECTION_ATTRIBUTE));
            connection.headers(headersInfo.getHeaders());
            if (headersInfo.isClose()) {
                connection.endRequest();
            }
        }

        public void onData(Stream stream, DataInfo dataInfo) {
            logger.debug("Received {} on {}", (Object)dataInfo, (Object)stream);
            ServerHTTPSPDYAsyncConnection connection = (ServerHTTPSPDYAsyncConnection)((Object)stream.getAttribute(ServerHTTPSPDYAsyncConnectionFactory.CONNECTION_ATTRIBUTE));
            connection.content(dataInfo, dataInfo.isClose());
            if (dataInfo.isClose()) {
                connection.endRequest();
            }
        }
    }
}

