/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.server.proxy;

import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.spdy.server.proxy.ProxyEngineSelector;
import org.eclipse.jetty.spdy.server.proxy.ProxyHTTPSPDYConnection;

public class ProxyHTTPConnectionFactory
extends AbstractConnectionFactory
implements HttpConfiguration.ConnectionFactory {
    private final short version;
    private final ProxyEngineSelector proxyEngineSelector;
    private final HttpConfiguration httpConfiguration;

    public ProxyHTTPConnectionFactory(HttpConfiguration httpConfiguration, short version, ProxyEngineSelector proxyEngineSelector) {
        super(HttpVersion.HTTP_1_1.asString());
        this.version = version;
        this.proxyEngineSelector = proxyEngineSelector;
        this.httpConfiguration = httpConfiguration;
    }

    public Connection newConnection(Connector connector, EndPoint endPoint) {
        return this.configure((AbstractConnection)new ProxyHTTPSPDYConnection(connector, this.httpConfiguration, endPoint, this.version, this.proxyEngineSelector), connector, endPoint);
    }

    public HttpConfiguration getHttpConfiguration() {
        return this.httpConfiguration;
    }
}

