/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.server.http;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpTransport;
import org.eclipse.jetty.spdy.StreamException;
import org.eclipse.jetty.spdy.api.ByteBufferDataInfo;
import org.eclipse.jetty.spdy.api.DataInfo;
import org.eclipse.jetty.spdy.api.HeadersInfo;
import org.eclipse.jetty.spdy.api.PushInfo;
import org.eclipse.jetty.spdy.api.ReplyInfo;
import org.eclipse.jetty.spdy.api.Session;
import org.eclipse.jetty.spdy.api.Stream;
import org.eclipse.jetty.spdy.api.StreamStatus;
import org.eclipse.jetty.spdy.server.http.HTTPSPDYHeader;
import org.eclipse.jetty.spdy.server.http.HttpChannelOverSPDY;
import org.eclipse.jetty.spdy.server.http.HttpInputOverSPDY;
import org.eclipse.jetty.spdy.server.http.PushStrategy;
import org.eclipse.jetty.util.BlockingCallback;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.ConcurrentArrayQueue;
import org.eclipse.jetty.util.Fields;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpTransportOverSPDY
implements HttpTransport {
    private static final Logger LOG = Log.getLogger(HttpTransportOverSPDY.class);
    private final Connector connector;
    private final HttpConfiguration configuration;
    private final EndPoint endPoint;
    private final PushStrategy pushStrategy;
    private final Stream stream;
    private final short version;
    private final Fields requestHeaders;
    private final BlockingCallback streamBlocker = new BlockingCallback();
    private final AtomicBoolean committed = new AtomicBoolean();

    public HttpTransportOverSPDY(Connector connector, HttpConfiguration configuration, EndPoint endPoint, PushStrategy pushStrategy, Stream stream, Fields requestHeaders) {
        this.connector = connector;
        this.configuration = configuration;
        this.endPoint = endPoint;
        this.pushStrategy = pushStrategy == null ? new PushStrategy.None() : pushStrategy;
        this.stream = stream;
        this.requestHeaders = requestHeaders;
        Session session = stream.getSession();
        this.version = session.getVersion();
    }

    protected Stream getStream() {
        return this.stream;
    }

    protected Fields getRequestHeaders() {
        return this.requestHeaders;
    }

    public void send(ByteBuffer responseBodyContent, boolean lastContent, Callback callback) {
        this.send(null, responseBodyContent, lastContent, callback);
    }

    public void send(HttpGenerator.ResponseInfo info, ByteBuffer content, boolean lastContent, final Callback callback) {
        boolean close;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sending {} {} {} {} last={}", new Object[]{this, this.stream, info, BufferUtil.toDetailString((ByteBuffer)content), lastContent});
        }
        if (this.stream.isClosed() || this.stream.isReset()) {
            EofException exception = new EofException("stream closed");
            callback.failed((Throwable)exception);
            return;
        }
        boolean isHeadRequest = HttpMethod.HEAD.name().equalsIgnoreCase(this.requestHeaders.get(HTTPSPDYHeader.METHOD.name(this.version)).value());
        boolean hasContent = BufferUtil.hasContent((ByteBuffer)content) && !isHeadRequest;
        boolean bl = close = !hasContent && lastContent;
        if (info != null) {
            if (!this.committed.compareAndSet(false, true)) {
                StreamException exception = new StreamException(this.stream.getId(), StreamStatus.PROTOCOL_ERROR, "Stream already committed!");
                callback.failed((Throwable)exception);
                LOG.warn("Committed response twice.", (Throwable)exception);
                return;
            }
            this.sendReply(info, (Callback)(!hasContent ? callback : new Callback.Adapter(){

                public void failed(Throwable x) {
                    callback.failed(x);
                }
            }), close);
        }
        if (hasContent) {
            LOG.debug("Send content: {} on stream: {} lastContent={}", new Object[]{BufferUtil.toDetailString((ByteBuffer)content), this.stream, lastContent});
            this.stream.data((DataInfo)new ByteBufferDataInfo(this.endPoint.getIdleTimeout(), TimeUnit.MILLISECONDS, content, lastContent), callback);
        } else if (lastContent && info == null) {
            LOG.debug("No content and lastContent=true. Sending empty ByteBuffer to close stream: {}", new Object[]{this.stream});
            this.stream.data((DataInfo)new ByteBufferDataInfo(this.endPoint.getIdleTimeout(), TimeUnit.MILLISECONDS, BufferUtil.EMPTY_BUFFER, lastContent), callback);
        } else if (!lastContent && !hasContent && info == null) {
            throw new IllegalStateException("not lastContent, no content and no responseInfo!");
        }
    }

    private void sendReply(HttpGenerator.ResponseInfo info, Callback callback, boolean close) {
        Fields headers = new Fields();
        HttpVersion httpVersion = HttpVersion.HTTP_1_1;
        headers.put(HTTPSPDYHeader.VERSION.name(this.version), httpVersion.asString());
        int status = info.getStatus();
        StringBuilder httpStatus = new StringBuilder().append(status);
        String reason = info.getReason();
        if (reason == null) {
            reason = HttpStatus.getMessage((int)status);
        }
        if (reason != null) {
            httpStatus.append(" ").append(reason);
        }
        headers.put(HTTPSPDYHeader.STATUS.name(this.version), httpStatus.toString());
        LOG.debug("HTTP < {} {}", new Object[]{httpVersion, httpStatus});
        HttpFields fields = info.getHttpFields();
        if (fields != null) {
            for (int i = 0; i < fields.size(); ++i) {
                HttpField field = fields.getField(i);
                String name = field.getName();
                String value = field.getValue();
                headers.add(name, value);
                LOG.debug("HTTP < {}: {}", new Object[]{name, value});
            }
        }
        if (this.configuration.getSendServerVersion()) {
            headers.add(HttpHeader.SERVER.asString(), HttpConfiguration.SERVER_VERSION);
        }
        if (this.configuration.getSendXPoweredBy()) {
            headers.add(HttpHeader.X_POWERED_BY.asString(), HttpConfiguration.SERVER_VERSION);
        }
        ReplyInfo reply = new ReplyInfo(headers, close);
        LOG.debug("Sending reply: {} on stream: {}", new Object[]{reply, this.stream});
        this.reply(this.stream, reply, callback);
    }

    public void send(HttpGenerator.ResponseInfo info, ByteBuffer content, boolean lastContent) throws IOException {
        this.send(info, content, lastContent, (Callback)this.streamBlocker);
        try {
            this.streamBlocker.block();
        }
        catch (Exception e) {
            LOG.debug((Throwable)e);
        }
    }

    public void completed() {
        LOG.debug("Completed {}", new Object[]{this});
    }

    private void reply(Stream stream, ReplyInfo replyInfo, Callback callback) {
        Set<String> pushResources;
        if (!stream.isUnidirectional()) {
            stream.reply(replyInfo, callback);
        } else {
            stream.headers(new HeadersInfo(replyInfo.getHeaders(), replyInfo.isClose()), callback);
        }
        Fields responseHeaders = replyInfo.getHeaders();
        if (responseHeaders.get(HTTPSPDYHeader.STATUS.name(this.version)).value().startsWith("200") && !stream.isClosed() && (pushResources = this.pushStrategy.apply(stream, this.requestHeaders, responseHeaders)).size() > 0) {
            PushResourceCoordinator pushResourceCoordinator = new PushResourceCoordinator(pushResources);
            pushResourceCoordinator.coordinate();
        }
    }

    private static class PushResource {
        private final Stream pushStream;
        private final Fields pushRequestHeaders;

        public PushResource(Stream pushStream, Fields pushRequestHeaders) {
            this.pushStream = pushStream;
            this.pushRequestHeaders = pushRequestHeaders;
        }

        public Stream getPushStream() {
            return this.pushStream;
        }

        public Fields getPushRequestHeaders() {
            return this.pushRequestHeaders;
        }

        public String toString() {
            return "PushResource{pushStream=" + this.pushStream + ", pushRequestHeaders=" + this.pushRequestHeaders + '}';
        }
    }

    private class PushResourceCoordinator {
        private final Queue<PushResource> queue = new ConcurrentArrayQueue();
        private final Set<String> resources;
        private AtomicBoolean active = new AtomicBoolean(false);

        private PushResourceCoordinator(Set<String> resources) {
            this.resources = resources;
        }

        private void coordinate() {
            LOG.debug("Pushing resources: {}", new Object[]{this.resources});
            for (String pushResource : this.resources) {
                this.pushResource(pushResource);
            }
        }

        private void sendNextResourceData() {
            LOG.debug("{} sendNextResourceData active: {}", new Object[]{this.hashCode(), this.active.get()});
            if (this.active.compareAndSet(false, true)) {
                PushResource resource = this.queue.poll();
                if (resource != null) {
                    LOG.debug("Opening new push channel for: {}", new Object[]{resource});
                    HttpChannelOverSPDY pushChannel = this.newHttpChannelOverSPDY(resource.getPushStream(), resource.getPushRequestHeaders());
                    pushChannel.requestStart(resource.getPushRequestHeaders(), true);
                    return;
                }
                if (this.active.compareAndSet(true, false)) {
                    if (this.queue.peek() != null) {
                        this.sendNextResourceData();
                    }
                } else {
                    throw new IllegalStateException("active must not be false here! Concurrency bug!");
                }
            }
        }

        private HttpChannelOverSPDY newHttpChannelOverSPDY(Stream pushStream, Fields pushRequestHeaders) {
            PushHttpTransportOverSPDY transport = new PushHttpTransportOverSPDY(HttpTransportOverSPDY.this.connector, HttpTransportOverSPDY.this.configuration, HttpTransportOverSPDY.this.endPoint, HttpTransportOverSPDY.this.pushStrategy, pushStream, pushRequestHeaders, this, HttpTransportOverSPDY.this.version);
            HttpInputOverSPDY input = new HttpInputOverSPDY();
            return new HttpChannelOverSPDY(HttpTransportOverSPDY.this.connector, HttpTransportOverSPDY.this.configuration, HttpTransportOverSPDY.this.endPoint, transport, input, pushStream);
        }

        private void pushResource(String pushResource) {
            Fields.Field scheme = HttpTransportOverSPDY.this.requestHeaders.get(HTTPSPDYHeader.SCHEME.name(HttpTransportOverSPDY.this.version));
            Fields.Field host = HttpTransportOverSPDY.this.requestHeaders.get(HTTPSPDYHeader.HOST.name(HttpTransportOverSPDY.this.version));
            Fields.Field uri = HttpTransportOverSPDY.this.requestHeaders.get(HTTPSPDYHeader.URI.name(HttpTransportOverSPDY.this.version));
            final Fields pushHeaders = this.createPushHeaders(scheme, host, pushResource);
            final Fields pushRequestHeaders = this.createRequestHeaders(scheme, host, uri, pushResource);
            HttpTransportOverSPDY.this.stream.push(new PushInfo(pushHeaders, false), (Promise)new Promise<Stream>(){

                public void succeeded(Stream pushStream) {
                    LOG.debug("Headers pushed for {} on {}", new Object[]{pushHeaders.get(HTTPSPDYHeader.URI.name(HttpTransportOverSPDY.this.version)), pushStream});
                    PushResourceCoordinator.this.queue.offer(new PushResource(pushStream, pushRequestHeaders));
                    PushResourceCoordinator.this.sendNextResourceData();
                }

                public void failed(Throwable x) {
                    LOG.debug("Creating push stream failed.", x);
                    PushResourceCoordinator.this.sendNextResourceData();
                }
            });
        }

        private void complete() {
            if (!this.active.compareAndSet(true, false)) {
                throw new IllegalStateException();
            }
            this.sendNextResourceData();
        }

        private Fields createRequestHeaders(Fields.Field scheme, Fields.Field host, Fields.Field uri, String pushResourcePath) {
            Fields newRequestHeaders = new Fields(HttpTransportOverSPDY.this.requestHeaders, false);
            newRequestHeaders.put(HTTPSPDYHeader.METHOD.name(HttpTransportOverSPDY.this.version), "GET");
            newRequestHeaders.put(HTTPSPDYHeader.VERSION.name(HttpTransportOverSPDY.this.version), "HTTP/1.1");
            newRequestHeaders.put(scheme);
            newRequestHeaders.put(host);
            newRequestHeaders.put(HTTPSPDYHeader.URI.name(HttpTransportOverSPDY.this.version), pushResourcePath);
            String referrer = scheme.value() + "://" + host.value() + uri.value();
            newRequestHeaders.put("referer", referrer);
            newRequestHeaders.put("x-spdy-push", "true");
            return newRequestHeaders;
        }

        private Fields createPushHeaders(Fields.Field scheme, Fields.Field host, String pushResourcePath) {
            Fields pushHeaders = new Fields();
            if (HttpTransportOverSPDY.this.version == 2) {
                pushHeaders.put(HTTPSPDYHeader.URI.name(HttpTransportOverSPDY.this.version), scheme.value() + "://" + host.value() + pushResourcePath);
            } else {
                pushHeaders.put(HTTPSPDYHeader.URI.name(HttpTransportOverSPDY.this.version), pushResourcePath);
                pushHeaders.put(scheme);
                pushHeaders.put(host);
            }
            return pushHeaders;
        }
    }

    private static class PushHttpTransportOverSPDY
    extends HttpTransportOverSPDY {
        private final PushResourceCoordinator coordinator;
        private final short version;

        private PushHttpTransportOverSPDY(Connector connector, HttpConfiguration configuration, EndPoint endPoint, PushStrategy pushStrategy, Stream stream, Fields requestHeaders, PushResourceCoordinator coordinator, short version) {
            super(connector, configuration, endPoint, pushStrategy, stream, requestHeaders);
            this.coordinator = coordinator;
            this.version = version;
        }

        @Override
        public void completed() {
            Stream stream = this.getStream();
            LOG.debug("Resource pushed for {} on {}", new Object[]{this.getRequestHeaders().get(HTTPSPDYHeader.URI.name(this.version)), stream});
            this.coordinator.complete();
        }
    }
}

