/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.server.proxy;

import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.spdy.api.server.ServerSessionFrameListener;
import org.eclipse.jetty.spdy.server.NPNServerConnectionFactory;
import org.eclipse.jetty.spdy.server.SPDYServerConnectionFactory;
import org.eclipse.jetty.spdy.server.proxy.ProxyEngineSelector;
import org.eclipse.jetty.spdy.server.proxy.ProxyHTTPConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class HTTPSPDYProxyServerConnector
extends ServerConnector {
    public HTTPSPDYProxyServerConnector(Server server, ProxyEngineSelector proxyEngineSelector) {
        this(server, new HttpConfiguration(), proxyEngineSelector);
    }

    public HTTPSPDYProxyServerConnector(Server server, HttpConfiguration config, ProxyEngineSelector proxyEngineSelector) {
        this(server, null, config, proxyEngineSelector);
    }

    public HTTPSPDYProxyServerConnector(Server server, SslContextFactory sslContextFactory, ProxyEngineSelector proxyEngineSelector) {
        this(server, sslContextFactory, new HttpConfiguration(), proxyEngineSelector);
    }

    public HTTPSPDYProxyServerConnector(Server server, SslContextFactory sslContextFactory, HttpConfiguration config, ProxyEngineSelector proxyEngineSelector) {
        ConnectionFactory[] connectionFactoryArray;
        if (sslContextFactory == null) {
            ConnectionFactory[] connectionFactoryArray2 = new ConnectionFactory[1];
            connectionFactoryArray = connectionFactoryArray2;
            connectionFactoryArray2[0] = new ProxyHTTPConnectionFactory(config, 2, proxyEngineSelector);
        } else {
            ConnectionFactory[] connectionFactoryArray3 = new ConnectionFactory[4];
            connectionFactoryArray3[0] = new NPNServerConnectionFactory(new String[]{"spdy/3", "spdy/2", "http/1.1"});
            connectionFactoryArray3[1] = new SPDYServerConnectionFactory(3, (ServerSessionFrameListener)proxyEngineSelector);
            connectionFactoryArray3[2] = new SPDYServerConnectionFactory(2, (ServerSessionFrameListener)proxyEngineSelector);
            connectionFactoryArray = connectionFactoryArray3;
            connectionFactoryArray3[3] = new ProxyHTTPConnectionFactory(config, 2, proxyEngineSelector);
        }
        super(server, sslContextFactory, connectionFactoryArray);
        NPNServerConnectionFactory npnConnectionFactory = (NPNServerConnectionFactory)this.getConnectionFactory(NPNServerConnectionFactory.class);
        if (npnConnectionFactory != null) {
            npnConnectionFactory.setDefaultProtocol("http/1.1");
        }
    }
}

