/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.server.proxy;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.eclipse.jetty.spdy.api.Stream;
import org.eclipse.jetty.spdy.api.StreamFrameListener;
import org.eclipse.jetty.spdy.api.SynInfo;
import org.eclipse.jetty.spdy.server.proxy.ProxyEngineSelector;
import org.eclipse.jetty.util.Fields;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public abstract class ProxyEngine {
    protected final Logger logger = Log.getLogger(this.getClass());
    private final String name;

    protected ProxyEngine() {
        this(ProxyEngine.name());
    }

    private static String name() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException x) {
            return "localhost";
        }
    }

    public abstract StreamFrameListener proxy(Stream var1, SynInfo var2, ProxyEngineSelector.ProxyServerInfo var3);

    protected ProxyEngine(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    protected void addRequestProxyHeaders(Stream stream, Fields headers) {
        this.addViaHeader(headers);
        InetSocketAddress address = (InetSocketAddress)stream.getSession().getAttribute("org.eclipse.jetty.spdy.remoteAddress");
        if (address != null) {
            headers.add("X-Forwarded-For", address.getHostName());
        }
    }

    protected void addResponseProxyHeaders(Stream stream, Fields headers) {
        this.addViaHeader(headers);
    }

    private void addViaHeader(Fields headers) {
        headers.add("Via", "http/1.1 " + this.getName());
    }

    protected void customizeRequestHeaders(Stream stream, Fields headers) {
    }

    protected void customizeResponseHeaders(Stream stream, Fields headers) {
    }
}

