/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.client.http;

import org.eclipse.jetty.client.HttpChannel;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.spdy.api.Session;
import org.eclipse.jetty.spdy.client.http.HttpConnectionOverSPDY;
import org.eclipse.jetty.spdy.client.http.HttpReceiverOverSPDY;
import org.eclipse.jetty.spdy.client.http.HttpSenderOverSPDY;

public class HttpChannelOverSPDY
extends HttpChannel {
    private final HttpConnectionOverSPDY connection;
    private final Session session;
    private final HttpSenderOverSPDY sender;
    private final HttpReceiverOverSPDY receiver;

    public HttpChannelOverSPDY(HttpDestination destination, HttpConnectionOverSPDY connection, Session session) {
        super(destination);
        this.connection = connection;
        this.session = session;
        this.sender = new HttpSenderOverSPDY(this);
        this.receiver = new HttpReceiverOverSPDY(this);
    }

    public Session getSession() {
        return this.session;
    }

    public HttpSenderOverSPDY getHttpSender() {
        return this.sender;
    }

    public HttpReceiverOverSPDY getHttpReceiver() {
        return this.receiver;
    }

    public void send() {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange != null) {
            this.sender.send(exchange);
        }
    }

    public void proceed(HttpExchange exchange, Throwable failure) {
        this.sender.proceed(exchange, failure);
    }

    public boolean abort(Throwable cause) {
        this.sender.abort(cause);
        return this.receiver.abort(cause);
    }

    public void exchangeTerminated(Result result) {
        super.exchangeTerminated(result);
        this.connection.release(this);
    }
}

