/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.client.http;

import org.eclipse.jetty.client.HttpChannel;
import org.eclipse.jetty.client.HttpContent;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpSender;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.spdy.api.ByteBufferDataInfo;
import org.eclipse.jetty.spdy.api.DataInfo;
import org.eclipse.jetty.spdy.api.Stream;
import org.eclipse.jetty.spdy.api.StreamFrameListener;
import org.eclipse.jetty.spdy.api.SynInfo;
import org.eclipse.jetty.spdy.client.http.HttpChannelOverSPDY;
import org.eclipse.jetty.spdy.http.HTTPSPDYHeader;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Fields;
import org.eclipse.jetty.util.Promise;

public class HttpSenderOverSPDY
extends HttpSender {
    private volatile Stream stream;

    public HttpSenderOverSPDY(HttpChannelOverSPDY channel) {
        super((HttpChannel)channel);
    }

    public HttpChannelOverSPDY getHttpChannel() {
        return (HttpChannelOverSPDY)super.getHttpChannel();
    }

    protected void sendHeaders(HttpExchange exchange, final HttpContent content, final Callback callback) {
        Request request = exchange.getRequest();
        final long idleTimeout = request.getIdleTimeout();
        short spdyVersion = this.getHttpChannel().getSession().getVersion();
        Fields fields = new Fields();
        HttpField hostHeader = null;
        for (HttpField header : request.getHeaders()) {
            String name = header.getName();
            if (HTTPSPDYHeader.from((short)spdyVersion, (String)name) != HTTPSPDYHeader.HOST) {
                fields.add(name, header.getValue());
                continue;
            }
            hostHeader = header;
        }
        fields.put(HTTPSPDYHeader.METHOD.name(spdyVersion), request.getMethod());
        String path = request.getPath();
        String query = request.getQuery();
        if (query != null) {
            path = path + "?" + query;
        }
        fields.put(HTTPSPDYHeader.URI.name(spdyVersion), path);
        fields.put(HTTPSPDYHeader.VERSION.name(spdyVersion), request.getVersion().asString());
        if (hostHeader != null) {
            fields.put(HTTPSPDYHeader.HOST.name(spdyVersion), hostHeader.getValue());
        }
        SynInfo synInfo = new SynInfo(fields, !content.hasContent());
        this.getHttpChannel().getSession().syn(synInfo, (StreamFrameListener)this.getHttpChannel().getHttpReceiver(), (Promise)new Promise<Stream>(){

            public void succeeded(Stream stream) {
                stream.setIdleTimeout(idleTimeout);
                if (content.hasContent()) {
                    HttpSenderOverSPDY.this.stream = stream;
                }
                callback.succeeded();
            }

            public void failed(Throwable failure) {
                callback.failed(failure);
            }
        });
    }

    protected void sendContent(HttpExchange exchange, HttpContent content, Callback callback) {
        if (content.isConsumed()) {
            callback.succeeded();
        } else {
            ByteBufferDataInfo dataInfo = new ByteBufferDataInfo(content.getByteBuffer(), content.isLast());
            this.stream.data((DataInfo)dataInfo, callback);
        }
    }

    protected void reset() {
        super.reset();
        this.stream = null;
    }
}

