/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.client.http;

import org.eclipse.jetty.client.HttpChannel;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpReceiver;
import org.eclipse.jetty.client.HttpResponse;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.spdy.api.DataInfo;
import org.eclipse.jetty.spdy.api.HeadersInfo;
import org.eclipse.jetty.spdy.api.PushInfo;
import org.eclipse.jetty.spdy.api.ReplyInfo;
import org.eclipse.jetty.spdy.api.RstInfo;
import org.eclipse.jetty.spdy.api.Stream;
import org.eclipse.jetty.spdy.api.StreamFrameListener;
import org.eclipse.jetty.spdy.api.StreamStatus;
import org.eclipse.jetty.spdy.client.http.HttpChannelOverSPDY;
import org.eclipse.jetty.spdy.http.HTTPSPDYHeader;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Fields;

public class HttpReceiverOverSPDY
extends HttpReceiver
implements StreamFrameListener {
    public HttpReceiverOverSPDY(HttpChannelOverSPDY channel) {
        super((HttpChannel)channel);
    }

    public HttpChannelOverSPDY getHttpChannel() {
        return (HttpChannelOverSPDY)super.getHttpChannel();
    }

    public void onReply(Stream stream, ReplyInfo replyInfo) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return;
        }
        try {
            HttpResponse response = exchange.getResponse();
            Fields fields = replyInfo.getHeaders();
            short spdy = stream.getSession().getVersion();
            HttpVersion version = HttpVersion.fromString((String)fields.get(HTTPSPDYHeader.VERSION.name(spdy)).getValue());
            response.version(version);
            String[] status = fields.get(HTTPSPDYHeader.STATUS.name(spdy)).getValue().split(" ", 2);
            Integer code = Integer.parseInt(status[0]);
            response.status(code.intValue());
            String reason = status.length < 2 ? HttpStatus.getMessage((int)code) : status[1];
            response.reason(reason);
            if (this.responseBegin(exchange)) {
                for (Fields.Field field : fields) {
                    String name = field.getName();
                    if (HTTPSPDYHeader.from((short)spdy, (String)name) != null) continue;
                    HttpField httpField = new HttpField(name, field.getValue());
                    this.responseHeader(exchange, httpField);
                }
                if (this.responseHeaders(exchange) && replyInfo.isClose()) {
                    this.responseSuccess(exchange);
                }
            }
        }
        catch (Exception x) {
            this.responseFailure(x);
        }
    }

    public StreamFrameListener onPush(Stream stream, PushInfo pushInfo) {
        this.getHttpChannel().getSession().rst(new RstInfo(stream.getId(), StreamStatus.REFUSED_STREAM), (Callback)Callback.Adapter.INSTANCE);
        return null;
    }

    public void onHeaders(Stream stream, HeadersInfo headersInfo) {
    }

    public void onData(Stream stream, DataInfo dataInfo) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return;
        }
        try {
            int length = dataInfo.length();
            boolean process = this.responseContent(exchange, dataInfo.asByteBuffer(false), (Callback)new Callback.Adapter());
            dataInfo.consume(length);
            if (process && dataInfo.isClose()) {
                this.responseSuccess(exchange);
            }
        }
        catch (Exception x) {
            this.responseFailure(x);
        }
    }

    public void onFailure(Stream stream, Throwable x) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return;
        }
        exchange.getRequest().abort(x);
    }
}

