/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.client.http;

import java.nio.channels.AsynchronousCloseException;
import java.util.Set;
import org.eclipse.jetty.client.HttpChannel;
import org.eclipse.jetty.client.HttpConnection;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.spdy.api.GoAwayInfo;
import org.eclipse.jetty.spdy.api.Session;
import org.eclipse.jetty.spdy.client.http.HttpChannelOverSPDY;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.ConcurrentHashSet;

public class HttpConnectionOverSPDY
extends HttpConnection {
    private final Set<HttpChannel> channels = new ConcurrentHashSet();
    private final Session session;

    public HttpConnectionOverSPDY(HttpDestination destination, Session session) {
        super(destination);
        this.session = session;
    }

    protected void send(HttpExchange exchange) {
        this.normalizeRequest((Request)exchange.getRequest());
        HttpChannelOverSPDY channel = new HttpChannelOverSPDY(this.getHttpDestination(), this, this.session);
        this.channels.add(channel);
        channel.associate(exchange);
        channel.send();
    }

    protected void release(HttpChannel channel) {
        this.channels.remove(channel);
    }

    public void close() {
        this.getHttpDestination().close((Connection)this);
        this.session.goAway(new GoAwayInfo(), (Callback)Callback.Adapter.INSTANCE);
        this.abort(new AsynchronousCloseException());
    }

    private void abort(Throwable failure) {
        for (HttpChannel channel : this.channels) {
            HttpExchange exchange = channel.getHttpExchange();
            if (exchange == null) continue;
            exchange.getRequest().abort(failure);
        }
        this.channels.clear();
    }
}

