/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.client.http;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.Map;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.Origin;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.spdy.api.Session;
import org.eclipse.jetty.spdy.api.SessionFrameListener;
import org.eclipse.jetty.spdy.client.SPDYClient;
import org.eclipse.jetty.spdy.client.http.HttpConnectionOverSPDY;
import org.eclipse.jetty.spdy.client.http.HttpDestinationOverSPDY;
import org.eclipse.jetty.util.Promise;

public class HttpClientTransportOverSPDY
implements HttpClientTransport {
    private final SPDYClient client;
    private final ClientConnectionFactory connectionFactory;
    private HttpClient httpClient;

    public HttpClientTransportOverSPDY(SPDYClient client) {
        this.client = client;
        this.connectionFactory = client.getClientConnectionFactory();
        client.setClientConnectionFactory(new ClientConnectionFactory(){

            public Connection newConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
                HttpDestination destination = (HttpDestination)context.get("http.destination");
                return destination.getClientConnectionFactory().newConnection(endPoint, context);
            }
        });
    }

    public void setHttpClient(HttpClient client) {
        this.httpClient = client;
    }

    public HttpDestination newHttpDestination(Origin origin) {
        return new HttpDestinationOverSPDY(this.httpClient, origin);
    }

    public void connect(SocketAddress address, Map<String, Object> context) {
        final HttpDestination destination = (HttpDestination)context.get("http.destination");
        final Promise promise = (Promise)context.get("http.connection.promise");
        SessionFrameListener.Adapter listener = new SessionFrameListener.Adapter(){

            public void onFailure(Session session, Throwable x) {
                destination.abort(x);
            }
        };
        this.client.connect(address, (SessionFrameListener)listener, (Promise)new Promise<Session>(){

            public void succeeded(Session session) {
                promise.succeeded((Object)new HttpConnectionOverSPDY(destination, session));
            }

            public void failed(Throwable x) {
                promise.failed(x);
            }
        }, context);
    }

    public Connection newConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
        return this.connectionFactory.newConnection(endPoint, context);
    }
}

