/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.client;

import org.eclipse.jetty.quic.client.ClientQuicSession;
import org.eclipse.jetty.quic.common.ProtocolSession;
import org.eclipse.jetty.quic.common.QuicSession;
import org.eclipse.jetty.quic.common.QuicStreamEndPoint;
import org.eclipse.jetty.quic.common.StreamType;
import org.eclipse.jetty.quic.common.internal.QuicErrorCode;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientProtocolSession
extends ProtocolSession {
    private static final Logger LOG = LoggerFactory.getLogger(ClientProtocolSession.class);
    private final Runnable producer = Invocable.from((Invocable.InvocationType)Invocable.InvocationType.NON_BLOCKING, () -> this.produce());
    private QuicStreamEndPoint endPoint;

    public ClientProtocolSession(ClientQuicSession session) {
        super((QuicSession)session);
    }

    public ClientQuicSession getQuicSession() {
        return (ClientQuicSession)super.getQuicSession();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.onStart();
    }

    protected void onStart() {
        long streamId = this.getQuicSession().newStreamId(StreamType.CLIENT_BIDIRECTIONAL);
        this.endPoint = this.getOrCreateStreamEndPoint(streamId, arg_0 -> ((ClientProtocolSession)this).openProtocolEndPoint(arg_0));
    }

    protected void doStop() throws Exception {
        this.onStop();
        super.doStop();
    }

    protected void onStop() {
        QuicStreamEndPoint endPoint = this.endPoint;
        if (endPoint != null) {
            endPoint.closed(null);
        }
        this.endPoint = null;
    }

    public Runnable getProducerTask() {
        return this.producer;
    }

    protected boolean onReadable(long readableStreamId) {
        QuicStreamEndPoint streamEndPoint = this.getStreamEndPoint(readableStreamId);
        if (LOG.isDebugEnabled()) {
            LOG.debug("stream #{} selected for read: {}", (Object)readableStreamId, (Object)streamEndPoint);
        }
        if (streamEndPoint != null) {
            return streamEndPoint.onReadable();
        }
        return false;
    }

    protected void onFailure(long error, String reason, Throwable failure) {
        this.outwardClose(QuicErrorCode.NO_ERROR.code(), "failure");
    }

    protected void onClose(long error, String reason) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("session closed remotely 0x{}/{} {}", new Object[]{Long.toHexString(error), reason, this});
        }
    }
}

