/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.api;

import java.net.SocketAddress;
import java.util.Collection;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.quic.api.Stream;
import org.eclipse.jetty.quic.api.frames.ConnectionCloseFrame;
import org.eclipse.jetty.quic.api.frames.DataBlockedFrame;
import org.eclipse.jetty.quic.api.frames.MaxDataFrame;
import org.eclipse.jetty.quic.api.frames.MaxStreamsFrame;
import org.eclipse.jetty.quic.api.frames.StreamsBlockedFrame;
import org.eclipse.jetty.quic.api.frames.TransportParameters;
import org.eclipse.jetty.util.Promise;

public interface Session {
    public String getId();

    public long newStreamId(boolean var1);

    public Stream newStream(long var1, Stream.Listener var3);

    public Stream getStream(long var1);

    public void maxStreams(MaxStreamsFrame var1, Promise.Invocable<Session> var2);

    public void ping(Promise.Invocable<Session> var1);

    public void maxData(MaxDataFrame var1, Promise.Invocable<Session> var2);

    public void close(ConnectionCloseFrame var1, Promise.Invocable<Session> var2);

    public void disconnect(ConnectionCloseFrame var1, Throwable var2, Promise.Invocable<Session> var3);

    public Collection<Stream> getStreams();

    public SocketAddress getLocalSocketAddress();

    public SocketAddress getRemoteSocketAddress();

    public long getLocalBidirectionalMaxStreams();

    public long getIdleTimeout();

    public static interface Listener {
        default public TransportParameters onPrepare(Session session) {
            return null;
        }

        default public void onOpen(Session session) {
        }

        default public void onTransportParameters(Session session, TransportParameters parameters) {
        }

        default public Stream.Listener onNewStream(Stream stream) {
            return null;
        }

        default public void onMaxStreams(Session session, MaxStreamsFrame frame) {
        }

        default public void onPing(Session session) {
        }

        default public void onStreamsBlocked(Session session, StreamsBlockedFrame frame) {
        }

        default public void onMaxData(Session session, MaxDataFrame frame) {
        }

        default public void onDataBlocked(Session session, DataBlockedFrame frame) {
        }

        default public boolean onIdleTimeout(Session session, TimeoutException failure) {
            return true;
        }

        default public void onClose(Session session, ConnectionCloseFrame frame) {
        }

        default public void onDisconnect(Session session) {
        }

        public static interface Factory {
            public Listener newListener();
        }
    }
}

