/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.equinoxtools.console;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.continuation.ContinuationSupport;
import org.eclipse.jetty.osgi.equinoxtools.WebEquinoxToolsActivator;
import org.eclipse.jetty.osgi.equinoxtools.console.EquinoxChattingSupport;
import org.eclipse.jetty.osgi.equinoxtools.console.WebConsoleSession;
import org.eclipse.jetty.osgi.equinoxtools.console.WebConsoleWriterOutputStream;
import org.eclipse.osgi.framework.console.ConsoleSession;

public class EquinoxConsoleContinuationServlet
extends HttpServlet
implements WebConsoleWriterOutputStream.OnFlushListener {
    private static final long serialVersionUID = 1L;
    private Map<String, ConsoleUser> _consoleUsers = new HashMap<String, ConsoleUser>();
    private WebConsoleSession _consoleSession;
    private EquinoxChattingSupport _support;

    public EquinoxConsoleContinuationServlet() {
    }

    public EquinoxConsoleContinuationServlet(WebConsoleSession consoleSession, EquinoxChattingSupport support) {
        this._consoleSession = consoleSession;
        this._support = support;
    }

    public void init() throws ServletException {
        if (this._consoleSession == null) {
            this._consoleSession = new WebConsoleSession();
            WebEquinoxToolsActivator.getContext().registerService(ConsoleSession.class.getName(), (Object)this._consoleSession, null);
        }
        if (this._support == null) {
            this._support = new EquinoxChattingSupport(this._consoleSession);
        }
        this._consoleSession.addOnFlushListener(this);
    }

    public void destroy() {
        this._consoleSession.removeOnFlushListener(this);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getParameter("action") != null) {
            this.doPost(request, response);
        } else {
            response.sendRedirect(request.getContextPath() + request.getServletPath() + (request.getPathInfo() != null ? request.getPathInfo() : "") + "/index.html");
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String action = request.getParameter("action");
        String message = request.getParameter("message");
        String username = request.getParameter("user");
        if (action.equals("join")) {
            this.join(request, response, username);
        } else if (action.equals("poll")) {
            this.poll(request, response, username);
        } else if (action.equals("chat")) {
            this.chat(request, response, username, message);
        }
    }

    private synchronized void join(HttpServletRequest request, HttpServletResponse response, String username) throws IOException {
        ConsoleUser member = new ConsoleUser(username);
        this._consoleUsers.put(username, member);
        response.setContentType("text/json;charset=utf-8");
        PrintWriter out = response.getWriter();
        out.print("{action:\"join\"}");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void poll(HttpServletRequest request, HttpServletResponse response, String username) throws IOException {
        ConsoleUser member = this._consoleUsers.get(username);
        if (member == null) {
            response.sendError(503);
            return;
        }
        ConsoleUser consoleUser = member;
        synchronized (consoleUser) {
            if (member.getMessageQueue().size() > 0) {
                response.setContentType("text/json;charset=utf-8");
                StringBuilder buf = new StringBuilder();
                buf.append("{\"action\":\"poll\",");
                buf.append("\"from\":\"");
                buf.append(member.getMessageQueue().poll());
                buf.append("\",");
                String message = member.getMessageQueue().poll();
                int quote = message.indexOf(34);
                while (quote >= 0) {
                    message = message.substring(0, quote) + '\\' + message.substring(quote);
                    quote = message.indexOf(34, quote + 2);
                }
                buf.append("\"chat\":\"");
                buf.append(message);
                buf.append("\"}");
                byte[] bytes = buf.toString().getBytes("utf-8");
                response.setContentLength(bytes.length);
                response.getOutputStream().write(bytes);
            } else {
                Continuation continuation = ContinuationSupport.getContinuation((ServletRequest)request);
                if (continuation.isInitial()) {
                    continuation.setTimeout(20000L);
                    continuation.suspend();
                    member.setContinuation(continuation);
                } else {
                    response.setContentType("text/json;charset=utf-8");
                    PrintWriter out = response.getWriter();
                    out.print("{action:\"poll\"}");
                }
            }
        }
    }

    private synchronized void chat(HttpServletRequest request, HttpServletResponse response, String username, String message) throws IOException {
        if (!message.endsWith("has joined!")) {
            this._consoleSession.processCommand(message, false);
        }
        this.onFlush();
        response.setContentType("text/json;charset=utf-8");
        PrintWriter out = response.getWriter();
        out.print("{action:\"chat\"}");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFlush() {
        Queue<String> pendingConsoleOutputMessages = this._support.processConsoleOutput(true, this);
        Iterator<ConsoleUser> i$ = this._consoleUsers.values().iterator();
        while (i$.hasNext()) {
            ConsoleUser m;
            ConsoleUser consoleUser = m = i$.next();
            synchronized (consoleUser) {
                m.getMessageQueue().addAll(pendingConsoleOutputMessages);
                if (m.getContinuation() != null) {
                    m.getContinuation().resume();
                    m.setContinuation(null);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ConsoleUser {
        private String _name;
        private Continuation _continuation;
        private Queue<String> _queue = new LinkedList<String>();

        public ConsoleUser(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        public void setContinuation(Continuation continuation) {
            this._continuation = continuation;
        }

        public Continuation getContinuation() {
            return this._continuation;
        }

        public Queue<String> getMessageQueue() {
            return this._queue;
        }
    }
}

