/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.equinoxtools.console;

import java.util.LinkedList;
import java.util.Queue;
import org.eclipse.jetty.osgi.equinoxtools.console.WebConsoleSession;
import org.eclipse.jetty.osgi.equinoxtools.console.WebConsoleWriterOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EquinoxChattingSupport {
    private WebConsoleSession _consoleSession;

    public EquinoxChattingSupport(WebConsoleSession consoleSession) {
        this._consoleSession = consoleSession;
    }

    protected Queue<String> processConsoleOutput(boolean escape, WebConsoleWriterOutputStream.OnFlushListener onflush) {
        String lastLine;
        boolean clearConsole;
        LinkedList<String> result = new LinkedList<String>();
        String toDisplay = this._consoleSession.getOutputAsWriter().getBuffer().toString();
        boolean bl = clearConsole = this._consoleSession.getOnFlushListeners().indexOf(onflush) == this._consoleSession.getOnFlushListeners().size();
        if (clearConsole) {
            this._consoleSession.clearOutput();
        }
        boolean lastLineIsComplete = toDisplay.endsWith("\n") || toDisplay.endsWith("\r");
        String[] lines = toDisplay.split("\n");
        String string = lastLine = lastLineIsComplete ? null : lines[lines.length - 1];
        if (clearConsole) {
            this._consoleSession.getOutputAsWriter().append(lastLine);
        }
        for (int lnNb = 0; lnNb < (lastLineIsComplete ? lines.length : lines.length - 1); ++lnNb) {
            String line = lines[lnNb];
            while (line.trim().startsWith("null")) {
                line = line.trim().substring("null".length()).trim();
            }
            if (line.startsWith("osgi>")) {
                result.add("osgi>");
                result.add(escape ? EquinoxChattingSupport.jsonEscapeString(line.substring("osgi>".length())) : line.substring("osgi>".length()));
                continue;
            }
            result.add("&#10;");
            result.add(escape ? EquinoxChattingSupport.jsonEscapeString(line) : line);
        }
        return result;
    }

    public static String jsonEscapeString(String str) {
        char[] asChars;
        StringBuilder sb = new StringBuilder();
        block10: for (char ch : asChars = str.toCharArray()) {
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block10;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block10;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block10;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block10;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block10;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block10;
                }
                case '/': {
                    sb.append("\\/");
                    continue block10;
                }
                default: {
                    if (ch >= '\u0000' && ch <= '\u001f') {
                        String ss = Integer.toHexString(ch);
                        sb.append("\\u");
                        for (int i = 0; i < 4 - ss.length(); ++i) {
                            sb.append('0');
                        }
                        sb.append(ss.toUpperCase());
                        continue block10;
                    }
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    public void broadcast(WebConsoleWriterOutputStream.OnFlushListener source) {
        for (WebConsoleWriterOutputStream.OnFlushListener onflush : this._consoleSession.getOnFlushListeners()) {
            if (onflush == source) continue;
            onflush.onFlush();
        }
    }
}

