/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.equinoxtools.console;

import java.io.IOException;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.osgi.equinoxtools.WebEquinoxToolsActivator;
import org.eclipse.jetty.osgi.equinoxtools.console.EquinoxChattingSupport;
import org.eclipse.jetty.osgi.equinoxtools.console.WebConsoleSession;
import org.eclipse.jetty.osgi.equinoxtools.console.WebConsoleWriterOutputStream;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketServlet;
import org.eclipse.osgi.framework.console.ConsoleSession;

public class EquinoxConsoleWebSocketServlet
extends WebSocketServlet
implements WebConsoleWriterOutputStream.OnFlushListener {
    private final Set<ChatWebSocket> _members = new CopyOnWriteArraySet<ChatWebSocket>();
    private static final long serialVersionUID = 1L;
    private WebConsoleSession _consoleSession;
    private EquinoxChattingSupport _support;

    public EquinoxConsoleWebSocketServlet() {
    }

    public EquinoxConsoleWebSocketServlet(WebConsoleSession consoleSession, EquinoxChattingSupport support) {
        this._consoleSession = consoleSession;
        this._support = support;
    }

    public void init() throws ServletException {
        if (this._consoleSession == null) {
            this._consoleSession = new WebConsoleSession();
            WebEquinoxToolsActivator.getContext().registerService(ConsoleSession.class.getName(), (Object)this._consoleSession, null);
        }
        if (this._support == null) {
            this._support = new EquinoxChattingSupport(this._consoleSession);
        }
        super.init();
        this._consoleSession.addOnFlushListener(this);
    }

    public void destroy() {
        this._consoleSession.removeOnFlushListener(this);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.sendRedirect(request.getContextPath() + request.getServletPath() + (request.getPathInfo() != null ? request.getPathInfo() : "") + "/index.html");
    }

    public WebSocket doWebSocketConnect(HttpServletRequest request, String protocol) {
        return new ChatWebSocket();
    }

    public void onFlush() {
        Queue<String> pendingConsoleOutputMessages = this._support.processConsoleOutput(false, this);
        for (ChatWebSocket member : this._members) {
            try {
                for (String line : pendingConsoleOutputMessages) {
                    member._connection.sendMessage(line);
                }
            }
            catch (IOException e) {
                Log.warn((Throwable)e);
            }
        }
    }

    class ChatWebSocket
    implements WebSocket.OnTextMessage {
        WebSocket.Connection _connection;
        String _username;

        ChatWebSocket() {
        }

        public void onOpen(WebSocket.Connection connection) {
            this._connection = connection;
            EquinoxConsoleWebSocketServlet.this._members.add(this);
        }

        public void onMessage(byte frame, byte[] data, int offset, int length) {
        }

        public void onMessage(String data) {
            Log.info((String)"onMessage: {}", (Object)data);
            if (data.indexOf("disconnect") >= 0) {
                this._connection.disconnect();
            } else {
                if (!data.endsWith(":has joined!")) {
                    if (this._username != null && data.startsWith(this._username + ":")) {
                        data = data.substring(this._username.length() + 1);
                    }
                    EquinoxConsoleWebSocketServlet.this._consoleSession.processCommand(data, false);
                } else {
                    this._username = data.substring(0, data.length() - ":has joined!".length());
                }
                EquinoxConsoleWebSocketServlet.this.onFlush();
            }
        }

        public void onClose(int code, String message) {
            EquinoxConsoleWebSocketServlet.this._members.remove(this);
        }

        public void onError(String message, Throwable ex) {
        }
    }
}

