/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.jetty.osgi.boot.internal.serverfactory.DefaultJettyAtJettyHomeHelper;
import org.eclipse.jetty.osgi.boot.internal.serverfactory.JettyServerServiceTracker;
import org.eclipse.jetty.osgi.boot.internal.webapp.JettyContextHandlerServiceTracker;
import org.eclipse.jetty.osgi.boot.internal.webapp.WebBundleTrackerCustomizer;
import org.eclipse.jetty.osgi.boot.utils.internal.PackageAdminServiceTracker;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.webapp.WebAppContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyBootstrapActivator
implements BundleActivator {
    private static JettyBootstrapActivator INSTANCE = null;
    private ServiceRegistration _registeredServer;
    private Server _server;
    private JettyContextHandlerServiceTracker _jettyContextHandlerTracker;
    private PackageAdminServiceTracker _packageAdminServiceTracker;
    private BundleTracker _webBundleTracker;
    private JettyServerServiceTracker _jettyServerServiceTracker;

    public static JettyBootstrapActivator getInstance() {
        return INSTANCE;
    }

    public void start(BundleContext context) throws Exception {
        INSTANCE = this;
        this._packageAdminServiceTracker = new PackageAdminServiceTracker(context);
        this._jettyServerServiceTracker = new JettyServerServiceTracker();
        context.addServiceListener((ServiceListener)this._jettyServerServiceTracker, "(objectclass=" + Server.class.getName() + ")");
        this._jettyContextHandlerTracker = new JettyContextHandlerServiceTracker(this._jettyServerServiceTracker);
        context.addServiceListener((ServiceListener)this._jettyContextHandlerTracker, "(objectclass=" + ContextHandler.class.getName() + ")");
        DefaultJettyAtJettyHomeHelper.startJettyAtJettyHome(context);
        this._webBundleTracker = new BundleTracker(context, 48, (BundleTrackerCustomizer)new WebBundleTrackerCustomizer());
        this._webBundleTracker.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop(BundleContext context) throws Exception {
        try {
            if (this._webBundleTracker != null) {
                this._webBundleTracker.close();
                this._webBundleTracker = null;
            }
            if (this._jettyContextHandlerTracker != null) {
                this._jettyContextHandlerTracker.stop();
                context.removeServiceListener((ServiceListener)this._jettyContextHandlerTracker);
                this._jettyContextHandlerTracker = null;
            }
            if (this._jettyServerServiceTracker != null) {
                this._jettyServerServiceTracker.stop();
                context.removeServiceListener((ServiceListener)this._jettyServerServiceTracker);
                this._jettyServerServiceTracker = null;
            }
            if (this._packageAdminServiceTracker != null) {
                this._packageAdminServiceTracker.stop();
                context.removeServiceListener((ServiceListener)this._packageAdminServiceTracker);
                this._packageAdminServiceTracker = null;
            }
            if (this._registeredServer == null) return;
            try {
                this._registeredServer.unregister();
                this._registeredServer = null;
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return;
            }
            finally {
                this._registeredServer = null;
            }
        }
        finally {
            if (this._server != null) {
                this._server.stop();
            }
            INSTANCE = null;
        }
    }

    public static void registerWebapplication(Bundle contributor, String webappFolderPath, String contextPath) throws Exception {
        WebAppContext contextHandler = new WebAppContext();
        Properties dic = new Properties();
        dic.put("war", webappFolderPath);
        dic.put("contextPath", contextPath);
        contributor.getBundleContext().registerService(ContextHandler.class.getName(), (Object)contextHandler, (Dictionary)dic);
    }

    public static void registerWebapplication(Bundle contributor, String webappFolderPath, String contextPath, Dictionary<String, String> dic) throws Exception {
        WebAppContext contextHandler = new WebAppContext();
        dic.put("war", webappFolderPath);
        dic.put("contextPath", contextPath);
        contributor.getBundleContext().registerService(ContextHandler.class.getName(), (Object)contextHandler, dic);
    }

    public static void registerContext(Bundle contributor, String contextFilePath) throws Exception {
        JettyBootstrapActivator.registerContext(contributor, contextFilePath, new Hashtable<String, String>());
    }

    public static void registerContext(Bundle contributor, String contextFilePath, Dictionary<String, String> dic) throws Exception {
        ContextHandler contextHandler = new ContextHandler();
        dic.put("contextFilePath", contextFilePath);
        dic.put("unknownContextHandlerType", Boolean.TRUE.toString());
        contributor.getBundleContext().registerService(ContextHandler.class.getName(), (Object)contextHandler, dic);
    }

    public static void unregister(String contextPath) {
    }
}

