/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.jetty.osgi.boot.internal.webapp.JettyContextHandlerExtender;
import org.eclipse.jetty.osgi.boot.internal.webapp.JettyContextHandlerServiceTracker;
import org.eclipse.jetty.osgi.boot.utils.internal.PackageAdminServiceTracker;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.webapp.WebAppContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceRegistration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyBootstrapActivator
implements BundleActivator {
    private static JettyBootstrapActivator INSTANCE = null;
    private ServiceRegistration _registeredServer;
    private Server _server;
    private JettyContextHandlerServiceTracker _jettyContextHandlerTracker;
    private PackageAdminServiceTracker _packageAdminServiceTracker;

    public static JettyBootstrapActivator getInstance() {
        return INSTANCE;
    }

    public void start(BundleContext context) throws Exception {
        INSTANCE = this;
        this._packageAdminServiceTracker = new PackageAdminServiceTracker(context);
        this._server = new Server();
        this._registeredServer = context.registerService(this._server.getClass().getName(), (Object)this._server, (Dictionary)new Properties());
        this._jettyContextHandlerTracker = new JettyContextHandlerServiceTracker(context, this._server);
        context.addServiceListener((ServiceListener)this._jettyContextHandlerTracker, "(objectclass=" + ContextHandler.class.getName() + ")");
        JettyContextHandlerExtender jettyContexHandlerExtender = new JettyContextHandlerExtender();
        context.addBundleListener((BundleListener)jettyContexHandlerExtender);
        jettyContexHandlerExtender.init(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        try {
            if (this._jettyContextHandlerTracker != null) {
                this._jettyContextHandlerTracker.stop();
                context.removeServiceListener((ServiceListener)this._jettyContextHandlerTracker);
            }
            if (this._packageAdminServiceTracker != null) {
                this._packageAdminServiceTracker.stop();
                context.removeServiceListener((ServiceListener)this._packageAdminServiceTracker);
            }
            if (this._registeredServer != null) {
                try {
                    this._registeredServer.unregister();
                    this._registeredServer = null;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        finally {
            this._server.stop();
            INSTANCE = null;
        }
    }

    public static void registerWebapplication(Bundle contributor, String webappFolderPath, String contextPath) throws Exception {
        WebAppContext contextHandler = new WebAppContext();
        Properties dic = new Properties();
        dic.put("war", webappFolderPath);
        dic.put("contextPath", contextPath);
        contributor.getBundleContext().registerService(ContextHandler.class.getName(), (Object)contextHandler, (Dictionary)dic);
    }

    public static void registerWebapplication(Bundle contributor, String webappFolderPath, String contextPath, Dictionary<String, String> dic) throws Exception {
        WebAppContext contextHandler = new WebAppContext();
        dic.put("war", webappFolderPath);
        dic.put("contextPath", contextPath);
        contributor.getBundleContext().registerService(ContextHandler.class.getName(), (Object)contextHandler, dic);
    }

    public static void registerContext(Bundle contributor, String contextFilePath) throws Exception {
        JettyBootstrapActivator.registerContext(contributor, contextFilePath, new Hashtable<String, String>());
    }

    public static void registerContext(Bundle contributor, String contextFilePath, Dictionary<String, String> dic) throws Exception {
        ContextHandler contextHandler = new ContextHandler();
        dic.put("contextFilePath", contextFilePath);
        contributor.getBundleContext().registerService(ContextHandler.class.getName(), (Object)contextHandler, dic);
    }

    public static void unregister(String contextPath) {
    }
}

