/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot.jasper;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.jsp.JspFactory;
import org.eclipse.jetty.deploy.DeploymentManager;
import org.eclipse.jetty.osgi.boot.JettyBootstrapActivator;
import org.eclipse.jetty.osgi.boot.utils.BundleFileLocatorHelper;
import org.eclipse.jetty.osgi.boot.utils.TldBundleDiscoverer;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class JSTLBundleDiscoverer
implements TldBundleDiscoverer {
    private static final Logger LOG = Log.getLogger(JSTLBundleDiscoverer.class);
    private static String DEFAULT_JSTL_BUNDLE_CLASS = "org.apache.taglibs.standard.tag.el.core.WhenTag";
    private static String DEFAULT_JSP_FACTORY_IMPL_CLASS = "org.apache.jasper.runtime.JspFactoryImpl";
    private static final Set<URL> __tldBundleCache = new HashSet<URL>();

    public JSTLBundleDiscoverer() {
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass("org.apache.jasper.servlet.JspServlet");
        }
        catch (Exception e) {
            LOG.warn("Unable to locate the JspServlet: jsp support unavailable.", (Throwable)e);
            return;
        }
        try {
            Class<ServletContext> servletContextClass = ServletContext.class;
            JspFactory fact = JspFactory.getDefaultFactory();
            if (fact == null) {
                fact = (JspFactory)JettyBootstrapActivator.class.getClassLoader().loadClass(DEFAULT_JSP_FACTORY_IMPL_CLASS).newInstance();
                JspFactory.setDefaultFactory((JspFactory)fact);
            }
        }
        catch (Exception e) {
            LOG.warn("Unable to set the JspFactory: jsp support incomplete.", (Throwable)e);
        }
    }

    public URL[] getUrlsForBundlesWithTlds(DeploymentManager deployer, BundleFileLocatorHelper locatorHelper) throws Exception {
        ArrayList<URL> urls = new ArrayList<URL>();
        Class<?> jstlClass = null;
        try {
            jstlClass = JSTLBundleDiscoverer.class.getClassLoader().loadClass(DEFAULT_JSTL_BUNDLE_CLASS);
        }
        catch (ClassNotFoundException e) {
            LOG.info("jstl not on classpath", (Throwable)e);
        }
        if (jstlClass != null) {
            Bundle tldBundle = FrameworkUtil.getBundle(jstlClass);
            File tldBundleLocation = locatorHelper.getBundleInstallLocation(tldBundle);
            if (tldBundleLocation != null && tldBundleLocation.isDirectory()) {
                for (File f : tldBundleLocation.listFiles()) {
                    if (f.getName().endsWith(".jar") && f.isFile()) {
                        urls.add(f.toURI().toURL());
                        continue;
                    }
                    if (!f.isDirectory() || !f.getName().equals("lib")) continue;
                    for (File f2 : tldBundleLocation.listFiles()) {
                        if (!f2.getName().endsWith(".jar") || !f2.isFile()) continue;
                        urls.add(f2.toURI().toURL());
                    }
                }
            } else if (tldBundleLocation != null) {
                urls.add(tldBundleLocation.toURI().toURL());
                String pattern = (String)deployer.getContextAttribute("org.eclipse.jetty.server.webapp.containerIncludeBundlePattern");
                String string = pattern = pattern == null ? "" : pattern;
                if (!pattern.contains(tldBundle.getSymbolicName())) {
                    pattern = pattern + "|" + tldBundle.getSymbolicName();
                    deployer.setContextAttribute("org.eclipse.jetty.server.webapp.containerIncludeBundlePattern", (Object)pattern);
                }
            }
        }
        return urls.toArray(new URL[urls.size()]);
    }
}

