/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot.jasper;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.eclipse.jetty.deploy.DeploymentManager;
import org.eclipse.jetty.osgi.boot.utils.BundleFileLocatorHelper;
import org.eclipse.jetty.osgi.boot.utils.WebappRegistrationCustomizer;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class PluggableWebAppRegistrationCustomizerImpl
implements WebappRegistrationCustomizer {
    public static final String SYS_PROP_TLD_BUNDLES = "org.eclipse.jetty.osgi.tldbundles";

    private static Collection<String> getTldBundles(DeploymentManager deploymentManager) {
        String sysprop = System.getProperty(SYS_PROP_TLD_BUNDLES);
        String att = (String)deploymentManager.getContextAttribute("org.eclipse.jetty.server.webapp.containerIncludeBundlePattern");
        if (sysprop == null && att == null) {
            return Collections.emptySet();
        }
        if (att == null) {
            att = sysprop;
        } else if (sysprop != null) {
            att = att + "," + sysprop;
        }
        HashSet<String> tldbundles = new HashSet<String>();
        StringTokenizer tokenizer = new StringTokenizer(att, ", \n\r\t", false);
        while (tokenizer.hasMoreTokens()) {
            tldbundles.add(tokenizer.nextToken());
        }
        return tldbundles;
    }

    public URL[] getJarsWithTlds(DeploymentManager deploymentManager, BundleFileLocatorHelper locatorHelper) throws Exception {
        Bundle[] bundles = FrameworkUtil.getBundle(PluggableWebAppRegistrationCustomizerImpl.class).getBundleContext().getBundles();
        HashSet<URL> urls = new HashSet<URL>();
        String tmp = System.getProperty(SYS_PROP_TLD_BUNDLES);
        ArrayList<String> sysNames = new ArrayList<String>();
        if (tmp != null) {
            StringTokenizer tokenizer = new StringTokenizer(tmp, ", \n\r\t", false);
            while (tokenizer.hasMoreTokens()) {
                sysNames.add(tokenizer.nextToken());
            }
        }
        Pattern pattern = (tmp = (String)deploymentManager.getContextAttribute("org.eclipse.jetty.server.webapp.containerIncludeBundlePattern")) == null ? null : Pattern.compile(tmp);
        for (Bundle bundle : bundles) {
            if (sysNames.contains(bundle.getSymbolicName())) {
                this.registerTldBundle(locatorHelper, bundle, urls);
            }
            if (pattern == null || !pattern.matcher(bundle.getSymbolicName()).matches()) continue;
            this.registerTldBundle(locatorHelper, bundle, urls);
        }
        return urls.toArray(new URL[urls.size()]);
    }

    private void registerTldBundle(BundleFileLocatorHelper locatorHelper, Bundle bundle, Set<URL> urls) throws Exception {
        File jasperLocation = locatorHelper.getBundleInstallLocation(bundle);
        if (jasperLocation.isDirectory()) {
            for (File f : jasperLocation.listFiles()) {
                if (f.getName().endsWith(".jar") && f.isFile()) {
                    urls.add(f.toURI().toURL());
                    continue;
                }
                if (!f.isDirectory() || !f.getName().equals("lib")) continue;
                for (File f2 : jasperLocation.listFiles()) {
                    if (!f2.getName().endsWith(".jar") || !f2.isFile()) continue;
                    urls.add(f2.toURI().toURL());
                }
            }
            urls.add(jasperLocation.toURI().toURL());
        } else {
            urls.add(jasperLocation.toURI().toURL());
        }
    }
}

