/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.osgi.boot.jsp;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import org.eclipse.jetty.osgi.boot.OSGiWebappConstants;
import org.eclipse.jetty.osgi.boot.utils.internal.DefaultFileLocatorHelper;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.TagLibConfiguration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagLibOSGiConfiguration
extends TagLibConfiguration {
    private static final Logger LOG = Log.getLogger(TagLibOSGiConfiguration.class);
    private ServiceTracker packageAdminServiceTracker = null;

    public void preConfigure(WebAppContext context) throws Exception {
        Collection<Resource> resources;
        String requireTldBundle = (String)context.getAttribute("Require-TldBundle");
        if (requireTldBundle != null && (resources = this.getRequireTldBundleAsJettyResources(context, requireTldBundle)) != null && !resources.isEmpty()) {
            Collection previouslySet = (Collection)context.getAttribute("org.eclipse.jetty.tlds");
            if (previouslySet != null) {
                resources.addAll(previouslySet);
            }
            context.setAttribute("org.eclipse.jetty.tlds", resources);
        }
        super.preConfigure(context);
    }

    private Collection<Resource> getRequireTldBundleAsJettyResources(WebAppContext context, String requireTldBundle) {
        Bundle bundle = (Bundle)context.getAttribute("osgi-bundle");
        PackageAdmin packAdmin = this.getBundleAdmin();
        String[] symbNames = requireTldBundle.split(", ");
        LinkedHashSet<Resource> tlds = new LinkedHashSet<Resource>();
        for (String symbName : symbNames) {
            Bundle[] bs = packAdmin.getBundles(symbName, null);
            if (bs == null || bs.length == 0) {
                throw new IllegalArgumentException("Unable to locate the bundle '" + symbName + "' specified in the " + "Require-TldBundle" + " of the manifest of " + bundle.getSymbolicName());
            }
            Enumeration en = bs[0].findEntries("META-INF", "*.tld", false);
            boolean atLeastOneTldFound = false;
            while (en.hasMoreElements()) {
                Resource tldResource;
                atLeastOneTldFound = true;
                URL oriUrl = (URL)en.nextElement();
                URL url = DefaultFileLocatorHelper.getLocalURL((URL)oriUrl);
                try {
                    tldResource = Resource.newResource((URL)url);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Unable to locate the tld resource in '" + url.toString() + "' in the bundle '" + bs[0].getSymbolicName() + "' while registering the " + "Require-TldBundle" + " of the manifest of " + bundle.getSymbolicName(), e);
                }
                tlds.add(tldResource);
            }
            if (atLeastOneTldFound) continue;
            LOG.warn("No '/META-INF/*.tld' resources were found  in the bundle '" + bs[0].getSymbolicName() + "' while registering the " + "Require-TldBundle" + " of the manifest of " + bundle.getSymbolicName(), new Object[0]);
        }
        return tlds;
    }

    private PackageAdmin getBundleAdmin() {
        if (this.packageAdminServiceTracker == null) {
            Bundle bootBundle = ((BundleReference)OSGiWebappConstants.class.getClassLoader()).getBundle();
            this.packageAdminServiceTracker = new ServiceTracker(bootBundle.getBundleContext(), PackageAdmin.class.getName(), null);
            this.packageAdminServiceTracker.open();
        }
        return (PackageAdmin)this.packageAdminServiceTracker.getService();
    }
}

