/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.AsyncEndPoint;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.nio.IndirectNIOBuffer;
import org.eclipse.jetty.io.nio.SelectChannelEndPoint;
import org.eclipse.jetty.util.Utf8StringBuilder;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.websocket.Extension;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketBuffers;
import org.eclipse.jetty.websocket.WebSocketConnection;
import org.eclipse.jetty.websocket.WebSocketGenerator;
import org.eclipse.jetty.websocket.WebSocketGeneratorD00;
import org.eclipse.jetty.websocket.WebSocketParser;
import org.eclipse.jetty.websocket.WebSocketParserD00;

public class WebSocketConnectionD00
extends AbstractConnection
implements WebSocketConnection,
WebSocket.FrameConnection {
    public static final byte LENGTH_FRAME = -128;
    public static final byte SENTINEL_FRAME = 0;
    final IdleCheck _idle;
    final WebSocketParser _parser;
    final WebSocketGenerator _generator;
    final WebSocket _websocket;
    final String _protocol;
    String _key1;
    String _key2;
    ByteArrayBuffer _hixieBytes;

    public WebSocketConnectionD00(WebSocket websocket, EndPoint endpoint, WebSocketBuffers buffers, long timestamp, int maxIdleTime, String protocol) throws IOException {
        super(endpoint, timestamp);
        if (endpoint instanceof AsyncEndPoint) {
            ((AsyncEndPoint)endpoint).cancelIdle();
        }
        this._endp.setMaxIdleTime(maxIdleTime);
        this._websocket = websocket;
        this._protocol = protocol;
        this._generator = new WebSocketGeneratorD00(buffers, this._endp);
        this._parser = new WebSocketParserD00(buffers, endpoint, new FrameHandlerD0(this._websocket));
        if (this._endp instanceof SelectChannelEndPoint) {
            final SelectChannelEndPoint scep = (SelectChannelEndPoint)this._endp;
            scep.cancelIdle();
            this._idle = new IdleCheck(){

                @Override
                public void access(EndPoint endp) {
                    scep.scheduleIdle();
                }
            };
            scep.scheduleIdle();
        } else {
            this._idle = new IdleCheck(){

                @Override
                public void access(EndPoint endp) {
                }
            };
        }
    }

    public void setHixieKeys(String key1, String key2) {
        this._key1 = key1;
        this._key2 = key2;
        this._hixieBytes = new IndirectNIOBuffer(16);
    }

    public Connection handle() throws IOException {
        try {
            if (this._hixieBytes != null) {
                Buffer buffer = this._parser.getBuffer();
                if (buffer != null && buffer.length() > 0) {
                    int l = buffer.length();
                    if (l > 8 - this._hixieBytes.length()) {
                        l = 8 - this._hixieBytes.length();
                    }
                    this._hixieBytes.put(buffer.peek(buffer.getIndex(), l));
                    buffer.skip(l);
                }
                while (this._endp.isOpen()) {
                    if (this._hixieBytes.length() == 8) {
                        this.doTheHixieHixieShake();
                        this._endp.flush((Buffer)this._hixieBytes);
                        this._hixieBytes = null;
                        this._endp.flush();
                        break;
                    }
                    int filled = this._endp.fill((Buffer)this._hixieBytes);
                    if (filled >= 0) continue;
                    this._endp.close();
                    break;
                }
                if (this._websocket instanceof WebSocket.OnFrame) {
                    ((WebSocket.OnFrame)this._websocket).onHandshake(this);
                }
                this._websocket.onOpen(this);
                WebSocketConnectionD00 filled = this;
                return filled;
            }
            boolean progress = true;
            while (progress) {
                int flushed = this._generator.flush();
                int filled = this._parser.parseNext();
                boolean bl = progress = flushed > 0 || filled > 0;
                if (filled >= 0 && flushed >= 0) continue;
                this._endp.close();
                break;
            }
        }
        catch (IOException e) {
            Log.debug((Throwable)e);
            try {
                this._endp.close();
            }
            catch (IOException e2) {
                Log.ignore((Throwable)e2);
            }
            throw e;
        }
        finally {
            if (this._endp.isOpen()) {
                this._idle.access(this._endp);
                if (this._endp.isInputShutdown() && this._generator.isBufferEmpty()) {
                    this._endp.close();
                } else {
                    this.checkWriteable();
                }
                this.checkWriteable();
            }
        }
        return this;
    }

    private void doTheHixieHixieShake() {
        byte[] result = WebSocketConnectionD00.doTheHixieHixieShake(WebSocketConnectionD00.hixieCrypt(this._key1), WebSocketConnectionD00.hixieCrypt(this._key2), this._hixieBytes.asArray());
        this._hixieBytes.clear();
        this._hixieBytes.put(result);
    }

    @Override
    public boolean isOpen() {
        return this._endp != null && this._endp.isOpen();
    }

    public boolean isIdle() {
        return this._parser.isBufferEmpty() && this._generator.isBufferEmpty();
    }

    public boolean isSuspended() {
        return false;
    }

    public void closed() {
        this._websocket.onClose(1000, "");
    }

    @Override
    public void sendMessage(String content) throws IOException {
        byte[] data = content.getBytes("UTF-8");
        this._generator.addFrame((byte)0, (byte)0, data, 0, data.length);
        this._generator.flush();
        this.checkWriteable();
        this._idle.access(this._endp);
    }

    @Override
    public void sendMessage(byte[] data, int offset, int length) throws IOException {
        this._generator.addFrame((byte)0, (byte)-128, data, offset, length);
        this._generator.flush();
        this.checkWriteable();
        this._idle.access(this._endp);
    }

    public boolean isMore(byte flags) {
        return (flags & 8) != 0;
    }

    @Override
    public void sendControl(byte code, byte[] content, int offset, int length) throws IOException {
    }

    @Override
    public void sendFrame(byte flags, byte opcode, byte[] content, int offset, int length) throws IOException {
        this._generator.addFrame((byte)0, opcode, content, offset, length);
        this._generator.flush();
        this.checkWriteable();
        this._idle.access(this._endp);
    }

    @Override
    public void close(int code, String message) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void disconnect() {
        try {
            this._generator.flush();
            this._endp.close();
        }
        catch (IOException e) {
            Log.ignore((Throwable)e);
        }
    }

    @Override
    public void fillBuffersFrom(Buffer buffer) {
        this._parser.fill(buffer);
    }

    private void checkWriteable() {
        if (!this._generator.isBufferEmpty() && this._endp instanceof AsyncEndPoint) {
            ((AsyncEndPoint)this._endp).scheduleWrite();
        }
    }

    static long hixieCrypt(String key) {
        long number = 0L;
        int spaces = 0;
        for (char c : key.toCharArray()) {
            if (Character.isDigit(c)) {
                number = number * 10L + (long)(c - 48);
                continue;
            }
            if (c != ' ') continue;
            ++spaces;
        }
        return number / (long)spaces;
    }

    public static byte[] doTheHixieHixieShake(long key1, long key2, byte[] key3) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] fodder = new byte[16];
            fodder[0] = (byte)(0xFFL & key1 >> 24);
            fodder[1] = (byte)(0xFFL & key1 >> 16);
            fodder[2] = (byte)(0xFFL & key1 >> 8);
            fodder[3] = (byte)(0xFFL & key1);
            fodder[4] = (byte)(0xFFL & key2 >> 24);
            fodder[5] = (byte)(0xFFL & key2 >> 16);
            fodder[6] = (byte)(0xFFL & key2 >> 8);
            fodder[7] = (byte)(0xFFL & key2);
            for (int i = 0; i < 8; ++i) {
                fodder[8 + i] = key3[i];
            }
            md.update(fodder);
            byte[] result = md.digest();
            return result;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void handshake(HttpServletRequest request, HttpServletResponse response, String origin, String subprotocol) throws IOException {
        String uri = request.getRequestURI();
        String query = request.getQueryString();
        if (query != null && query.length() > 0) {
            uri = uri + "?" + query;
        }
        String host = request.getHeader("Host");
        String key1 = request.getHeader("Sec-WebSocket-Key1");
        if (key1 != null) {
            String key2 = request.getHeader("Sec-WebSocket-Key2");
            this.setHixieKeys(key1, key2);
            response.setHeader("Upgrade", "WebSocket");
            response.addHeader("Connection", "Upgrade");
            response.addHeader("Sec-WebSocket-Origin", origin);
            response.addHeader("Sec-WebSocket-Location", (request.isSecure() ? "wss://" : "ws://") + host + uri);
            if (subprotocol != null) {
                response.addHeader("Sec-WebSocket-Protocol", subprotocol);
            }
            response.sendError(101, "WebSocket Protocol Handshake");
        } else {
            response.setHeader("Upgrade", "WebSocket");
            response.addHeader("Connection", "Upgrade");
            response.addHeader("WebSocket-Origin", origin);
            response.addHeader("WebSocket-Location", (request.isSecure() ? "wss://" : "ws://") + host + uri);
            if (subprotocol != null) {
                response.addHeader("WebSocket-Protocol", subprotocol);
            }
            response.sendError(101, "Web Socket Protocol Handshake");
            response.flushBuffer();
            if (this._websocket instanceof WebSocket.OnFrame) {
                ((WebSocket.OnFrame)this._websocket).onHandshake(this);
            }
            this._websocket.onOpen(this);
        }
    }

    @Override
    public void setMaxTextMessageSize(int size) {
    }

    @Override
    public void setMaxBinaryMessageSize(int size) {
    }

    @Override
    public int getMaxTextMessageSize() {
        return -1;
    }

    @Override
    public int getMaxBinaryMessageSize() {
        return -1;
    }

    @Override
    public String getProtocol() {
        return this._protocol;
    }

    @Override
    public boolean isMessageComplete(byte flags) {
        return true;
    }

    @Override
    public byte binaryOpcode() {
        return -128;
    }

    @Override
    public byte textOpcode() {
        return 0;
    }

    @Override
    public boolean isControl(byte opcode) {
        return false;
    }

    @Override
    public boolean isText(byte opcode) {
        return (opcode & 0xFFFFFF80) == 0;
    }

    @Override
    public boolean isBinary(byte opcode) {
        return (opcode & 0xFFFFFF80) != 0;
    }

    @Override
    public boolean isContinuation(byte opcode) {
        return false;
    }

    @Override
    public boolean isClose(byte opcode) {
        return false;
    }

    @Override
    public boolean isPing(byte opcode) {
        return false;
    }

    @Override
    public boolean isPong(byte opcode) {
        return false;
    }

    @Override
    public List<Extension> getExtensions() {
        return Collections.emptyList();
    }

    @Override
    public byte continuationOpcode() {
        return 0;
    }

    @Override
    public byte finMask() {
        return 0;
    }

    class FrameHandlerD0
    implements WebSocketParser.FrameHandler {
        final WebSocket _websocket;
        final Utf8StringBuilder _utf8 = new Utf8StringBuilder();

        FrameHandlerD0(WebSocket websocket) {
            this._websocket = websocket;
        }

        @Override
        public void onFrame(byte flags, byte opcode, Buffer buffer) {
            try {
                byte[] array = buffer.array();
                if (opcode == 0) {
                    if (this._websocket instanceof WebSocket.OnTextMessage) {
                        ((WebSocket.OnTextMessage)this._websocket).onMessage(buffer.toString("UTF-8"));
                    }
                } else if (this._websocket instanceof WebSocket.OnBinaryMessage) {
                    ((WebSocket.OnBinaryMessage)this._websocket).onMessage(array, buffer.getIndex(), buffer.length());
                }
            }
            catch (ThreadDeath th) {
                throw th;
            }
            catch (Throwable th) {
                Log.warn((Throwable)th);
            }
        }

        @Override
        public void close(int code, String message) {
            this.close(code, message);
        }
    }

    private static interface IdleCheck {
        public void access(EndPoint var1);
    }
}

