/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.bio.SocketEndPoint;
import org.eclipse.jetty.util.B64Code;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.websocket.WebSocketBuffers;
import org.eclipse.jetty.websocket.WebSocketConnectionD06;
import org.eclipse.jetty.websocket.WebSocketGeneratorD06;
import org.eclipse.jetty.websocket.WebSocketParser;
import org.eclipse.jetty.websocket.WebSocketParserD06;

public class TestClient {
    private static final Random __random = new SecureRandom();
    private static boolean _verbose = false;
    private final String _host;
    private final int _port;
    private final String _protocol;
    private int _size = 64;
    private final Socket _socket;
    private final BufferedWriter _output;
    private final BufferedReader _input;
    private final SocketEndPoint _endp;
    private final WebSocketGeneratorD06 _generator;
    private final WebSocketParserD06 _parser;
    private int _framesSent;
    private int _messagesSent;
    private int _framesReceived;
    private int _messagesReceived;
    private long _totalTime;
    private long _minDuration = Long.MAX_VALUE;
    private long _maxDuration = Long.MIN_VALUE;
    private long _start;
    private BlockingQueue<Long> _starts = new LinkedBlockingQueue<Long>();
    int _messageBytes;
    int _frames;
    byte _opcode = (byte)-1;
    private final WebSocketParser.FrameHandler _handler = new WebSocketParser.FrameHandler(){

        public synchronized void onFrame(byte flags, byte opcode, Buffer buffer) {
            try {
                TestClient.this._framesReceived++;
                ++TestClient.this._frames;
                if (opcode == 1) {
                    byte[] data = buffer.asArray();
                    System.err.println("CLOSED: " + ((0xFF & data[0]) * 256 + (0xFF & data[1])) + " " + new String(data, 2, data.length - 2, "UTF-8"));
                    TestClient.this._generator.addFrame((byte)8, (byte)1, data, 0, data.length, TestClient.this._socket.getSoTimeout());
                    TestClient.this._generator.flush(TestClient.this._socket.getSoTimeout());
                    TestClient.this._socket.shutdownOutput();
                    TestClient.this._socket.close();
                    return;
                }
                TestClient.this._messageBytes += buffer.length();
                if (TestClient.this._opcode == -1) {
                    TestClient.this._opcode = opcode;
                }
                if (WebSocketConnectionD06.isLastFrame(flags)) {
                    TestClient.this._messagesReceived++;
                    Long start = (Long)TestClient.this._starts.take();
                    long duration = System.nanoTime() - start;
                    if (duration > TestClient.this._maxDuration) {
                        TestClient.this._maxDuration = duration;
                    }
                    if (duration < TestClient.this._minDuration) {
                        TestClient.this._minDuration = duration;
                    }
                    TestClient.this._totalTime += duration;
                    System.out.printf("%d bytes from %s: frames=%d req=%d time=%.1fms opcode=0x%s\n", TestClient.this._messageBytes, TestClient.this._host, TestClient.this._frames, TestClient.this._messagesReceived, (double)duration / 1000000.0, TypeUtil.toHexString((byte)TestClient.this._opcode));
                    TestClient.this._frames = 0;
                    TestClient.this._messageBytes = 0;
                    TestClient.this._opcode = (byte)-1;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void close(int code, String message) {
        }
    };

    public TestClient(String host, int port, String protocol, int timeoutMS) throws IOException {
        this._host = host;
        this._port = port;
        this._protocol = protocol;
        this._socket = new Socket(host, port);
        this._socket.setSoTimeout(timeoutMS);
        this._output = new BufferedWriter(new OutputStreamWriter(this._socket.getOutputStream(), "ISO-8859-1"));
        this._input = new BufferedReader(new InputStreamReader(this._socket.getInputStream(), "ISO-8859-1"));
        this._endp = new SocketEndPoint(this._socket);
        this._generator = new WebSocketGeneratorD06(new WebSocketBuffers(32768), (EndPoint)this._endp, new WebSocketGeneratorD06.FixedMaskGen(new byte[4]));
        this._parser = new WebSocketParserD06(new WebSocketBuffers(32768), (EndPoint)this._endp, this._handler, false);
    }

    public int getSize() {
        return this._size;
    }

    public void setSize(int size) {
        this._size = size;
    }

    private void open() throws IOException {
        String line;
        System.out.println("Jetty WebSocket PING " + this._host + ":" + this._port + " (" + this._socket.getRemoteSocketAddress() + ") " + this._size + " bytes of data.");
        byte[] key = new byte[16];
        __random.nextBytes(key);
        this._output.write("GET /chat HTTP/1.1\r\nHost: " + this._host + ":" + this._port + "\r\n" + "Upgrade: websocket\r\n" + "Connection: Upgrade\r\n" + "Sec-WebSocket-Key: " + new String(B64Code.encode((byte[])key)) + "\r\n" + "Sec-WebSocket-Origin: http://example.com\r\n" + "Sec-WebSocket-Protocol: " + this._protocol + "\r\n" + "Sec-WebSocket-Version: 6\r\n" + "\r\n");
        this._output.flush();
        String responseLine = this._input.readLine();
        if (!responseLine.startsWith("HTTP/1.1 101 Switching Protocols")) {
            throw new IOException(responseLine);
        }
        boolean accepted = false;
        String protocol = "";
        while ((line = this._input.readLine()) != null && line.length() != 0) {
            if (line.startsWith("Sec-WebSocket-Accept:")) {
                String accept = line.substring(21).trim();
                accepted = accept.equals(WebSocketConnectionD06.hashKey(new String(B64Code.encode((byte[])key))));
                continue;
            }
            if (!line.startsWith("Sec-WebSocket-Protocol:")) continue;
            protocol = line.substring(24).trim();
        }
        if (!accepted) {
            throw new IOException("Bad Sec-WebSocket-Accept");
        }
        System.out.println("handshake OK for protocol '" + protocol + "'");
        new Thread(){

            public void run() {
                while (TestClient.this._endp.isOpen()) {
                    TestClient.this._parser.parseNext();
                }
            }
        }.start();
    }

    public void ping(int count, byte opcode, int fragment) {
        try {
            this._start = System.currentTimeMillis();
            for (int i = 0; i < count && !this._socket.isClosed() && !this._socket.isClosed(); ++i) {
                byte[] data = null;
                if (opcode == 4) {
                    StringBuilder b = new StringBuilder();
                    while (b.length() < this._size) {
                        b.append(65 + __random.nextInt(26));
                    }
                    data = b.toString().getBytes("UTF-8");
                } else {
                    data = new byte[this._size];
                    __random.nextBytes(data);
                }
                this._starts.add(System.nanoTime());
                int off = 0;
                int len = data.length;
                if (fragment > 0 && len > fragment) {
                    len = fragment;
                }
                ++this._messagesSent;
                while (off < data.length) {
                    byte op;
                    ++this._framesSent;
                    byte flags = (byte)(off + len == data.length ? 8 : 0);
                    byte by = op = off == 0 ? opcode : (byte)0;
                    if (_verbose) {
                        System.err.printf("%s#addFrame %s|%s %s\n", this.getClass().getSimpleName(), TypeUtil.toHexString((byte)flags), TypeUtil.toHexString((byte)op), TypeUtil.toHexString((byte[])data, (int)off, (int)len));
                    }
                    this._generator.addFrame(flags, op, data, off, len, this._socket.getSoTimeout());
                    if (data.length - (off += len) > len) {
                        len = data.length - off;
                    }
                    if (fragment <= 0 || len <= fragment) continue;
                    len = fragment;
                }
                this._generator.flush(this._socket.getSoTimeout());
                Thread.sleep(1000L);
            }
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    public void dump() throws Exception {
        for (int i = 0; i < 250 && this._messagesSent != this._messagesReceived; ++i) {
            this._generator.flush(10);
            Thread.sleep(100L);
        }
        this._socket.close();
        long duration = System.currentTimeMillis() - this._start;
        System.out.println("--- " + this._host + " websocket ping statistics using 1 connection ---");
        System.out.println(this._framesSent + " frames transmitted, " + this._framesReceived + " received, " + this._messagesSent + " messages transmitted, " + this._messagesReceived + " received, " + "time " + duration + "ms");
        System.out.printf("rtt min/ave/max = %.3f/%.3f/%.3f ms\n", (double)this._minDuration / 1000000.0, this._messagesReceived == 0 ? 0.0 : (double)(this._totalTime / (long)this._messagesReceived) / 1000000.0, (double)this._maxDuration / 1000000.0);
    }

    private static void usage(String[] args) {
        System.err.println("ERROR: " + Arrays.asList(args));
        System.err.println("USAGE: java -cp CLASSPATH " + TestClient.class + " [ OPTIONS ]");
        System.err.println("  -h|--host HOST  (default localhost)");
        System.err.println("  -p|--port PORT  (default 8080)");
        System.err.println("  -b|--binary");
        System.err.println("  -v|--verbose");
        System.err.println("  -c|--count n    (default 10)");
        System.err.println("  -s|--size n     (default 64)");
        System.err.println("  -f|--fragment n (default 4000) ");
        System.err.println("  -P|--protocol echo|echo-assemble|echo-fragment|echo-broadcast");
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            String host = "localhost";
            int port = 8080;
            String protocol = null;
            int count = 10;
            int size = 64;
            int fragment = 4000;
            boolean binary = false;
            for (int i = 0; i < args.length; ++i) {
                String a = args[i];
                if ("-p".equals(a) || "--port".equals(a)) {
                    port = Integer.parseInt(args[++i]);
                    continue;
                }
                if ("-h".equals(a) || "--host".equals(a)) {
                    port = Integer.parseInt(args[++i]);
                    continue;
                }
                if ("-c".equals(a) || "--count".equals(a)) {
                    count = Integer.parseInt(args[++i]);
                    continue;
                }
                if ("-s".equals(a) || "--size".equals(a)) {
                    size = Integer.parseInt(args[++i]);
                    continue;
                }
                if ("-f".equals(a) || "--fragment".equals(a)) {
                    fragment = Integer.parseInt(args[++i]);
                    continue;
                }
                if ("-P".equals(a) || "--protocol".equals(a)) {
                    protocol = args[++i];
                    continue;
                }
                if ("-v".equals(a) || "--verbose".equals(a)) {
                    _verbose = true;
                    continue;
                }
                if ("-b".equals(a) || "--binary".equals(a)) {
                    binary = true;
                    continue;
                }
                if (!a.startsWith("-")) continue;
                TestClient.usage(args);
            }
            TestClient client = new TestClient(host, port, protocol == null ? null : "org.ietf.websocket.test-" + protocol, 10000);
            client.setSize(size);
            try {
                client.open();
                if (protocol != null && protocol.startsWith("echo")) {
                    client.ping(count, binary ? (byte)5 : 4, fragment);
                } else {
                    client.ping(count, (byte)2, -1);
                }
            }
            finally {
                client.dump();
            }
        }
        catch (Exception e) {
            Log.warn((Throwable)e);
        }
    }
}

