/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.webapp;

import java.io.IOException;
import java.net.MalformedURLException;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.AbstractConfiguration;
import org.eclipse.jetty.webapp.StandardDescriptorProcessor;
import org.eclipse.jetty.webapp.WebAppContext;

public class WebXmlConfiguration
extends AbstractConfiguration {
    private static final Logger LOG = Log.getLogger(WebXmlConfiguration.class);

    @Override
    public void preConfigure(WebAppContext context) throws Exception {
        Resource webxml;
        String defaultsDescriptor = context.getDefaultsDescriptor();
        if (defaultsDescriptor != null && defaultsDescriptor.length() > 0) {
            Resource dftResource = Resource.newSystemResource((String)defaultsDescriptor);
            if (dftResource == null) {
                dftResource = context.newResource(defaultsDescriptor);
            }
            context.getMetaData().setDefaults(dftResource);
        }
        if ((webxml = this.findWebXml(context)) != null) {
            context.getMetaData().setWebXml(webxml);
            context.getServletContext().setEffectiveMajorVersion(context.getMetaData().getWebXml().getMajorVersion());
            context.getServletContext().setEffectiveMinorVersion(context.getMetaData().getWebXml().getMinorVersion());
        }
        for (String overrideDescriptor : context.getOverrideDescriptors()) {
            if (overrideDescriptor == null || overrideDescriptor.length() <= 0) continue;
            Resource orideResource = Resource.newSystemResource((String)overrideDescriptor);
            if (orideResource == null) {
                orideResource = context.newResource(overrideDescriptor);
            }
            context.getMetaData().addOverride(orideResource);
        }
    }

    @Override
    public void configure(WebAppContext context) throws Exception {
        if (context.isStarted()) {
            LOG.debug("Cannot configure webapp after it is started", new Object[0]);
            return;
        }
        context.getMetaData().addDescriptorProcessor(new StandardDescriptorProcessor());
    }

    protected Resource findWebXml(WebAppContext context) throws IOException, MalformedURLException {
        Resource web;
        String descriptor = context.getDescriptor();
        if (descriptor != null && (web = context.newResource(descriptor)).exists() && !web.isDirectory()) {
            return web;
        }
        Resource web_inf = context.getWebInf();
        if (web_inf != null && web_inf.isDirectory()) {
            Resource web2 = web_inf.addPath("web.xml");
            if (web2.exists()) {
                return web2;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("No WEB-INF/web.xml in " + context.getWar() + ". Serving files and default/dynamic servlets only", new Object[0]);
            }
        }
        return null;
    }

    @Override
    public void deconfigure(WebAppContext context) throws Exception {
        ServletHandler _servletHandler = context.getServletHandler();
        _servletHandler.setFilters(null);
        _servletHandler.setFilterMappings(null);
        _servletHandler.setServlets(null);
        _servletHandler.setServletMappings(null);
        context.setEventListeners(null);
        context.setWelcomeFiles(null);
        if (context.getErrorHandler() instanceof ErrorPageErrorHandler) {
            ((ErrorPageErrorHandler)context.getErrorHandler()).setErrorPages(null);
        }
    }
}

