/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.webapp;

import java.util.ArrayList;
import java.util.StringTokenizer;

public class ClasspathPattern {
    private ArrayList<String> _patterns = null;
    private ArrayList<Entry> _entries = null;

    public ClasspathPattern(String[] patterns) {
        this.setPatterns(patterns);
    }

    public ClasspathPattern(String pattern) {
        this.setPattern(pattern);
    }

    public static ClasspathPattern fromArray(String[] patterns) {
        return new ClasspathPattern(patterns);
    }

    public static ClasspathPattern fromString(String patterns) {
        return new ClasspathPattern(patterns);
    }

    private void setPatterns(String[] patterns) {
        if (patterns == null) {
            this._patterns = null;
            this._entries = null;
        } else {
            this._patterns = new ArrayList();
            this._entries = new ArrayList();
        }
        if (this._patterns != null) {
            Entry entry = null;
            for (String pattern : patterns) {
                entry = this.createEntry(pattern);
                if (entry == null) continue;
                this._patterns.add(pattern);
                this._entries.add(entry);
            }
        }
    }

    private void addPatterns(String[] patterns) {
        if (patterns != null) {
            if (this._patterns == null) {
                this.setPatterns(patterns);
            } else {
                Entry entry = null;
                for (String pattern : patterns) {
                    entry = this.createEntry(pattern);
                    if (entry == null) continue;
                    this._patterns.add(pattern);
                    this._entries.add(entry);
                }
            }
        }
    }

    private Entry createEntry(String pattern) {
        String item;
        Entry entry = null;
        if (pattern != null && (item = pattern.trim()).length() > 0) {
            entry = new Entry();
            entry.result = !item.startsWith("-");
            entry.partial = item.endsWith(".");
            entry.classpath = entry.result ? item : item.substring(1).trim();
        }
        return entry;
    }

    public void setPattern(String pattern) {
        ArrayList<String> patterns = new ArrayList<String>();
        StringTokenizer entries = new StringTokenizer(pattern, ":,");
        while (entries.hasMoreTokens()) {
            patterns.add(entries.nextToken());
        }
        this.setPatterns((String[])patterns.toArray());
    }

    public void addPattern(String pattern) {
        ArrayList<String> patterns = new ArrayList<String>();
        StringTokenizer entries = new StringTokenizer(pattern, ":,");
        while (entries.hasMoreTokens()) {
            patterns.add(entries.nextToken());
        }
        this.addPatterns((String[])patterns.toArray());
    }

    public String[] getPatterns() {
        String[] patterns = null;
        if (this._patterns != null) {
            patterns = this._patterns.toArray(new String[this._patterns.size()]);
        }
        return patterns;
    }

    public boolean match(String name) {
        boolean result = false;
        if (this._entries != null) {
            boolean startIdx = false;
            name = name.replace('/', '.');
            name = name.replaceFirst("^[.]+", "");
            for (Entry entry : this._entries) {
                if (entry == null) continue;
                if (entry.partial) {
                    if (!name.startsWith(entry.classpath)) continue;
                    result = entry.result;
                    break;
                }
                if (!name.equals(entry.classpath)) continue;
                result = entry.result;
                break;
            }
        }
        return result;
    }

    private class Entry {
        public String classpath = null;
        public boolean result = false;
        public boolean partial = false;

        private Entry() {
        }
    }
}

