/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.webapp;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.servlet.Servlet;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebXmlConfiguration;
import org.eclipse.jetty.xml.XmlParser;

public class TagLibConfiguration
implements Configuration {
    public static final String TLD_RESOURCES = "org.eclipse.jetty.tlds";
    private static final String __web_inf_pattern = "org.eclipse.jetty.webapp.WebInfIncludeTLDJarPattern";
    private static final String __container_pattern = "org.eclipse.jetty.server.webapp.ContainerIncludeTLDJarPattern";

    public void preConfigure(WebAppContext context) throws Exception {
        Collection tld_resources;
        Resource web_inf;
        HashSet<Resource> tlds = new HashSet<Resource>();
        if (context.getResourceAliases() != null && context.getBaseResource() != null && context.getBaseResource().exists()) {
            for (String location : context.getResourceAliases().values()) {
                if (location == null || !location.toLowerCase().endsWith(".tld")) continue;
                if (!location.startsWith("/")) {
                    location = "/WEB-INF/" + location;
                }
                Resource l = context.getBaseResource().addPath(location);
                tlds.add(l);
            }
        }
        if ((web_inf = context.getWebInf()) != null) {
            String[] contents = web_inf.list();
            for (int i = 0; contents != null && i < contents.length; ++i) {
                if (contents[i] == null || !contents[i].toLowerCase().endsWith(".tld")) continue;
                Resource l = context.getWebInf().addPath(contents[i]);
                tlds.add(l);
            }
        }
        if ((tld_resources = (Collection)context.getAttribute(TLD_RESOURCES)) != null) {
            tlds.addAll(tld_resources);
        }
        TldProcessor processor = new TldProcessor(context);
        context.setAttribute("org.eclipse.jetty.tagLibProcessor", processor);
        Iterator iter = tlds.iterator();
        while (iter.hasNext()) {
            try {
                Resource tld = (Resource)iter.next();
                if (Log.isDebugEnabled()) {
                    Log.debug((String)("TLD=" + tld));
                }
                processor.parse(tld);
            }
            catch (Exception e) {
                Log.warn((Throwable)e);
            }
        }
    }

    public void configure(WebAppContext context) throws Exception {
        TldProcessor processor = (TldProcessor)context.getAttribute("org.eclipse.jetty.tagLibProcessor");
        if (processor == null) {
            Log.warn((String)"No TldProcessor configured, skipping tld processing");
            return;
        }
        processor.processRoots();
    }

    public void postConfigure(WebAppContext context) throws Exception {
    }

    public void deconfigure(WebAppContext context) throws Exception {
    }

    public class TldProcessor {
        public static final String __taglib_processor = "org.eclipse.jetty.tagLibProcessor";
        XmlParser _parser;
        WebAppContext _context;
        List<XmlParser.Node> _roots = new ArrayList<XmlParser.Node>();

        public TldProcessor(WebAppContext context) throws Exception {
            this._context = context;
            this.createParser();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void createParser() throws Exception {
            URL taglib21;
            URL taglib20;
            URL taglib12;
            URL taglib11;
            block19: {
                block20: {
                    this._parser = new XmlParser(false);
                    taglib11 = null;
                    taglib12 = null;
                    taglib20 = null;
                    taglib21 = null;
                    try {
                        try {
                            Class jsp_page = Loader.loadClass(WebXmlConfiguration.class, (String)"javax.servlet.jsp.JspPage");
                            taglib11 = jsp_page.getResource("javax/servlet/jsp/resources/web-jsptaglibrary_1_1.dtd");
                            taglib12 = jsp_page.getResource("javax/servlet/jsp/resources/web-jsptaglibrary_1_2.dtd");
                            taglib20 = jsp_page.getResource("javax/servlet/jsp/resources/web-jsptaglibrary_2_0.xsd");
                            taglib21 = jsp_page.getResource("javax/servlet/jsp/resources/web-jsptaglibrary_2_1.xsd");
                        }
                        catch (Exception e) {
                            Log.ignore((Throwable)e);
                            Object var7_8 = null;
                            if (taglib11 == null) {
                                taglib11 = Loader.getResource(Servlet.class, (String)"javax/servlet/jsp/resources/web-jsptaglibrary_1_1.dtd", (boolean)true);
                            }
                            if (taglib12 == null) {
                                taglib12 = Loader.getResource(Servlet.class, (String)"javax/servlet/jsp/resources/web-jsptaglibrary_1_2.dtd", (boolean)true);
                            }
                            if (taglib20 == null) {
                                taglib20 = Loader.getResource(Servlet.class, (String)"javax/servlet/jsp/resources/web-jsptaglibrary_2_0.xsd", (boolean)true);
                            }
                            if (taglib21 == null) {
                                taglib21 = Loader.getResource(Servlet.class, (String)"javax/servlet/jsp/resources/web-jsptaglibrary_2_1.xsd", (boolean)true);
                            }
                            break block19;
                        }
                        Object var7_7 = null;
                        if (taglib11 != null) break block20;
                    }
                    catch (Throwable throwable) {
                        Object var7_9 = null;
                        if (taglib11 == null) {
                            taglib11 = Loader.getResource(Servlet.class, (String)"javax/servlet/jsp/resources/web-jsptaglibrary_1_1.dtd", (boolean)true);
                        }
                        if (taglib12 == null) {
                            taglib12 = Loader.getResource(Servlet.class, (String)"javax/servlet/jsp/resources/web-jsptaglibrary_1_2.dtd", (boolean)true);
                        }
                        if (taglib20 == null) {
                            taglib20 = Loader.getResource(Servlet.class, (String)"javax/servlet/jsp/resources/web-jsptaglibrary_2_0.xsd", (boolean)true);
                        }
                        if (taglib21 == null) {
                            taglib21 = Loader.getResource(Servlet.class, (String)"javax/servlet/jsp/resources/web-jsptaglibrary_2_1.xsd", (boolean)true);
                        }
                        throw throwable;
                    }
                    taglib11 = Loader.getResource(Servlet.class, (String)"javax/servlet/jsp/resources/web-jsptaglibrary_1_1.dtd", (boolean)true);
                }
                if (taglib12 == null) {
                    taglib12 = Loader.getResource(Servlet.class, (String)"javax/servlet/jsp/resources/web-jsptaglibrary_1_2.dtd", (boolean)true);
                }
                if (taglib20 == null) {
                    taglib20 = Loader.getResource(Servlet.class, (String)"javax/servlet/jsp/resources/web-jsptaglibrary_2_0.xsd", (boolean)true);
                }
                if (taglib21 == null) {
                    taglib21 = Loader.getResource(Servlet.class, (String)"javax/servlet/jsp/resources/web-jsptaglibrary_2_1.xsd", (boolean)true);
                }
            }
            if (taglib11 != null) {
                this._parser.redirectEntity("web-jsptaglib_1_1.dtd", taglib11);
                this._parser.redirectEntity("web-jsptaglibrary_1_1.dtd", taglib11);
            }
            if (taglib12 != null) {
                this._parser.redirectEntity("web-jsptaglib_1_2.dtd", taglib12);
                this._parser.redirectEntity("web-jsptaglibrary_1_2.dtd", taglib12);
            }
            if (taglib20 != null) {
                this._parser.redirectEntity("web-jsptaglib_2_0.xsd", taglib20);
                this._parser.redirectEntity("web-jsptaglibrary_2_0.xsd", taglib20);
            }
            if (taglib21 != null) {
                this._parser.redirectEntity("web-jsptaglib_2_1.xsd", taglib21);
                this._parser.redirectEntity("web-jsptaglibrary_2_1.xsd", taglib21);
            }
            this._parser.setXpath("/taglib/listener/listener-class");
        }

        public XmlParser.Node parse(Resource tld) throws Exception {
            XmlParser.Node root;
            try {
                root = this._parser.parse(tld.getInputStream());
            }
            catch (Exception e) {
                root = this._parser.parse(tld.getURL().toString());
            }
            if (root == null) {
                Log.warn((String)"No TLD root in {}", (Object)tld);
            } else {
                this._roots.add(root);
            }
            return root;
        }

        public void processRoots() {
            for (XmlParser.Node root : this._roots) {
                this.process(root);
            }
        }

        public void process(XmlParser.Node root) {
            for (int i = 0; i < root.size(); ++i) {
                XmlParser.Node node;
                Object o = root.get(i);
                if (!(o instanceof XmlParser.Node) || !"listener".equals((node = (XmlParser.Node)o).getTag())) continue;
                String className = node.getString("listener-class", false, true);
                if (Log.isDebugEnabled()) {
                    Log.debug((String)("listener=" + className));
                }
                try {
                    Class listenerClass = this._context.loadClass(className);
                    EventListener l = (EventListener)listenerClass.newInstance();
                    this._context.addEventListener(l);
                    continue;
                }
                catch (Exception e) {
                    Log.warn((String)("Could not instantiate listener " + className + ": " + e));
                    Log.debug((Throwable)e);
                    continue;
                }
                catch (Error e) {
                    Log.warn((String)("Could not instantiate listener " + className + ": " + e));
                    Log.debug((Throwable)e);
                }
            }
        }
    }
}

