/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.resource;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.ProviderNotFoundException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.Index;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.eclipse.jetty.util.resource.FileSystemPool;
import org.eclipse.jetty.util.resource.MountedPathResourceFactory;
import org.eclipse.jetty.util.resource.PathResourceFactory;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ResourceFactoryInternals {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceFactoryInternals.class);
    private static final Path CURRENT_WORKING_DIR;
    static final Index.Mutable<ResourceFactory> RESOURCE_FACTORIES;
    static ResourceFactory ROOT;

    ResourceFactoryInternals() {
    }

    static {
        RESOURCE_FACTORIES = new Index.Builder().caseSensitive(false).mutable().build();
        CURRENT_WORKING_DIR = Path.of(System.getProperty("user.dir"), new String[0]);
        RESOURCE_FACTORIES.put("jar", new MountedPathResourceFactory());
        PathResourceFactory pathResourceFactory = new PathResourceFactory();
        RESOURCE_FACTORIES.put("file", pathResourceFactory);
        RESOURCE_FACTORIES.put("jrt", pathResourceFactory);
        ROOT = new CompositeResourceFactory(){

            @Override
            protected void onMounted(FileSystemPool.Mount mount, URI uri) {
                if (LOG.isDebugEnabled()) {
                    LOG.warn("Leaked {} for {}", new Object[]{mount, uri, new Throwable()});
                } else {
                    LOG.warn("Leaked {} for {}", (Object)mount, (Object)uri);
                }
            }
        };
    }

    static class CompositeResourceFactory
    implements ResourceFactory {
        private final List<FileSystemPool.Mount> _mounts = new CopyOnWriteArrayList<FileSystemPool.Mount>();

        CompositeResourceFactory() {
        }

        @Override
        public Resource newResource(URI uri) {
            if (uri == null) {
                return null;
            }
            try {
                FileSystemPool.Mount mount;
                ResourceFactory resourceFactory;
                if (!uri.isAbsolute()) {
                    uri = uri.toString().startsWith("/") ? new URI("file", uri.toString(), null) : CURRENT_WORKING_DIR.toUri().resolve(uri);
                    uri = URIUtil.correctFileURI(uri);
                }
                if ((resourceFactory = ResourceFactory.byScheme(uri.getScheme())) == null) {
                    throw new IllegalArgumentException("URI scheme not supported: " + String.valueOf(uri));
                }
                if (resourceFactory instanceof MountedPathResourceFactory && (mount = this.mountIfNeeded(uri)) != null) {
                    this._mounts.add(mount);
                    this.onMounted(mount, uri);
                }
                return resourceFactory.newResource(uri);
            }
            catch (URISyntaxException | ProviderNotFoundException ex) {
                throw new IllegalArgumentException("Unable to create resource from: " + String.valueOf(uri), ex);
            }
        }

        private FileSystemPool.Mount mountIfNeeded(URI uri) {
            String scheme = uri.getScheme();
            if (!"jar".equalsIgnoreCase(scheme)) {
                return null;
            }
            try {
                return FileSystemPool.INSTANCE.mount(uri);
            }
            catch (IOException ioe) {
                throw new IllegalArgumentException("Unable to mount: " + String.valueOf(uri), ioe);
            }
        }

        protected void onMounted(FileSystemPool.Mount mount, URI uri) {
        }

        public List<FileSystemPool.Mount> getMounts() {
            return this._mounts;
        }

        public void clearMounts() {
            this._mounts.clear();
        }
    }

    static class LifeCycle
    extends AbstractLifeCycle
    implements ResourceFactory.LifeCycle {
        private final CompositeResourceFactory _compositeResourceFactory = new CompositeResourceFactory();

        LifeCycle() {
        }

        @Override
        public Resource newResource(URI uri) {
            return this._compositeResourceFactory.newResource(uri);
        }

        @Override
        protected void doStop() throws Exception {
            for (FileSystemPool.Mount mount : this._compositeResourceFactory.getMounts()) {
                IO.close(mount);
            }
            this._compositeResourceFactory.clearMounts();
            super.doStop();
        }

        @Override
        public void dump(Appendable out, String indent) throws IOException {
            Dumpable.dumpObjects(out, indent, this, new DumpableCollection("mounts", this._compositeResourceFactory.getMounts()));
        }
    }

    static class Closeable
    implements ResourceFactory.Closeable {
        private final CompositeResourceFactory _compositeResourceFactory = new CompositeResourceFactory();

        Closeable() {
        }

        @Override
        public Resource newResource(URI uri) {
            return this._compositeResourceFactory.newResource(uri);
        }

        @Override
        public void close() {
            for (FileSystemPool.Mount mount : this._compositeResourceFactory.getMounts()) {
                IO.close(mount);
            }
            this._compositeResourceFactory.clearMounts();
        }
    }
}

