/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.resource;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.resource.CombinedResource;
import org.eclipse.jetty.util.resource.MemoryResource;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactoryInternals;

public interface ResourceFactory {
    public static Resource combine(List<Resource> resources) {
        return CombinedResource.combine(resources);
    }

    public static Resource combine(Resource ... resources) {
        return CombinedResource.combine(List.of(resources));
    }

    public Resource newResource(URI var1);

    default public Resource newSystemResource(String resource) {
        if (StringUtil.isBlank(resource)) {
            throw new IllegalArgumentException("Resource String is invalid: " + resource);
        }
        URL url = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader != null) {
            try {
                url = loader.getResource(resource);
                if (url == null && resource.startsWith("/")) {
                    url = loader.getResource(resource.substring(1));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (url == null && (loader = ResourceFactory.class.getClassLoader()) != null && (url = loader.getResource(resource)) == null && resource.startsWith("/")) {
            url = loader.getResource(resource.substring(1));
        }
        if (url == null && (url = ClassLoader.getSystemResource(resource)) == null && resource.startsWith("/")) {
            url = ClassLoader.getSystemResource(resource.substring(1));
        }
        if (url == null) {
            return null;
        }
        try {
            URI uri = url.toURI();
            return this.newResource(uri);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Error creating resource from URL: " + String.valueOf(url), e);
        }
    }

    default public Resource newClassPathResource(String resource) {
        if (StringUtil.isBlank(resource)) {
            throw new IllegalArgumentException("Resource String is invalid: " + resource);
        }
        URL url = ResourceFactory.class.getResource(resource);
        if (url == null) {
            url = Loader.getResource(resource);
        }
        if (url == null) {
            return null;
        }
        try {
            URI uri = url.toURI();
            return this.newResource(uri);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    default public Resource newMemoryResource(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("URL is null");
        }
        return new MemoryResource(url);
    }

    default public Resource newResource(String resource) {
        if (StringUtil.isBlank(resource)) {
            throw new IllegalArgumentException("Resource String is invalid: " + resource);
        }
        return this.newResource(URIUtil.toURI(resource));
    }

    default public Resource newResource(Path path) {
        if (path == null) {
            throw new IllegalArgumentException("Path is null");
        }
        return this.newResource(path.toUri());
    }

    default public Resource newResource(List<URI> uris) {
        if (uris == null || uris.isEmpty()) {
            throw new IllegalArgumentException("List of URIs is invalid");
        }
        return ResourceFactory.combine(uris.stream().map(this::newResource).toList());
    }

    default public Resource newResource(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("URL is null");
        }
        try {
            return this.newResource(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Error creating resource from URL: " + String.valueOf(url), e);
        }
    }

    default public Resource newJarFileResource(URI uri) {
        if (!uri.getScheme().equalsIgnoreCase("file")) {
            throw new IllegalArgumentException("Not an allowed path: " + String.valueOf(uri));
        }
        return this.newResource(URIUtil.toJarFileUri(uri));
    }

    public static void registerResourceFactory(String scheme, ResourceFactory resource) {
        ResourceFactoryInternals.RESOURCE_FACTORIES.put(scheme, resource);
    }

    public static ResourceFactory unregisterResourceFactory(String scheme) {
        return ResourceFactoryInternals.RESOURCE_FACTORIES.remove(scheme);
    }

    public static ResourceFactory byScheme(String scheme) {
        return (ResourceFactory)ResourceFactoryInternals.RESOURCE_FACTORIES.get(scheme);
    }

    public static ResourceFactory getBestByScheme(String str) {
        return (ResourceFactory)ResourceFactoryInternals.RESOURCE_FACTORIES.getBest(str);
    }

    public static ResourceFactory root() {
        return ResourceFactoryInternals.ROOT;
    }

    public static Closeable closeable() {
        return new ResourceFactoryInternals.Closeable();
    }

    public static LifeCycle lifecycle() {
        ResourceFactoryInternals.LifeCycle factory = new ResourceFactoryInternals.LifeCycle();
        org.eclipse.jetty.util.component.LifeCycle.start(factory);
        return factory;
    }

    public static ResourceFactory of(final Resource baseResource) {
        Objects.requireNonNull(baseResource);
        if (baseResource instanceof ResourceFactory) {
            ResourceFactory resourceFactory = (ResourceFactory)((Object)baseResource);
            return resourceFactory;
        }
        return new ResourceFactory(){

            @Override
            public Resource newResource(URI resource) {
                return this.newResource(resource.toString());
            }

            @Override
            public Resource newResource(String resource) {
                return baseResource.resolve(resource);
            }
        };
    }

    public static ResourceFactory of(final Container container) {
        Objects.requireNonNull(container);
        LifeCycle factory = container.getBean(LifeCycle.class);
        if (factory == null) {
            factory = ResourceFactory.lifecycle();
            container.addBean(factory, true);
            final LifeCycle finalFactory = factory;
            container.addEventListener(new LifeCycle.Listener(){

                @Override
                public void lifeCycleStopped(org.eclipse.jetty.util.component.LifeCycle event) {
                    container.removeBean(this);
                    container.removeBean(finalFactory);
                }
            });
        }
        return factory;
    }

    public static interface LifeCycle
    extends org.eclipse.jetty.util.component.LifeCycle,
    ResourceFactory,
    Dumpable {
    }

    public static interface Closeable
    extends ResourceFactory,
    java.io.Closeable {
        @Override
        public void close();
    }
}

