/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.unixsocket.client;

import java.io.Closeable;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Map;
import java.util.concurrent.Executor;
import jnr.enxio.channels.NativeSelectorProvider;
import jnr.unixsocket.UnixSocketAddress;
import jnr.unixsocket.UnixSocketChannel;
import org.eclipse.jetty.client.AbstractConnectorHttpClientTransport;
import org.eclipse.jetty.client.DuplexConnectionPool;
import org.eclipse.jetty.client.DuplexHttpDestination;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.api.Destination;
import org.eclipse.jetty.client.http.HttpConnectionOverHTTP;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ManagedSelector;
import org.eclipse.jetty.io.SelectorManager;
import org.eclipse.jetty.unixsocket.common.UnixSocketEndPoint;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;

public class HttpClientTransportOverUnixSockets
extends AbstractConnectorHttpClientTransport {
    private static final Logger LOG = Log.getLogger(HttpClientTransportOverUnixSockets.class);

    public HttpClientTransportOverUnixSockets(String unixSocket) {
        this(new UnixSocketClientConnector(unixSocket));
    }

    private HttpClientTransportOverUnixSockets(ClientConnector connector) {
        super(connector);
        this.setConnectionPoolFactory(destination -> {
            HttpClient httpClient = this.getHttpClient();
            int maxConnections = httpClient.getMaxConnectionsPerDestination();
            return new DuplexConnectionPool((Destination)destination, maxConnections, (Callback)destination);
        });
    }

    public HttpDestination newHttpDestination(HttpDestination.Key key) {
        return new DuplexHttpDestination(this.getHttpClient(), key);
    }

    public Connection newConnection(EndPoint endPoint, Map<String, Object> context) {
        HttpDestination destination = (HttpDestination)context.get("org.eclipse.jetty.client.destination");
        Promise promise = (Promise)context.get("org.eclipse.jetty.client.connection.promise");
        HttpConnectionOverHTTP connection = this.newHttpConnection(endPoint, destination, (Promise<org.eclipse.jetty.client.api.Connection>)promise);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created {}", new Object[]{connection});
        }
        return this.customize((Connection)connection, context);
    }

    protected HttpConnectionOverHTTP newHttpConnection(EndPoint endPoint, HttpDestination destination, Promise<org.eclipse.jetty.client.api.Connection> promise) {
        return new HttpConnectionOverHTTP(endPoint, destination, promise);
    }

    private static class UnixSocketClientConnector
    extends ClientConnector {
        private final String unixSocket;

        private UnixSocketClientConnector(String unixSocket) {
            this.unixSocket = unixSocket;
        }

        protected SelectorManager newSelectorManager() {
            return new UnixSocketSelectorManager(this.getExecutor(), this.getScheduler(), this.getSelectors());
        }

        public void connect(SocketAddress address, Map<String, Object> context) {
            InetSocketAddress socketAddress = (InetSocketAddress)address;
            InetAddress inetAddress = socketAddress.getAddress();
            if (inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress() || inetAddress.isSiteLocalAddress()) {
                UnixSocketChannel channel = null;
                try {
                    UnixSocketAddress unixAddress = new UnixSocketAddress(this.unixSocket);
                    channel = UnixSocketChannel.open((UnixSocketAddress)unixAddress);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Created {} for {}", new Object[]{channel, unixAddress});
                    }
                    this.accept((SocketChannel)channel, context);
                }
                catch (Throwable x) {
                    this.safeClose((Closeable)channel);
                    this.connectFailed(x, context);
                }
            } else {
                this.connectFailed(new ConnectException("UnixSocket cannot connect to " + socketAddress.getHostString()), context);
            }
        }

        private class UnixSocketSelectorManager
        extends ClientConnector.ClientSelectorManager {
            private UnixSocketSelectorManager(Executor executor, Scheduler scheduler, int selectors) {
                super((ClientConnector)UnixSocketClientConnector.this, executor, scheduler, selectors);
            }

            protected Selector newSelector() throws IOException {
                return NativeSelectorProvider.getInstance().openSelector();
            }

            protected EndPoint newEndPoint(SelectableChannel channel, ManagedSelector selector, SelectionKey key) {
                UnixSocketEndPoint endPoint = new UnixSocketEndPoint((UnixSocketChannel)channel, selector, key, this.getScheduler());
                endPoint.setIdleTimeout(UnixSocketClientConnector.this.getIdleTimeout().toMillis());
                return endPoint;
            }
        }
    }
}

