/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.jetty.start.StartLog;

public class CommandLineBuilder {
    private final StringBuilder commandLine = new StringBuilder();
    private final List<String> args = new ArrayList<String>();
    private final String separator;

    public static String findJavaBin() {
        Path javaHome = Paths.get(System.getProperty("java.home"), new String[0]);
        if (!Files.exists(javaHome, new LinkOption[0])) {
            return null;
        }
        Path javabin = javaHome.resolve("bin/java");
        if (Files.exists(javabin, new LinkOption[0])) {
            return javabin.toAbsolutePath().toString();
        }
        javabin = javaHome.resolve("bin/java.exe");
        if (Files.exists(javabin, new LinkOption[0])) {
            return javabin.toAbsolutePath().toString();
        }
        return "java";
    }

    public CommandLineBuilder() {
        this(false);
    }

    public CommandLineBuilder(boolean multiline) {
        this.separator = multiline ? " \\" + System.lineSeparator() + "  " : " ";
    }

    public static String shellQuoteIfNeeded(String input) {
        if (input == null) {
            return null;
        }
        if (input.length() == 0) {
            return "''";
        }
        int i = 0;
        boolean needsQuoting = false;
        while (!needsQuoting && i < input.length()) {
            char c;
            needsQuoting = !((c = input.charAt(i++)) >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '/' || c == ':' || c == '.' || c == ',' || c == '+' || c == '-' || c == '_');
        }
        if (!needsQuoting) {
            return input;
        }
        StringBuilder builder = new StringBuilder(input.length() * 2);
        builder.append("'");
        builder.append(input, 0, --i);
        while (i < input.length()) {
            char c;
            if ((c = input.charAt(i++)) == '\'') {
                if (i == 1) {
                    builder.insert(0, "\\").append("'");
                    continue;
                }
                if (i == input.length()) {
                    builder.append("'\\");
                    continue;
                }
                builder.append("'\\''");
                continue;
            }
            builder.append(c);
        }
        builder.append("'");
        return builder.toString();
    }

    public void addArg(String arg) {
        if (arg != null) {
            if (this.commandLine.length() > 0) {
                this.commandLine.append(this.separator);
            }
            this.args.add(arg);
            this.commandLine.append(CommandLineBuilder.shellQuoteIfNeeded(arg));
        }
    }

    public void addArg(String name, String value) {
        Objects.requireNonNull(name);
        if (this.commandLine.length() > 0) {
            this.commandLine.append(this.separator);
        }
        if (value != null && value.length() > 0) {
            this.args.add(name + "=" + value);
            this.commandLine.append(CommandLineBuilder.shellQuoteIfNeeded(name)).append('=').append(CommandLineBuilder.shellQuoteIfNeeded(value));
        } else {
            this.args.add(name);
            this.commandLine.append(CommandLineBuilder.shellQuoteIfNeeded(name));
        }
    }

    public void addOption(String option) {
        this.addOption(option, null, null);
    }

    public void addOption(String option, String name, String value) {
        Objects.requireNonNull(option);
        if (this.commandLine.length() > 0) {
            this.commandLine.append(this.separator);
        }
        if (name == null || name.length() == 0) {
            this.commandLine.append(option);
            this.args.add(option);
        } else if (value != null && value.length() > 0) {
            this.args.add(option + name + "=" + value);
            this.commandLine.append(option).append(CommandLineBuilder.shellQuoteIfNeeded(name)).append('=').append(CommandLineBuilder.shellQuoteIfNeeded(value));
        } else {
            this.args.add(option + name);
            this.commandLine.append(option).append(CommandLineBuilder.shellQuoteIfNeeded(name));
        }
    }

    public List<String> getArgs() {
        return this.args;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (String arg : this.args) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append(arg);
        }
        return buf.toString();
    }

    public String toCommandLine() {
        return this.commandLine.toString();
    }

    public void debug() {
        if (!StartLog.isDebugEnabled()) {
            return;
        }
        int len = this.args.size();
        StartLog.debug("Command Line: %,d entries", this.args.size());
        for (int i = 0; i < len; ++i) {
            StartLog.debug(" [%d]: \"%s\"", i, this.args.get(i));
        }
    }
}

