/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start;

import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.start.BaseHome;
import org.eclipse.jetty.start.FS;
import org.eclipse.jetty.start.FileArg;
import org.eclipse.jetty.start.FileInitializer;
import org.eclipse.jetty.start.Licensing;
import org.eclipse.jetty.start.Module;
import org.eclipse.jetty.start.Modules;
import org.eclipse.jetty.start.NaturalSort;
import org.eclipse.jetty.start.PathMatchers;
import org.eclipse.jetty.start.Props;
import org.eclipse.jetty.start.StartArgs;
import org.eclipse.jetty.start.StartLog;
import org.eclipse.jetty.start.Utils;
import org.eclipse.jetty.start.builders.StartDirBuilder;
import org.eclipse.jetty.start.builders.StartIniBuilder;
import org.eclipse.jetty.start.fileinits.BaseHomeFileInitializer;
import org.eclipse.jetty.start.fileinits.LocalFileInitializer;
import org.eclipse.jetty.start.fileinits.MavenLocalRepoFileInitializer;
import org.eclipse.jetty.start.fileinits.TestFileInitializer;
import org.eclipse.jetty.start.fileinits.UriFileInitializer;

public class BaseBuilder {
    private static final String EXITING_LICENSE_NOT_ACKNOWLEDGED = "Exiting: license not acknowledged!";
    private final BaseHome baseHome;
    private final List<FileInitializer> fileInitializers;
    private final StartArgs startArgs;

    public BaseBuilder(BaseHome baseHome, StartArgs args) {
        this.baseHome = baseHome;
        this.startArgs = args;
        this.fileInitializers = new ArrayList<FileInitializer>();
        if (args.isTestingModeEnabled()) {
            this.fileInitializers.add(new BaseHomeFileInitializer(baseHome));
            this.fileInitializers.add(new LocalFileInitializer(baseHome));
            this.fileInitializers.add(new TestFileInitializer(baseHome));
        } else if (args.isCreateFiles()) {
            this.fileInitializers.add(new LocalFileInitializer(baseHome));
            Path localRepoDir = args.findMavenLocalRepoDir();
            if (localRepoDir != null) {
                this.fileInitializers.add(new MavenLocalRepoFileInitializer(baseHome, localRepoDir, args.getMavenLocalRepoDir() == null, this.startArgs.getMavenBaseUri()));
            } else {
                this.fileInitializers.add(new MavenLocalRepoFileInitializer(baseHome));
            }
            this.fileInitializers.add(new BaseHomeFileInitializer(baseHome));
            this.fileInitializers.add(new UriFileInitializer(this.startArgs, baseHome));
        }
    }

    public boolean build() throws IOException {
        boolean useStartD;
        Modules modules = this.startArgs.getAllModules();
        HashSet<String> newlyAdded = new HashSet<String>();
        if (!this.startArgs.getStartModules().isEmpty()) {
            for (String string : this.startArgs.getStartModules()) {
                newlyAdded.addAll(modules.enable(string, "--add-module"));
                if (newlyAdded.contains(string)) continue;
                Set<String> sources = modules.get(string).getEnableSources();
                sources.remove("--add-module");
                StartLog.info("%s already enabled by %s", string, sources);
            }
        }
        if (StartLog.isDebugEnabled()) {
            StartLog.debug("Newly Added %s", newlyAdded);
        }
        if (this.startArgs.isLicenseCheckRequired()) {
            Licensing licensing = new Licensing();
            for (String name : newlyAdded) {
                licensing.addModule(modules.get(name));
            }
            if (licensing.hasLicenses()) {
                if (this.startArgs.isApproveAllLicenses()) {
                    StartLog.info("All Licenses Approved via Command Line Option", new Object[0]);
                } else if (!licensing.acknowledgeLicenses()) {
                    StartLog.warn(EXITING_LICENSE_NOT_ACKNOWLEDGED, new Object[0]);
                    System.exit(1);
                }
            }
        }
        ArrayList<FileArg> files = new ArrayList<FileArg>();
        AtomicReference<StartDirBuilder> atomicReference = new AtomicReference<StartDirBuilder>();
        AtomicBoolean modified = new AtomicBoolean();
        Path startd = this.getBaseHome().getBasePath("start.d");
        Path startini = this.getBaseHome().getBasePath("start.ini");
        if (this.startArgs.isCreateStartIni()) {
            if (!Files.exists(startini, new LinkOption[0])) {
                if (Files.exists(this.getBaseHome().getBasePath("start.jar"), new LinkOption[0])) {
                    StartLog.warn("creating start.ini in ${jetty.home} is not recommended!", new Object[0]);
                }
                StartLog.info("create %s", this.baseHome.toShortForm(startini));
                Files.createFile(startini, new FileAttribute[0]);
                modified.set(true);
            }
            if (Files.exists(startd, new LinkOption[0])) {
                DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){
                    private final PathMatcher iniMatcher = PathMatchers.getMatcher("glob:**/start.d/*.ini");

                    @Override
                    public boolean accept(Path entry) {
                        return this.iniMatcher.matches(entry);
                    }
                };
                ArrayList<Path> paths = new ArrayList<Path>();
                try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(startd, (DirectoryStream.Filter<? super Path>)filter);){
                    for (Path path : dirStream) {
                        paths.add(path);
                    }
                }
                paths.sort(new NaturalSort.Paths());
                ArrayList<Object> startLines = new ArrayList<Object>();
                for (Path path : paths) {
                    StartLog.info("copy %s into %s", this.baseHome.toShortForm(path), this.baseHome.toShortForm(startini));
                    startLines.add("");
                    startLines.add("# Config from " + this.baseHome.toShortForm(path));
                    startLines.addAll(Files.readAllLines(path));
                }
                try (FileWriter out = new FileWriter(startini.toFile(), true);){
                    for (String string : startLines) {
                        out.append(string).append(System.lineSeparator());
                    }
                }
                for (Path path : paths) {
                    Files.delete(path);
                }
                Files.delete(startd);
            }
        }
        if (this.startArgs.isCreateStartD() && (!Files.exists(startd, new LinkOption[0]) || Files.exists(startini, new LinkOption[0])) || !newlyAdded.isEmpty() && !Files.exists(startini, new LinkOption[0]) && !Files.exists(startd, new LinkOption[0])) {
            if (Files.exists(this.getBaseHome().getBasePath("start.jar"), new LinkOption[0]) && !this.startArgs.isCreateStartD()) {
                StartLog.warn("creating start.d in ${jetty.home} is not recommended!", new Object[0]);
                if (!this.startArgs.isCreateStartD()) {
                    BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
                    System.err.printf("%nProceed (y/N)? ", new Object[0]);
                    String response = input.readLine();
                    if (Utils.isBlank(response) || !response.toLowerCase(Locale.ENGLISH).startsWith("y")) {
                        System.exit(1);
                    }
                }
            }
            if (FS.ensureDirectoryExists(startd)) {
                StartLog.info("mkdir %s", this.baseHome.toShortForm(startd));
                modified.set(true);
            }
            if (Files.exists(startini, new LinkOption[0]) && this.startArgs.isCreateStartD()) {
                int ini = 0;
                Path startdStartini = startd.resolve("start.ini");
                while (Files.exists(startdStartini, new LinkOption[0])) {
                    startdStartini = startd.resolve("start" + ++ini + ".ini");
                }
                Files.move(startini, startdStartini, new CopyOption[0]);
                modified.set(true);
            }
        }
        if ((useStartD = Files.exists(startd, new LinkOption[0])) && Files.exists(startini, new LinkOption[0])) {
            StartLog.warn("Use of both %s and %s is deprecated", this.getBaseHome().toShortForm(startd), this.getBaseHome().toShortForm(startini));
        }
        atomicReference.set((StartDirBuilder)(useStartD ? new StartDirBuilder(this) : new StartIniBuilder(this)));
        newlyAdded.stream().map(modules::get).filter(Module::isEnabled).forEach(module -> {
            String ini = null;
            try {
                if (module.isSkipFilesValidation()) {
                    StartLog.debug("Skipping [files] validation on %s", module.getName());
                } else {
                    boolean explicitlyAdded = this.startArgs.getStartModules().contains(module.getName());
                    if ((explicitlyAdded || module.isTransitive() && module.hasIniTemplate()) && (ini = ((Config)builder.get()).addModule((Module)module, this.startArgs.getJettyEnvironment().getProperties())) != null) {
                        modified.set(true);
                    }
                    for (String file : module.getFiles()) {
                        files.add(new FileArg((Module)module, this.startArgs.getJettyEnvironment().getProperties().expand(file)));
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (module.isDynamic()) {
                for (String s : module.getEnableSources()) {
                    StartLog.info("%-15s %s", module.getName(), s);
                }
            } else if (module.isTransitive()) {
                StartLog.info("%-15s transitively enabled", module.getName());
            } else {
                StartLog.info("%-15s initialized in %s", module.getName(), ini);
            }
        });
        files.addAll(this.startArgs.getFiles());
        if (!files.isEmpty() && this.processFileResources(files)) {
            modified.set(true);
        }
        return modified.get();
    }

    public BaseHome getBaseHome() {
        return this.baseHome;
    }

    public StartArgs getStartArgs() {
        return this.startArgs;
    }

    private boolean processFileResource(FileArg arg) throws IOException {
        URI uri;
        URI uRI = uri = arg.uri == null ? null : URI.create(arg.uri);
        if (this.startArgs.isCreateFiles()) {
            for (FileInitializer finit : this.fileInitializers) {
                if (!finit.isApplicable(uri)) continue;
                return finit.create(uri, arg.location);
            }
            throw new IOException(String.format("Unable to create %s", arg));
        }
        for (FileInitializer finit : this.fileInitializers) {
            if (!finit.isApplicable(uri) || finit.check(uri, arg.location)) continue;
            this.startArgs.setRun(false);
        }
        return false;
    }

    private boolean processFileResources(List<FileArg> files) {
        if (files == null || files.isEmpty()) {
            return false;
        }
        boolean dirty = false;
        ArrayList<String> failures = new ArrayList<String>();
        for (FileArg arg : files) {
            try {
                boolean processed = this.processFileResource(arg);
                dirty |= processed;
            }
            catch (Throwable t) {
                StartLog.warn(t);
                failures.add(String.format("[%s] %s - %s", t.getClass().getSimpleName(), t.getMessage(), arg.location));
            }
        }
        if (!failures.isEmpty()) {
            StringBuilder err = new StringBuilder();
            err.append("Failed to process all file resources.");
            for (String failure : failures) {
                err.append(System.lineSeparator()).append(" - ").append(failure);
            }
            StartLog.warn(err.toString(), new Object[0]);
            throw new RuntimeException(err.toString());
        }
        return dirty;
    }

    public static interface Config {
        public String addModule(Module var1, Props var2) throws IOException;
    }
}

