/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.jetty.start.StartLog;
import org.eclipse.jetty.util.FileID;

public class FS {
    public static String separator() {
        return FileSystems.getDefault().getSeparator();
    }

    public static String pathSeparator() {
        return File.pathSeparator;
    }

    public static boolean canReadDirectory(Path path) {
        return Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0]) && Files.isReadable(path);
    }

    public static boolean canReadFile(Path path) {
        return Files.exists(path, new LinkOption[0]) && Files.isRegularFile(path, new LinkOption[0]) && Files.isReadable(path);
    }

    public static boolean canWrite(Path path) {
        return Files.isWritable(path);
    }

    public static void close(Closeable c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean createNewFile(Path path) throws IOException {
        Path ret = Files.createFile(path, new FileAttribute[0]);
        return Files.exists(ret, new LinkOption[0]);
    }

    public static boolean ensureDirectoryExists(Path dir) throws IOException {
        if (FS.exists(dir)) {
            if (!Files.isDirectory(dir, new LinkOption[0])) {
                throw new IOException("Path is not directory: " + String.valueOf(dir.toAbsolutePath()));
            }
            return false;
        }
        Files.createDirectories(dir, new FileAttribute[0]);
        return true;
    }

    public static void ensureDirectoryWritable(Path dir) throws IOException {
        if (!Files.exists(dir, new LinkOption[0])) {
            throw new IOException("Path does not exist: " + String.valueOf(dir.toAbsolutePath()));
        }
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            throw new IOException("Directory does not exist: " + String.valueOf(dir.toAbsolutePath()));
        }
        if (!Files.isWritable(dir)) {
            throw new IOException("Unable to write to directory: " + String.valueOf(dir.toAbsolutePath()));
        }
    }

    public static boolean exists(Path path) {
        return Files.exists(path, new LinkOption[0]);
    }

    public static boolean isValidDirectory(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            return false;
        }
        if (!Files.isDirectory(path, new LinkOption[0])) {
            StartLog.warn("Not a directory: %s", path);
            return false;
        }
        return true;
    }

    public static boolean isXml(String filename) {
        return filename.toLowerCase(Locale.ENGLISH).endsWith(".xml");
    }

    public static String toRelativePath(Path baseDir, Path path) {
        return baseDir.toUri().relativize(path.toUri()).toASCIIString();
    }

    public static boolean isPropertyFile(String filename) {
        return filename.toLowerCase(Locale.ENGLISH).endsWith(".properties");
    }

    public static String separators(String path) {
        StringBuilder ret = new StringBuilder();
        for (char c : path.toCharArray()) {
            if (c == '/' || c == '\\') {
                ret.append(File.separatorChar);
                continue;
            }
            ret.append(c);
        }
        return ret.toString();
    }

    public static Path toPath(String path) {
        return FileSystems.getDefault().getPath(FS.separators(path), new String[0]);
    }

    public static void touch(Path path) throws IOException {
        FileTime now = FileTime.fromMillis(System.currentTimeMillis());
        Files.setLastModifiedTime(path, now);
    }

    public static Path toRealPath(Path path) throws IOException {
        return path.toRealPath(new LinkOption[0]);
    }

    public static void extract(Path archive, Path destination) throws IOException {
        if (!FileID.isLibArchive((Path)archive)) {
            throw new IOException("Unable to extract unsupported archive format: " + String.valueOf(archive));
        }
        FS.extractZip(archive, destination);
    }

    public static void extractZip(Path archive, Path destination) throws IOException {
        StartLog.info("extract %s to %s", archive, destination);
        URI jaruri = URI.create("jar:" + String.valueOf(archive.toUri()));
        Map fsEnv = Map.of();
        try (FileSystem zipFs = FileSystems.newFileSystem(jaruri, fsEnv);){
            FS.copyZipContents(zipFs.getPath("/", new String[0]), destination);
        }
        catch (FileSystemAlreadyExistsException e) {
            FileSystem zipFs2 = FileSystems.getFileSystem(jaruri);
            FS.copyZipContents(zipFs2.getPath("/", new String[0]), destination);
        }
    }

    public static void copyZipContents(Path root, Path destination) throws IOException {
        if (!Files.exists(destination, new LinkOption[0])) {
            Files.createDirectories(destination, new FileAttribute[0]);
        }
        URI outputDirURI = destination.toUri();
        URI archiveURI = root.toUri();
        int archiveURISubIndex = archiveURI.toASCIIString().indexOf("!/") + 2;
        try (Stream<Path> entriesStream = Files.walk(root, new FileVisitOption[0]);){
            Stream<Path> sorted = entriesStream.filter(path -> path.getNameCount() > 0).filter(path -> !path.getName(0).toString().equalsIgnoreCase("META-INF")).sorted();
            Iterator pathIterator = sorted.iterator();
            while (pathIterator.hasNext()) {
                Path path2 = (Path)pathIterator.next();
                URI entryURI = path2.toUri();
                String subURI = entryURI.toASCIIString().substring(archiveURISubIndex);
                URI outputPathURI = outputDirURI.resolve(subURI);
                Path outputPath = Path.of(outputPathURI);
                StartLog.info("zipFs: %s > %s", path2, outputPath);
                if (Files.isDirectory(path2, new LinkOption[0])) {
                    if (Files.exists(outputPath, new LinkOption[0])) continue;
                    Files.createDirectory(outputPath, new FileAttribute[0]);
                    continue;
                }
                if (Files.exists(outputPath, new LinkOption[0])) {
                    StartLog.debug("skipping extraction (file exists) %s", outputPath);
                    continue;
                }
                StartLog.info("extracting %s to %s", path2, outputPath);
                Files.copy(path2, outputPath, new CopyOption[0]);
            }
        }
    }
}

