/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start.fileinits;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.eclipse.jetty.start.BaseHome;
import org.eclipse.jetty.start.StartArgs;
import org.eclipse.jetty.start.fileinits.DownloadFileInitializer;

public class UriFileInitializer
extends DownloadFileInitializer {
    protected final boolean _allowInsecureHttpDownloads;

    public UriFileInitializer(StartArgs startArgs, BaseHome baseHome) {
        super(baseHome, "http", "https");
        this._allowInsecureHttpDownloads = startArgs.isAllowInsecureHttpDownloads();
    }

    @Override
    protected boolean allowInsecureHttpDownloads() {
        return this._allowInsecureHttpDownloads;
    }

    @Override
    public boolean create(URI uri, String location) throws IOException {
        Path destination = this.getDestination(uri, location);
        if (Files.isDirectory(destination, new LinkOption[0])) {
            destination = destination.resolve(uri.getSchemeSpecificPart().substring(uri.getRawSchemeSpecificPart().lastIndexOf(47) + 1));
        }
        if (this.isFilePresent(destination)) {
            return false;
        }
        this.download(uri, destination);
        return true;
    }
}

