/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.Servlet;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.AbstractHandlerContainer;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.DecoratedObjectFactory;
import org.eclipse.jetty.util.Decorator;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ServletContextHandlerTest {
    private Server _server;
    private LocalConnector _connector;
    private static final AtomicInteger __testServlets = new AtomicInteger();

    @BeforeEach
    public void createServer() {
        this._server = new Server();
        this._connector = new LocalConnector(this._server);
        this._server.addConnector((Connector)this._connector);
        __testServlets.set(0);
    }

    @AfterEach
    public void destroyServer() throws Exception {
        this._server.stop();
        this._server.join();
    }

    @Test
    public void testAddSessionListener() throws Exception {
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        this._server.setHandler((Handler)contexts);
        ServletContextHandler root = new ServletContextHandler((HandlerContainer)contexts, "/", 1);
        MySessionHandler sessions = new MySessionHandler();
        root.setSessionHandler((SessionHandler)sessions);
        Assertions.assertNotNull((Object)((Object)sessions));
        root.addEventListener((EventListener)((Object)new MyTestSessionListener()));
        sessions.checkSessionAttributeListeners(1);
        sessions.checkSessionIdListeners(0);
        sessions.checkSessionListeners(1);
    }

    @Test
    public void testListenerFromSCI() throws Exception {
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        this._server.setHandler((Handler)contexts);
        ServletContextHandler root = new ServletContextHandler((HandlerContainer)contexts, "/");
        root.addBean((Object)new MySCIStarter(root.getServletContext()), true);
        this._server.start();
        Assertions.assertTrue((boolean)((Boolean)root.getServletContext().getAttribute("MySCI.startup")));
        Assertions.assertTrue((boolean)((Boolean)root.getServletContext().getAttribute("MyContextListener.contextInitialized")));
    }

    @Test
    public void testFindContainer() throws Exception {
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        this._server.setHandler((Handler)contexts);
        ServletContextHandler root = new ServletContextHandler((HandlerContainer)contexts, "/", 1);
        SessionHandler session = root.getSessionHandler();
        ServletHandler servlet = root.getServletHandler();
        ConstraintSecurityHandler security = new ConstraintSecurityHandler();
        root.setSecurityHandler((SecurityHandler)security);
        this._server.start();
        Assertions.assertEquals((Object)root, (Object)AbstractHandlerContainer.findContainerOf((HandlerContainer)this._server, ContextHandler.class, (Handler)session));
        Assertions.assertEquals((Object)root, (Object)AbstractHandlerContainer.findContainerOf((HandlerContainer)this._server, ContextHandler.class, (Handler)security));
        Assertions.assertEquals((Object)root, (Object)AbstractHandlerContainer.findContainerOf((HandlerContainer)this._server, ContextHandler.class, (Handler)servlet));
    }

    @Test
    public void testInitOrder() throws Exception {
        ServletContextHandler context = new ServletContextHandler();
        ServletHolder holder0 = context.addServlet(TestServlet.class, "/test0");
        ServletHolder holder1 = context.addServlet(TestServlet.class, "/test1");
        ServletHolder holder2 = context.addServlet(TestServlet.class, "/test2");
        holder1.setInitOrder(1);
        holder2.setInitOrder(2);
        context.setContextPath("/");
        this._server.setHandler((Handler)context);
        this._server.start();
        Assertions.assertEquals((int)2, (int)__testServlets.get());
        String response = this._connector.getResponse("GET /test1 HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assertions.assertEquals((int)2, (int)__testServlets.get());
        response = this._connector.getResponse("GET /test2 HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assertions.assertEquals((int)2, (int)__testServlets.get());
        MatcherAssert.assertThat((Object)holder0.getServletInstance(), (Matcher)Matchers.nullValue());
        response = this._connector.getResponse("GET /test0 HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assertions.assertEquals((int)3, (int)__testServlets.get());
        MatcherAssert.assertThat((Object)holder0.getServletInstance(), (Matcher)Matchers.notNullValue(Servlet.class));
        this._server.stop();
        Assertions.assertEquals((int)0, (int)__testServlets.get());
        holder0.setInitOrder(0);
        this._server.start();
        Assertions.assertEquals((int)3, (int)__testServlets.get());
        MatcherAssert.assertThat((Object)holder0.getServletInstance(), (Matcher)Matchers.notNullValue(Servlet.class));
        this._server.stop();
        Assertions.assertEquals((int)0, (int)__testServlets.get());
    }

    @Test
    public void testAddServletAfterStart() throws Exception {
        ServletContextHandler context = new ServletContextHandler();
        context.addServlet(TestServlet.class, "/test");
        context.setContextPath("/");
        this._server.setHandler((Handler)context);
        this._server.start();
        StringBuffer request = new StringBuffer();
        request.append("GET /test HTTP/1.0\n");
        request.append("Host: localhost\n");
        request.append("\n");
        String response = this._connector.getResponse(request.toString());
        MatcherAssert.assertThat((String)"Response", (Object)response, (Matcher)Matchers.containsString((String)"Test"));
        context.addServlet(HelloServlet.class, "/hello");
        request = new StringBuffer();
        request.append("GET /hello HTTP/1.0\n");
        request.append("Host: localhost\n");
        request.append("\n");
        response = this._connector.getResponse(request.toString());
        MatcherAssert.assertThat((String)"Response", (Object)response, (Matcher)Matchers.containsString((String)"Hello World"));
    }

    @Test
    public void testHandlerBeforeServletHandler() throws Exception {
        ServletContextHandler context = new ServletContextHandler(1);
        HandlerWrapper extra = new HandlerWrapper();
        context.getSessionHandler().insertHandler(extra);
        context.addServlet(TestServlet.class, "/test");
        context.setContextPath("/");
        this._server.setHandler((Handler)context);
        this._server.start();
        StringBuffer request = new StringBuffer();
        request.append("GET /test HTTP/1.0\n");
        request.append("Host: localhost\n");
        request.append("\n");
        String response = this._connector.getResponse(request.toString());
        MatcherAssert.assertThat((String)"Response", (Object)response, (Matcher)Matchers.containsString((String)"Test"));
        Assertions.assertEquals((Object)extra, (Object)context.getSessionHandler().getHandler());
    }

    @Test
    public void testGzipHandlerOption() throws Exception {
        ServletContextHandler context = new ServletContextHandler(5);
        GzipHandler gzip = context.getGzipHandler();
        this._server.start();
        Assertions.assertEquals((Object)context.getSessionHandler(), (Object)context.getHandler());
        Assertions.assertEquals((Object)gzip, (Object)context.getSessionHandler().getHandler());
        Assertions.assertEquals((Object)context.getServletHandler(), (Object)gzip.getHandler());
    }

    @Test
    public void testGzipHandlerSet() throws Exception {
        ServletContextHandler context = new ServletContextHandler();
        context.setSessionHandler(new SessionHandler());
        context.setGzipHandler(new GzipHandler());
        GzipHandler gzip = context.getGzipHandler();
        this._server.start();
        Assertions.assertEquals((Object)context.getSessionHandler(), (Object)context.getHandler());
        Assertions.assertEquals((Object)gzip, (Object)context.getSessionHandler().getHandler());
        Assertions.assertEquals((Object)context.getServletHandler(), (Object)gzip.getHandler());
    }

    @Test
    public void testReplaceServletHandlerWithServlet() throws Exception {
        ServletContextHandler context = new ServletContextHandler();
        context.addServlet(TestServlet.class, "/test");
        context.setContextPath("/");
        this._server.setHandler((Handler)context);
        this._server.start();
        StringBuffer request = new StringBuffer();
        request.append("GET /test HTTP/1.0\n");
        request.append("Host: localhost\n");
        request.append("\n");
        String response = this._connector.getResponse(request.toString());
        MatcherAssert.assertThat((String)"Response", (Object)response, (Matcher)Matchers.containsString((String)"Test"));
        context.stop();
        ServletHandler srvHnd = new ServletHandler();
        srvHnd.addServletWithMapping(HelloServlet.class, "/hello");
        context.setServletHandler(srvHnd);
        context.start();
        request = new StringBuffer();
        request.append("GET /hello HTTP/1.0\n");
        request.append("Host: localhost\n");
        request.append("\n");
        response = this._connector.getResponse(request.toString());
        MatcherAssert.assertThat((String)"Response", (Object)response, (Matcher)Matchers.containsString((String)"Hello World"));
    }

    @Test
    public void testReplaceServletHandlerWithoutServlet() throws Exception {
        ServletContextHandler context = new ServletContextHandler();
        context.addServlet(TestServlet.class, "/test");
        context.setContextPath("/");
        this._server.setHandler((Handler)context);
        this._server.start();
        StringBuffer request = new StringBuffer();
        request.append("GET /test HTTP/1.0\n");
        request.append("Host: localhost\n");
        request.append("\n");
        String response = this._connector.getResponse(request.toString());
        MatcherAssert.assertThat((String)"Response", (Object)response, (Matcher)Matchers.containsString((String)"Test"));
        context.stop();
        ServletHandler srvHnd = new ServletHandler();
        context.setServletHandler(srvHnd);
        context.start();
        context.addServlet(HelloServlet.class, "/hello");
        request = new StringBuffer();
        request.append("GET /hello HTTP/1.0\n");
        request.append("Host: localhost\n");
        request.append("\n");
        response = this._connector.getResponse(request.toString());
        MatcherAssert.assertThat((String)"Response", (Object)response, (Matcher)Matchers.containsString((String)"Hello World"));
    }

    @Test
    public void testReplaceHandler() throws Exception {
        ServletContextHandler servletContextHandler = new ServletContextHandler();
        ServletHolder sh = new ServletHolder((Servlet)new TestServlet());
        servletContextHandler.addServlet(sh, "/foo");
        final AtomicBoolean contextInit = new AtomicBoolean(false);
        final AtomicBoolean contextDestroy = new AtomicBoolean(false);
        servletContextHandler.addEventListener((EventListener)new ServletContextListener(){

            public void contextInitialized(ServletContextEvent sce) {
                if (sce.getServletContext() != null) {
                    contextInit.set(true);
                }
            }

            public void contextDestroyed(ServletContextEvent sce) {
                if (sce.getServletContext() != null) {
                    contextDestroy.set(true);
                }
            }
        });
        ServletHandler shandler = servletContextHandler.getServletHandler();
        ResourceHandler rh = new ResourceHandler();
        servletContextHandler.insertHandler((HandlerWrapper)rh);
        Assertions.assertEquals((Object)shandler, (Object)servletContextHandler.getServletHandler());
        Assertions.assertEquals((Object)rh, (Object)servletContextHandler.getHandler());
        Assertions.assertEquals((Object)rh.getHandler(), (Object)shandler);
        this._server.setHandler((Handler)servletContextHandler);
        this._server.start();
        Assertions.assertTrue((boolean)contextInit.get());
        this._server.stop();
        Assertions.assertTrue((boolean)contextDestroy.get());
    }

    @Test
    public void testFallThrough() throws Exception {
        HandlerList list = new HandlerList();
        this._server.setHandler((Handler)list);
        ServletContextHandler root = new ServletContextHandler((HandlerContainer)list, "/", 1);
        ServletHandler servlet = root.getServletHandler();
        servlet.setEnsureDefaultServlet(false);
        servlet.addServletWithMapping(HelloServlet.class, "/hello/*");
        list.addHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                response.sendError(404, "Fell Through");
            }
        });
        this._server.start();
        String response = this._connector.getResponse("GET /hello HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        response = this._connector.getResponse("GET /other HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"404 Fell Through"));
    }

    @Test
    public void testLegacyDecorator() throws Exception {
        ServletContextHandler context = new ServletContextHandler();
        context.addDecorator((ServletContextHandler.Decorator)new DummyLegacyDecorator());
        this._server.setHandler((Handler)context);
        context.addServlet(DecoratedObjectFactoryServlet.class, "/objfactory/*");
        this._server.start();
        String response = this._connector.getResponse("GET /objfactory/ HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat((String)"Response status code", (Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        String expected = String.format("Attribute[%s] = %s", DecoratedObjectFactory.ATTR, DecoratedObjectFactory.class.getName());
        MatcherAssert.assertThat((String)"Has context attribute", (Object)response, (Matcher)Matchers.containsString((String)expected));
        MatcherAssert.assertThat((String)"Decorators size", (Object)response, (Matcher)Matchers.containsString((String)"Decorators.size = [2]"));
        expected = String.format("decorator[] = %s", DummyLegacyDecorator.class.getName());
        MatcherAssert.assertThat((String)"Specific Legacy Decorator", (Object)response, (Matcher)Matchers.containsString((String)expected));
    }

    @Test
    public void testUtilDecorator() throws Exception {
        ServletContextHandler context = new ServletContextHandler();
        context.getObjectFactory().addDecorator((Decorator)new DummyUtilDecorator());
        this._server.setHandler((Handler)context);
        context.addServlet(DecoratedObjectFactoryServlet.class, "/objfactory/*");
        this._server.start();
        String response = this._connector.getResponse("GET /objfactory/ HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat((String)"Response status code", (Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        String expected = String.format("Attribute[%s] = %s", DecoratedObjectFactory.ATTR, DecoratedObjectFactory.class.getName());
        MatcherAssert.assertThat((String)"Has context attribute", (Object)response, (Matcher)Matchers.containsString((String)expected));
        MatcherAssert.assertThat((String)"Decorators size", (Object)response, (Matcher)Matchers.containsString((String)"Decorators.size = [2]"));
        expected = String.format("decorator[] = %s", DummyUtilDecorator.class.getName());
        MatcherAssert.assertThat((String)"Specific Legacy Decorator", (Object)response, (Matcher)Matchers.containsString((String)expected));
    }

    public static class TestServlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;

        public void destroy() {
            super.destroy();
            __testServlets.decrementAndGet();
        }

        public void init() throws ServletException {
            __testServlets.incrementAndGet();
            super.init();
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            resp.setStatus(200);
            PrintWriter writer = resp.getWriter();
            writer.write("Test");
        }
    }

    public static class DecoratedObjectFactoryServlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            resp.setContentType("text/plain");
            resp.setStatus(200);
            PrintWriter out = resp.getWriter();
            Object obj = req.getServletContext().getAttribute(DecoratedObjectFactory.ATTR);
            out.printf("Attribute[%s] = %s%n", DecoratedObjectFactory.ATTR, obj.getClass().getName());
            if (obj instanceof DecoratedObjectFactory) {
                out.printf("Object is a DecoratedObjectFactory%n", new Object[0]);
                DecoratedObjectFactory objFactory = (DecoratedObjectFactory)obj;
                List decorators = objFactory.getDecorators();
                out.printf("Decorators.size = [%d]%n", decorators.size());
                for (Decorator decorator : decorators) {
                    out.printf(" decorator[] = %s%n", decorator.getClass().getName());
                }
            } else {
                out.printf("Object is NOT a DecoratedObjectFactory%n", new Object[0]);
            }
        }
    }

    public static class DummyLegacyDecorator
    implements ServletContextHandler.Decorator {
        public <T> T decorate(T o) {
            return o;
        }

        public void destroy(Object o) {
        }
    }

    public static class DummyUtilDecorator
    implements Decorator {
        public <T> T decorate(T o) {
            return o;
        }

        public void destroy(Object o) {
        }
    }

    public static class HelloServlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            resp.setStatus(200);
            PrintWriter writer = resp.getWriter();
            writer.write("Hello World");
        }
    }

    public static class MyTestSessionListener
    implements HttpSessionAttributeListener,
    HttpSessionListener {
        public void sessionCreated(HttpSessionEvent se) {
        }

        public void sessionDestroyed(HttpSessionEvent se) {
        }

        public void attributeAdded(HttpSessionBindingEvent event) {
        }

        public void attributeRemoved(HttpSessionBindingEvent event) {
        }

        public void attributeReplaced(HttpSessionBindingEvent event) {
        }
    }

    public static class MySessionHandler
    extends SessionHandler {
        public void checkSessionListeners(int size) {
            Assertions.assertNotNull((Object)this._sessionListeners);
            Assertions.assertEquals((int)size, (int)this._sessionListeners.size());
        }

        public void checkSessionAttributeListeners(int size) {
            Assertions.assertNotNull((Object)this._sessionAttributeListeners);
            Assertions.assertEquals((int)size, (int)this._sessionAttributeListeners.size());
        }

        public void checkSessionIdListeners(int size) {
            Assertions.assertNotNull((Object)this._sessionIdListeners);
            Assertions.assertEquals((int)size, (int)this._sessionIdListeners.size());
        }
    }

    public static class MyContextListener
    implements ServletContextListener {
        public void contextInitialized(ServletContextEvent sce) {
            Assertions.assertNull((Object)sce.getServletContext().getAttribute("MyContextListener.contextInitialized"));
            sce.getServletContext().setAttribute("MyContextListener.contextInitialized", (Object)Boolean.TRUE);
        }

        public void contextDestroyed(ServletContextEvent sce) {
            Assertions.assertNull((Object)sce.getServletContext().getAttribute("MyContextListener.contextDestroyed"));
            sce.getServletContext().setAttribute("MyContextListener.contextDestroyed", (Object)Boolean.TRUE);
        }
    }

    public static class MySCIStarter
    extends AbstractLifeCycle
    implements ServletContextHandler.ServletContainerInitializerCaller {
        MySCI _sci = new MySCI();
        ContextHandler.Context _ctx;

        MySCIStarter(ContextHandler.Context ctx) {
            this._ctx = ctx;
        }

        protected void doStart() throws Exception {
            super.doStart();
            this._ctx.setExtendedListenerTypes(true);
            this._sci.onStartup(Collections.emptySet(), (ServletContext)this._ctx);
        }
    }

    public static class MySCI
    implements ServletContainerInitializer {
        public void onStartup(Set<Class<?>> c, ServletContext ctx) throws ServletException {
            if (ctx.getAttribute("MySCI.startup") != null) {
                throw new IllegalStateException("MySCI already called");
            }
            ctx.setAttribute("MySCI.startup", (Object)Boolean.TRUE);
            ctx.addListener((EventListener)((Object)new MyContextListener()));
        }
    }
}

