/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.DebugListener;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.QuietServletException;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.StacklessLogging;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class AsyncServletTest {
    protected AsyncServlet _servlet = new AsyncServlet();
    protected int _port;
    protected Server _server = new Server();
    protected ServletHandler _servletHandler;
    protected ErrorPageErrorHandler _errorHandler;
    protected ServerConnector _connector;
    protected List<String> _log;
    protected int _expectedLogs;
    protected String _expectedCode;
    protected static List<String> __history = new CopyOnWriteArrayList<String>();
    protected static CountDownLatch __latch;
    private static AsyncListener __listener;

    static void historyAdd(String item) {
        __history.add(item);
    }

    @BeforeEach
    public void setUp() throws Exception {
        this._connector = new ServerConnector(this._server);
        this._server.setConnectors(new Connector[]{this._connector});
        this._log = new ArrayList<String>();
        Log log = new Log();
        this._server.setRequestLog((RequestLog)log);
        this._expectedLogs = 1;
        this._expectedCode = "200 ";
        ServletContextHandler context = new ServletContextHandler(0);
        context.setContextPath("/ctx");
        this._server.setHandler((Handler)context);
        context.addEventListener((EventListener)new DebugListener());
        this._errorHandler = new ErrorPageErrorHandler();
        context.setErrorHandler((ErrorHandler)this._errorHandler);
        this._errorHandler.addErrorPage(300, 599, "/error/custom");
        this._servletHandler = context.getServletHandler();
        ServletHolder holder = new ServletHolder((Servlet)this._servlet);
        holder.setAsyncSupported(true);
        this._servletHandler.addServletWithMapping(holder, "/error/*");
        this._servletHandler.addServletWithMapping(holder, "/path/*");
        this._servletHandler.addServletWithMapping(holder, "/path1/*");
        this._servletHandler.addServletWithMapping(holder, "/path2/*");
        this._servletHandler.addServletWithMapping(holder, "/p th3/*");
        this._servletHandler.addServletWithMapping(new ServletHolder((Servlet)new FwdServlet()), "/fwd/*");
        ServletHolder holder2 = new ServletHolder("NoAsync", (Servlet)this._servlet);
        holder2.setAsyncSupported(false);
        this._servletHandler.addServletWithMapping(holder2, "/noasync/*");
        this._server.start();
        this._port = this._connector.getLocalPort();
        __history.clear();
        __latch = new CountDownLatch(1);
        this._connector.addBean((Object)new HttpChannel.Listener(){

            public void onComplete(Request request) {
                __latch.countDown();
            }
        });
    }

    @AfterEach
    public void tearDown() throws Exception {
        this._server.stop();
        Assertions.assertEquals((int)this._expectedLogs, (int)this._log.size());
        MatcherAssert.assertThat((Object)this._log.get(0), (Matcher)Matchers.containsString((String)this._expectedCode));
    }

    @Test
    public void testNormal() throws Exception {
        String response = this.process(null, null);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat(__history, (Matcher)Matchers.contains((Object[])new String[]{"REQUEST /ctx/path/info", "initial"}));
        this.assertContains("NORMAL", response);
        Assertions.assertFalse((boolean)__history.contains("onTimeout"));
        Assertions.assertFalse((boolean)__history.contains("onComplete"));
    }

    @Test
    public void testSleep() throws Exception {
        String response = this.process("sleep=200", null);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat(__history, (Matcher)Matchers.contains((Object[])new String[]{"REQUEST /ctx/path/info", "initial"}));
        this.assertContains("SLEPT", response);
        Assertions.assertFalse((boolean)__history.contains("onTimeout"));
        Assertions.assertFalse((boolean)__history.contains("onComplete"));
    }

    @Test
    public void testNonAsync() throws Exception {
        String response = this.process("", null);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat(__history, (Matcher)Matchers.contains((Object[])new String[]{"REQUEST /ctx/path/info", "initial"}));
        this.assertContains("NORMAL", response);
    }

    @Test
    public void testAsyncNotSupportedNoAsync() throws Exception {
        this._expectedCode = "200 ";
        String response = this.process("noasync", "", null);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat(__history, (Matcher)Matchers.contains((Object[])new String[]{"REQUEST /ctx/noasync/info", "initial"}));
        this.assertContains("NORMAL", response);
    }

    @Test
    public void testAsyncNotSupportedAsync() throws Exception {
        try (StacklessLogging stackless = new StacklessLogging(new Class[]{HttpChannel.class});){
            this._expectedCode = "500 ";
            String response = this.process("noasync", "start=200", null);
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 500 "));
            MatcherAssert.assertThat(__history, (Matcher)Matchers.contains((Object[])new String[]{"REQUEST /ctx/noasync/info", "initial", "ERROR /ctx/error/custom", "!initial"}));
            this.assertContains("500", response);
            this.assertContains("!asyncSupported", response);
            this.assertContains("AsyncServletTest$AsyncServlet", response);
        }
    }

    @Test
    public void testStart() throws Exception {
        this._expectedCode = "500 ";
        String response = this.process("start=200", null);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 500 Server Error"));
        MatcherAssert.assertThat(__history, (Matcher)Matchers.contains((Object[])new String[]{"REQUEST /ctx/path/info", "initial", "start", "onTimeout", "ERROR /ctx/error/custom", "!initial", "onComplete"}));
        this.assertContains("ERROR DISPATCH: /ctx/error/custom", response);
    }

    @Test
    public void testStartOnTimeoutDispatch() throws Exception {
        String response = this.process("start=200&timeout=dispatch", null);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat(__history, (Matcher)Matchers.contains((Object[])new String[]{"REQUEST /ctx/path/info", "initial", "start", "onTimeout", "dispatch", "ASYNC /ctx/path/info", "!initial", "onComplete"}));
        this.assertContains("DISPATCHED", response);
    }

    @Test
    public void testStartOnTimeoutError() throws Exception {
        this._expectedCode = "500 ";
        String response = this.process("start=200&timeout=error", null);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 500 Server Error"));
        MatcherAssert.assertThat(__history, (Matcher)Matchers.contains((Object[])new String[]{"REQUEST /ctx/path/info", "initial", "start", "onTimeout", "error", "onError", "ERROR /ctx/error/custom", "!initial", "onComplete"}));
        this.assertContains("ERROR DISPATCH", response);
    }

    @Test
    public void testStartOnTimeoutErrorComplete() throws Exception {
        String response = this.process("start=200&timeout=error&error=complete", null);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat(__history, (Matcher)Matchers.contains((Object[])new String[]{"REQUEST /ctx/path/info", "initial", "start", "onTimeout", "error", "onError", "complete", "onComplete"}));
        this.assertContains("COMPLETED", response);
    }

    @Test
    public void testStartOnTimeoutErrorDispatch() throws Exception {
        String response = this.process("start=200&timeout=error&error=dispatch", null);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat(__history, (Matcher)Matchers.contains((Object[])new String[]{"REQUEST /ctx/path/info", "initial", "start", "onTimeout", "error", "onError", "dispatch", "ASYNC /ctx/path/info", "!initial", "onComplete"}));
        this.assertContains("DISPATCHED", response);
    }

    @Test
    public void testStartOnTimeoutComplete() throws Exception {
        String response = this.process("start=200&timeout=complete", null);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat(__history, (Matcher)Matchers.contains((Object[])new String[]{"REQUEST /ctx/path/info", "initial", "start", "onTimeout", "complete", "onComplete"}));
        this.assertContains("COMPLETED", response);
    }

    @Test
    public void testStartWaitDispatch() throws Exception {
        String response = this.process("start=200&dispatch=10", null);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat(__history, (Matcher)Matchers.contains((Object[])new String[]{"REQUEST /ctx/path/info", "initial", "start", "dispatch", "ASYNC /ctx/path/info", "!initial", "onComplete"}));
        Assertions.assertFalse((boolean)__history.contains("onTimeout"));
    }

    @Test
    public void testStartDispatch() throws Exception {
        String response = this.process("start=200&dispatch=0", null);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat(__history, (Matcher)Matchers.contains((Object[])new String[]{"REQUEST /ctx/path/info", "initial", "start", "dispatch", "ASYNC /ctx/path/info", "!initial", "onComplete"}));
    }

    @Test
    public void testStartError() throws Exception {
        this._expectedCode = "500 ";
        String response = this.process("start=200&throw=1", null);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 500 Server Error"));
        MatcherAssert.assertThat(__history, (Matcher)Matchers.contains((Object[])new String[]{"REQUEST /ctx/path/info", "initial", "start", "onError", "ERROR /ctx/error/custom", "!initial", "onComplete"}));
        this.assertContains("ERROR DISPATCH: /ctx/error/custom", response);
    }

    @Test
    public void testStartWaitComplete() throws Exception {
        String response = this.process("start=200&complete=50", null);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat(__history, (Matcher)Matchers.contains((Object[])new String[]{"REQUEST /ctx/path/info", "initial", "start", "complete", "onComplete"}));
        this.assertContains("COMPLETED", response);
        Assertions.assertFalse((boolean)__history.contains("onTimeout"));
        Assertions.assertFalse((boolean)__history.contains("!initial"));
    }

    @Test
    public void testStartComplete() throws Exception {
        String response = this.process("start=200&complete=0", null);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat(__history, (Matcher)Matchers.contains((Object[])new String[]{"REQUEST /ctx/path/info", "initial", "start", "complete", "onComplete"}));
        this.assertContains("COMPLETED", response);
        Assertions.assertFalse((boolean)__history.contains("onTimeout"));
        Assertions.assertFalse((boolean)__history.contains("!initial"));
    }

    @Test
    public void testStartWaitDispatchStartWaitDispatch() throws Exception {
        String response = this.process("start=1000&dispatch=10&start2=1000&dispatch2=10", null);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat(__history, (Matcher)Matchers.contains((Object[])new String[]{"REQUEST /ctx/path/info", "initial", "start", "dispatch", "ASYNC /ctx/path/info", "!initial", "onStartAsync", "start", "dispatch", "ASYNC /ctx/path/info", "!initial", "onComplete"}));
        this.assertContains("DISPATCHED", response);
    }

    @Test
    public void testStartWaitDispatchStartComplete() throws Exception {
        String response = this.process("start=1000&dispatch=10&start2=1000&complete2=10", null);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat(__history, (Matcher)Matchers.contains((Object[])new String[]{"REQUEST /ctx/path/info", "initial", "start", "dispatch", "ASYNC /ctx/path/info", "!initial", "onStartAsync", "start", "complete", "onComplete"}));
        this.assertContains("COMPLETED", response);
    }

    @Test
    public void testStartWaitDispatchStart() throws Exception {
        this._expectedCode = "500 ";
        String response = this.process("start=1000&dispatch=10&start2=10", null);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 500 Server Error"));
        MatcherAssert.assertThat(__history, (Matcher)Matchers.contains((Object[])new String[]{"REQUEST /ctx/path/info", "initial", "start", "dispatch", "ASYNC /ctx/path/info", "!initial", "onStartAsync", "start", "onTimeout", "ERROR /ctx/error/custom", "!initial", "onComplete"}));
        this.assertContains("ERROR DISPATCH: /ctx/error/custom", response);
    }

    @Test
    public void testStartTimeoutStartDispatch() throws Exception {
        String response = this.process("start=10&start2=1000&dispatch2=10", null);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat(__history, (Matcher)Matchers.contains((Object[])new String[]{"REQUEST /ctx/path/info", "initial", "start", "onTimeout", "ERROR /ctx/error/custom", "!initial", "onStartAsync", "start", "dispatch", "ASYNC /ctx/path/info", "!initial", "onComplete"}));
        this.assertContains("DISPATCHED", response);
    }

    @Test
    public void testStartTimeoutStartComplete() throws Exception {
        String response = this.process("start=10&start2=1000&complete2=10", null);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat(__history, (Matcher)Matchers.contains((Object[])new String[]{"REQUEST /ctx/path/info", "initial", "start", "onTimeout", "ERROR /ctx/error/custom", "!initial", "onStartAsync", "start", "complete", "onComplete"}));
        this.assertContains("COMPLETED", response);
    }

    @Test
    public void testStartTimeoutStart() throws Exception {
        this._expectedCode = "500 ";
        this._errorHandler.addErrorPage(500, "/path/error");
        String response = this.process("start=10&start2=10", null);
        MatcherAssert.assertThat(__history, (Matcher)Matchers.contains((Object[])new String[]{"REQUEST /ctx/path/info", "initial", "start", "onTimeout", "ERROR /ctx/path/error", "!initial", "onStartAsync", "start", "onTimeout", "onComplete"}));
        this.assertContains("HTTP ERROR 500", response);
    }

    @Test
    public void testWrapStartDispatch() throws Exception {
        String response = this.process("wrap=true&start=200&dispatch=20", null);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat(__history, (Matcher)Matchers.contains((Object[])new String[]{"REQUEST /ctx/path/info", "initial", "start", "dispatch", "ASYNC /ctx/path/info", "wrapped REQ RSP", "!initial", "onComplete"}));
        this.assertContains("DISPATCHED", response);
    }

    @Test
    public void testStartDispatchEncodedPath() throws Exception {
        String response = this.process("start=200&dispatch=20&path=/p%20th3", null);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat(__history, (Matcher)Matchers.contains((Object[])new String[]{"REQUEST /ctx/path/info", "initial", "start", "dispatch", "ASYNC /ctx/p%20th3", "!initial", "onComplete"}));
        this.assertContains("DISPATCHED", response);
    }

    @Test
    public void testFwdStartDispatch() throws Exception {
        String response = this.process("fwd", "start=200&dispatch=20", null);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat(__history, (Matcher)Matchers.contains((Object[])new String[]{"FWD REQUEST /ctx/fwd/info", "FORWARD /ctx/path1", "initial", "start", "dispatch", "FWD ASYNC /ctx/fwd/info", "FORWARD /ctx/path1", "!initial", "onComplete"}));
        this.assertContains("DISPATCHED", response);
    }

    @Test
    public void testFwdStartDispatchPath() throws Exception {
        String response = this.process("fwd", "start=200&dispatch=20&path=/path2", null);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat(__history, (Matcher)Matchers.contains((Object[])new String[]{"FWD REQUEST /ctx/fwd/info", "FORWARD /ctx/path1", "initial", "start", "dispatch", "ASYNC /ctx/path2", "!initial", "onComplete"}));
        this.assertContains("DISPATCHED", response);
    }

    @Test
    public void testFwdWrapStartDispatch() throws Exception {
        String response = this.process("fwd", "wrap=true&start=200&dispatch=20", null);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat(__history, (Matcher)Matchers.contains((Object[])new String[]{"FWD REQUEST /ctx/fwd/info", "FORWARD /ctx/path1", "initial", "start", "dispatch", "ASYNC /ctx/path1", "wrapped REQ RSP", "!initial", "onComplete"}));
        this.assertContains("DISPATCHED", response);
    }

    @Test
    public void testFwdWrapStartDispatchPath() throws Exception {
        String response = this.process("fwd", "wrap=true&start=200&dispatch=20&path=/path2", null);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat(__history, (Matcher)Matchers.contains((Object[])new String[]{"FWD REQUEST /ctx/fwd/info", "FORWARD /ctx/path1", "initial", "start", "dispatch", "ASYNC /ctx/path2", "wrapped REQ RSP", "!initial", "onComplete"}));
        this.assertContains("DISPATCHED", response);
    }

    @Test
    public void testAsyncRead() throws Exception {
        String header = "GET /ctx/path/info?start=2000&dispatch=1500 HTTP/1.1\r\nHost: localhost\r\nContent-Length: 10\r\nConnection: close\r\n\r\n";
        String body = "12345678\r\n";
        try (Socket socket = new Socket("localhost", this._port);){
            socket.setSoTimeout(10000);
            socket.getOutputStream().write(header.getBytes(StandardCharsets.ISO_8859_1));
            socket.getOutputStream().write(body.getBytes(StandardCharsets.ISO_8859_1), 0, 2);
            Thread.sleep(500L);
            socket.getOutputStream().write(body.getBytes(StandardCharsets.ISO_8859_1), 2, 8);
            String response = IO.toString((InputStream)socket.getInputStream());
            __latch.await(1L, TimeUnit.SECONDS);
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
            MatcherAssert.assertThat(__history, (Matcher)Matchers.contains((Object[])new String[]{"REQUEST /ctx/path/info", "initial", "start", "async-read=10", "dispatch", "ASYNC /ctx/path/info", "!initial", "onComplete"}));
        }
    }

    public synchronized String process(String query, String content) throws Exception {
        return this.process("path", query, content);
    }

    public synchronized String process(String path, String query, String content) throws Exception {
        String string;
        String request = "GET /ctx/" + path + "/info";
        if (query != null) {
            request = request + "?" + query;
        }
        request = request + " HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\n";
        if (content == null) {
            request = request + "\r\n";
        } else {
            request = request + "Content-Length: " + content.length() + "\r\n";
            request = request + "\r\n" + content;
        }
        int port = this._port;
        Socket socket = new Socket("localhost", port);
        try {
            socket.setSoTimeout(1000000);
            socket.getOutputStream().write(request.getBytes(StandardCharsets.UTF_8));
            socket.getOutputStream().flush();
            String response = IO.toString((InputStream)socket.getInputStream());
            __latch.await(1L, TimeUnit.SECONDS);
            string = response;
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                System.err.println("failed on port " + port);
                e.printStackTrace();
                throw e;
            }
        }
        socket.close();
        return string;
    }

    protected void assertContains(String content, String response) {
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)content));
    }

    protected void assertNotContains(String content, String response) {
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)content)));
    }

    static {
        __listener = new AsyncListener(){

            public void onTimeout(AsyncEvent event) throws IOException {
                AsyncServletTest.historyAdd("onTimeout");
                String action = event.getSuppliedRequest().getParameter("timeout");
                if (action != null) {
                    AsyncServletTest.historyAdd(action);
                    switch (action) {
                        case "dispatch": {
                            event.getAsyncContext().dispatch();
                            break;
                        }
                        case "complete": {
                            event.getSuppliedResponse().getOutputStream().println("COMPLETED\n");
                            event.getAsyncContext().complete();
                            break;
                        }
                        case "error": {
                            throw new RuntimeException("error in onTimeout");
                        }
                    }
                }
            }

            public void onStartAsync(AsyncEvent event) throws IOException {
                AsyncServletTest.historyAdd("onStartAsync");
            }

            public void onError(AsyncEvent event) throws IOException {
                AsyncServletTest.historyAdd("onError");
                String action = event.getSuppliedRequest().getParameter("error");
                if (action != null) {
                    AsyncServletTest.historyAdd(action);
                    switch (action) {
                        case "dispatch": {
                            event.getAsyncContext().dispatch();
                            break;
                        }
                        case "complete": {
                            event.getSuppliedResponse().getOutputStream().println("COMPLETED\n");
                            event.getAsyncContext().complete();
                        }
                    }
                }
            }

            public void onComplete(AsyncEvent event) throws IOException {
                AsyncServletTest.historyAdd("onComplete");
            }
        };
    }

    class Log
    extends AbstractLifeCycle
    implements RequestLog {
        Log() {
        }

        public void log(Request request, Response response) {
            int status = response.getCommittedMetaData().getStatus();
            long written = response.getHttpChannel().getBytesWritten();
            AsyncServletTest.this._log.add(status + " " + written + " " + request.getRequestURI());
        }
    }

    private static class AsyncServlet
    extends HttpServlet {
        private static final long serialVersionUID = -8161977157098646562L;
        private final Timer _timer = new Timer();

        private AsyncServlet() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doGet(final HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
            try {
                request.getAsyncContext();
                throw new IllegalStateException();
            }
            catch (IllegalStateException illegalStateException) {
                AsyncServletTest.historyAdd(request.getDispatcherType() + " " + request.getRequestURI());
                if (request instanceof ServletRequestWrapper || response instanceof ServletResponseWrapper) {
                    AsyncServletTest.historyAdd("wrapped" + (request instanceof ServletRequestWrapper ? " REQ" : "") + (response instanceof ServletResponseWrapper ? " RSP" : ""));
                }
                boolean wrap = "true".equals(request.getParameter("wrap"));
                int read_before = 0;
                long sleep_for = -1L;
                long start_for = -1L;
                long start2_for = -1L;
                long dispatch_after = -1L;
                long dispatch2_after = -1L;
                long complete_after = -1L;
                long complete2_after = -1L;
                if (request.getParameter("read") != null) {
                    read_before = Integer.parseInt(request.getParameter("read"));
                }
                if (request.getParameter("sleep") != null) {
                    sleep_for = Integer.parseInt(request.getParameter("sleep"));
                }
                if (request.getParameter("start") != null) {
                    start_for = Integer.parseInt(request.getParameter("start"));
                }
                if (request.getParameter("start2") != null) {
                    start2_for = Integer.parseInt(request.getParameter("start2"));
                }
                if (request.getParameter("dispatch") != null) {
                    dispatch_after = Integer.parseInt(request.getParameter("dispatch"));
                }
                final String path = request.getParameter("path");
                if (request.getParameter("dispatch2") != null) {
                    dispatch2_after = Integer.parseInt(request.getParameter("dispatch2"));
                }
                if (request.getParameter("complete") != null) {
                    complete_after = Integer.parseInt(request.getParameter("complete"));
                }
                if (request.getParameter("complete2") != null) {
                    complete2_after = Integer.parseInt(request.getParameter("complete2"));
                }
                if (request.getAttribute("State") == null) {
                    request.setAttribute("State", (Object)new Integer(1));
                    AsyncServletTest.historyAdd("initial");
                    if (read_before > 0) {
                        byte[] buf = new byte[read_before];
                        request.getInputStream().read(buf);
                    } else if (read_before < 0) {
                        ServletInputStream in = request.getInputStream();
                        int b = in.read();
                        while (b != -1) {
                            b = in.read();
                        }
                    } else if (request.getContentLength() > 0) {
                        new Thread(){

                            @Override
                            public void run() {
                                int c = 0;
                                try {
                                    ServletInputStream in = request.getInputStream();
                                    int b = 0;
                                    while (b != -1) {
                                        b = in.read();
                                        if (b < 0) continue;
                                        ++c;
                                    }
                                    AsyncServletTest.historyAdd("async-read=" + c);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }.start();
                    }
                    if (start_for >= 0L) {
                        AsyncContext async;
                        AsyncContext asyncContext = async = wrap ? request.startAsync((ServletRequest)new HttpServletRequestWrapper(request), (ServletResponse)new HttpServletResponseWrapper(response)) : request.startAsync();
                        if (start_for > 0L) {
                            async.setTimeout(start_for);
                        }
                        async.addListener(__listener);
                        AsyncServletTest.historyAdd("start");
                        if ("1".equals(request.getParameter("throw"))) {
                            throw new QuietServletException((Throwable)new Exception("test throw in async 1"));
                        }
                        if (complete_after > 0L) {
                            TimerTask complete = new TimerTask(){

                                @Override
                                public void run() {
                                    try {
                                        response.setStatus(200);
                                        response.getOutputStream().println("COMPLETED\n");
                                        AsyncServletTest.historyAdd("complete");
                                        async.complete();
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                            };
                            Timer timer = this._timer;
                            synchronized (timer) {
                                this._timer.schedule(complete, complete_after);
                            }
                        } else if (complete_after == 0L) {
                            response.setStatus(200);
                            response.getOutputStream().println("COMPLETED\n");
                            AsyncServletTest.historyAdd("complete");
                            async.complete();
                        } else if (dispatch_after > 0L) {
                            TimerTask dispatch = new TimerTask(){

                                @Override
                                public void run() {
                                    AsyncServletTest.historyAdd("dispatch");
                                    if (path != null) {
                                        int q = path.indexOf(63);
                                        String uriInContext = q >= 0 ? URIUtil.encodePath((String)path.substring(0, q)) + path.substring(q) : URIUtil.encodePath((String)path);
                                        async.dispatch(uriInContext);
                                    } else {
                                        async.dispatch();
                                    }
                                }
                            };
                            Timer timer = this._timer;
                            synchronized (timer) {
                                this._timer.schedule(dispatch, dispatch_after);
                            }
                        } else if (dispatch_after == 0L) {
                            AsyncServletTest.historyAdd("dispatch");
                            if (path != null) {
                                async.dispatch(path);
                            } else {
                                async.dispatch();
                            }
                        }
                    } else if (sleep_for >= 0L) {
                        try {
                            Thread.sleep(sleep_for);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        response.setStatus(200);
                        response.getOutputStream().println("SLEPT\n");
                    } else {
                        response.setStatus(200);
                        response.getOutputStream().println("NORMAL\n");
                    }
                } else {
                    AsyncServletTest.historyAdd("!initial");
                    if (start2_for >= 0L && request.getAttribute("2nd") == null) {
                        final AsyncContext async = wrap ? request.startAsync((ServletRequest)new HttpServletRequestWrapper(request), (ServletResponse)new HttpServletResponseWrapper(response)) : request.startAsync();
                        async.addListener(__listener);
                        request.setAttribute("2nd", (Object)"cycle");
                        if (start2_for > 0L) {
                            async.setTimeout(start2_for);
                        }
                        AsyncServletTest.historyAdd("start");
                        if ("2".equals(request.getParameter("throw"))) {
                            throw new QuietServletException((Throwable)new Exception("test throw in async 2"));
                        }
                        if (complete2_after > 0L) {
                            TimerTask complete = new TimerTask(){

                                @Override
                                public void run() {
                                    try {
                                        response.setStatus(200);
                                        response.getOutputStream().println("COMPLETED\n");
                                        AsyncServletTest.historyAdd("complete");
                                        async.complete();
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                            };
                            Timer timer = this._timer;
                            synchronized (timer) {
                                this._timer.schedule(complete, complete2_after);
                            }
                        } else if (complete2_after == 0L) {
                            response.setStatus(200);
                            response.getOutputStream().println("COMPLETED\n");
                            AsyncServletTest.historyAdd("complete");
                            async.complete();
                        } else if (dispatch2_after > 0L) {
                            TimerTask dispatch = new TimerTask(){

                                @Override
                                public void run() {
                                    AsyncServletTest.historyAdd("dispatch");
                                    async.dispatch();
                                }
                            };
                            Timer timer = this._timer;
                            synchronized (timer) {
                                this._timer.schedule(dispatch, dispatch2_after);
                            }
                        } else if (dispatch2_after == 0L) {
                            AsyncServletTest.historyAdd("dispatch");
                            async.dispatch();
                        }
                    } else if (request.getDispatcherType() == DispatcherType.ERROR) {
                        response.getOutputStream().println("ERROR DISPATCH: " + request.getContextPath() + request.getServletPath() + request.getPathInfo());
                        response.getOutputStream().println("" + request.getAttribute("javax.servlet.error.status_code"));
                        response.getOutputStream().println("" + request.getAttribute("javax.servlet.error.message"));
                    } else {
                        response.setStatus(200);
                        response.getOutputStream().println("DISPATCHED");
                    }
                }
                return;
            }
        }
    }

    private static class FwdServlet
    extends HttpServlet {
        private FwdServlet() {
        }

        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            AsyncServletTest.historyAdd("FWD " + request.getDispatcherType() + " " + request.getRequestURI());
            if (request instanceof ServletRequestWrapper || response instanceof ServletResponseWrapper) {
                AsyncServletTest.historyAdd("wrapped" + (request instanceof ServletRequestWrapper ? " REQ" : "") + (response instanceof ServletResponseWrapper ? " RSP" : ""));
            }
            request.getServletContext().getRequestDispatcher("/path1").forward((ServletRequest)request, (ServletResponse)response);
        }
    }
}

