/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.server.Dispatcher;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ErrorPageErrorHandler
extends ErrorHandler {
    private static final Logger LOG = Log.getLogger(ErrorPageErrorHandler.class);
    public static final String ERROR_PAGE = "org.eclipse.jetty.server.error_page";
    protected ServletContext _servletContext;
    private final Map<String, String> _errorPages = new HashMap<String, String>();
    private final List<ErrorCodeRange> _errorPageList = new ArrayList<ErrorCodeRange>();

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String method = request.getMethod();
        if (!(HttpMethod.GET.is(method) || HttpMethod.POST.is(method) || HttpMethod.HEAD.is(method))) {
            baseRequest.setHandled(true);
            return;
        }
        if (this._errorPages != null) {
            String old_error_page;
            Integer code;
            String error_page = null;
            Class<Object> exClass = (Class)request.getAttribute("javax.servlet.error.exception_type");
            if (ServletException.class.equals((Object)exClass) && (error_page = this._errorPages.get(exClass.getName())) == null) {
                Throwable th = (Throwable)request.getAttribute("javax.servlet.error.exception");
                while (th instanceof ServletException) {
                    th = ((ServletException)th).getRootCause();
                }
                if (th != null) {
                    exClass = th.getClass();
                }
            }
            while (error_page == null && exClass != null) {
                error_page = this._errorPages.get(exClass.getName());
                exClass = exClass.getSuperclass();
            }
            if (error_page == null && (code = (Integer)request.getAttribute("javax.servlet.error.status_code")) != null && (error_page = this._errorPages.get(Integer.toString(code))) == null && this._errorPageList != null) {
                for (int i = 0; i < this._errorPageList.size(); ++i) {
                    ErrorCodeRange errCode = this._errorPageList.get(i);
                    if (!errCode.isInRange(code)) continue;
                    error_page = errCode.getUri();
                    break;
                }
            }
            if (!(error_page == null || (old_error_page = (String)request.getAttribute(ERROR_PAGE)) != null && old_error_page.equals(error_page))) {
                request.setAttribute(ERROR_PAGE, (Object)error_page);
                Dispatcher dispatcher = (Dispatcher)this._servletContext.getRequestDispatcher(error_page);
                try {
                    if (dispatcher != null) {
                        dispatcher.error((ServletRequest)request, (ServletResponse)response);
                        return;
                    }
                    LOG.warn("No error page " + error_page, new Object[0]);
                }
                catch (ServletException e) {
                    LOG.warn("EXCEPTION ", (Throwable)e);
                    return;
                }
            }
        }
        super.handle(target, baseRequest, request, response);
    }

    public Map<String, String> getErrorPages() {
        return this._errorPages;
    }

    public void setErrorPages(Map<String, String> errorPages) {
        this._errorPages.clear();
        if (errorPages != null) {
            this._errorPages.putAll(errorPages);
        }
    }

    public void addErrorPage(Class<? extends Throwable> exception, String uri) {
        this._errorPages.put(exception.getName(), uri);
    }

    public void addErrorPage(String exceptionClassName, String uri) {
        this._errorPages.put(exceptionClassName, uri);
    }

    public void addErrorPage(int code, String uri) {
        this._errorPages.put(Integer.toString(code), uri);
    }

    public void addErrorPage(int from, int to, String uri) {
        this._errorPageList.add(new ErrorCodeRange(from, to, uri));
    }

    protected void doStart() throws Exception {
        super.doStart();
        this._servletContext = ContextHandler.getCurrentContext();
    }

    protected void doStop() throws Exception {
        super.doStop();
    }

    private class ErrorCodeRange {
        private int _from;
        private int _to;
        private String _uri;

        ErrorCodeRange(int from, int to, String uri) throws IllegalArgumentException {
            if (from > to) {
                throw new IllegalArgumentException("from>to");
            }
            this._from = from;
            this._to = to;
            this._uri = uri;
        }

        boolean isInRange(int value) {
            return value >= this._from && value <= this._to;
        }

        String getUri() {
            return this._uri;
        }

        public String toString() {
            return "from: " + this._from + ",to: " + this._to + ",uri: " + this._uri;
        }
    }
}

