/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.continuation.ContinuationThrowable;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.jetty.http.PathMap;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.io.RuntimeIOException;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.Dispatcher;
import org.eclipse.jetty.server.DispatcherType;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServletRequestHttpWrapper;
import org.eclipse.jetty.server.ServletResponseHttpWrapper;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ScopedHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.FilterMapping;
import org.eclipse.jetty.servlet.Holder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.ServletMapping;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.MultiException;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletHandler
extends ScopedHandler {
    private static final Logger LOG = Log.getLogger(ServletHandler.class);
    public static final String __DEFAULT_SERVLET = "default";
    private ServletContextHandler _contextHandler;
    private ContextHandler.Context _servletContext;
    private FilterHolder[] _filters = new FilterHolder[0];
    private FilterMapping[] _filterMappings;
    private boolean _filterChainsCached = true;
    private int _maxFilterChainsCacheSize = 512;
    private boolean _startWithUnavailable = true;
    private IdentityService _identityService;
    private ServletHolder[] _servlets = new ServletHolder[0];
    private ServletMapping[] _servletMappings;
    private final Map<String, FilterHolder> _filterNameMap = new HashMap<String, FilterHolder>();
    private List<FilterMapping> _filterPathMappings;
    private MultiMap<String> _filterNameMappings;
    private final Map<String, ServletHolder> _servletNameMap = new HashMap<String, ServletHolder>();
    private PathMap _servletPathMap;
    protected final ConcurrentMap<String, FilterChain>[] _chainCache = new ConcurrentMap[31];
    protected final Queue<String>[] _chainLRU = new Queue[31];

    public void setServer(Server server) {
        Server old = this.getServer();
        if (old != null && old != server) {
            this.getServer().getContainer().update((Object)this, (Object[])this._filters, null, "filter", true);
            this.getServer().getContainer().update((Object)this, (Object[])this._filterMappings, null, "filterMapping", true);
            this.getServer().getContainer().update((Object)this, (Object[])this._servlets, null, "servlet", true);
            this.getServer().getContainer().update((Object)this, (Object[])this._servletMappings, null, "servletMapping", true);
        }
        super.setServer(server);
        if (server != null && old != server) {
            server.getContainer().update((Object)this, null, (Object[])this._filters, "filter", true);
            server.getContainer().update((Object)this, null, (Object[])this._filterMappings, "filterMapping", true);
            server.getContainer().update((Object)this, null, (Object[])this._servlets, "servlet", true);
            server.getContainer().update((Object)this, null, (Object[])this._servletMappings, "servletMapping", true);
        }
    }

    protected synchronized void doStart() throws Exception {
        SecurityHandler security_handler;
        this._servletContext = ContextHandler.getCurrentContext();
        this._contextHandler = (ServletContextHandler)(this._servletContext == null ? null : this._servletContext.getContextHandler());
        if (this._contextHandler != null && (security_handler = (SecurityHandler)this._contextHandler.getChildHandlerByClass(SecurityHandler.class)) != null) {
            this._identityService = security_handler.getIdentityService();
        }
        this.updateNameMappings();
        this.updateMappings();
        if (this._filterChainsCached) {
            this._chainCache[1] = new ConcurrentHashMap<String, FilterChain>();
            this._chainCache[2] = new ConcurrentHashMap<String, FilterChain>();
            this._chainCache[4] = new ConcurrentHashMap<String, FilterChain>();
            this._chainCache[8] = new ConcurrentHashMap<String, FilterChain>();
            this._chainCache[16] = new ConcurrentHashMap<String, FilterChain>();
            this._chainLRU[1] = new ConcurrentLinkedQueue<String>();
            this._chainLRU[2] = new ConcurrentLinkedQueue<String>();
            this._chainLRU[4] = new ConcurrentLinkedQueue<String>();
            this._chainLRU[8] = new ConcurrentLinkedQueue<String>();
            this._chainLRU[16] = new ConcurrentLinkedQueue<String>();
        }
        super.doStart();
        if (this._contextHandler == null || !(this._contextHandler instanceof ServletContextHandler)) {
            this.initialize();
        }
    }

    protected synchronized void doStop() throws Exception {
        int i;
        super.doStop();
        if (this._filters != null) {
            i = this._filters.length;
            while (i-- > 0) {
                try {
                    this._filters[i].stop();
                }
                catch (Exception e) {
                    LOG.warn("EXCEPTION ", (Throwable)e);
                }
            }
        }
        if (this._servlets != null) {
            i = this._servlets.length;
            while (i-- > 0) {
                try {
                    this._servlets[i].stop();
                }
                catch (Exception e) {
                    LOG.warn("EXCEPTION ", (Throwable)e);
                }
            }
        }
        this._filterPathMappings = null;
        this._filterNameMappings = null;
        this._servletPathMap = null;
    }

    IdentityService getIdentityService() {
        return this._identityService;
    }

    public Object getContextLog() {
        return null;
    }

    public FilterMapping[] getFilterMappings() {
        return this._filterMappings;
    }

    public FilterHolder[] getFilters() {
        return this._filters;
    }

    public PathMap.Entry getHolderEntry(String pathInContext) {
        if (this._servletPathMap == null) {
            return null;
        }
        return this._servletPathMap.getMatch(pathInContext);
    }

    public RequestDispatcher getRequestDispatcher(String uriInContext) {
        if (uriInContext == null || this._contextHandler == null) {
            return null;
        }
        if (!uriInContext.startsWith("/")) {
            return null;
        }
        try {
            String query = null;
            int q = uriInContext.indexOf(63);
            if (q > 0) {
                query = uriInContext.substring(q + 1);
                uriInContext = uriInContext.substring(0, q);
            }
            if ((q = uriInContext.indexOf(59)) > 0) {
                uriInContext = uriInContext.substring(0, q);
            }
            String pathInContext = URIUtil.canonicalPath((String)URIUtil.decodePath((String)uriInContext));
            String uri = URIUtil.addPaths((String)this._contextHandler.getContextPath(), (String)uriInContext);
            return new Dispatcher((ContextHandler)this._contextHandler, uri, pathInContext, query);
        }
        catch (Exception e) {
            LOG.ignore((Throwable)e);
            return null;
        }
    }

    public ServletContext getServletContext() {
        return this._servletContext;
    }

    public ServletMapping[] getServletMappings() {
        return this._servletMappings;
    }

    public ServletMapping getServletMapping(String pattern) {
        if (this._servletMappings != null) {
            for (ServletMapping m : this._servletMappings) {
                String[] paths = m.getPathSpecs();
                if (paths == null) continue;
                for (String path : paths) {
                    if (!pattern.equals(path)) continue;
                    return m;
                }
            }
        }
        return null;
    }

    public ServletHolder[] getServlets() {
        return this._servlets;
    }

    public ServletHolder getServlet(String name) {
        return this._servletNameMap.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doScope(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String old_servlet_path = baseRequest.getServletPath();
        String old_path_info = baseRequest.getPathInfo();
        DispatcherType type = baseRequest.getDispatcherType();
        ServletHolder servlet_holder = null;
        UserIdentity.Scope old_scope = null;
        if (target.startsWith("/")) {
            PathMap.Entry entry = this.getHolderEntry(target);
            if (entry != null) {
                servlet_holder = (ServletHolder)entry.getValue();
                String servlet_path_spec = (String)entry.getKey();
                String servlet_path = entry.getMapped() != null ? entry.getMapped() : PathMap.pathMatch((String)servlet_path_spec, (String)target);
                String path_info = PathMap.pathInfo((String)servlet_path_spec, (String)target);
                if (DispatcherType.INCLUDE.equals((Object)type)) {
                    baseRequest.setAttribute("javax.servlet.include.servlet_path", (Object)servlet_path);
                    baseRequest.setAttribute("javax.servlet.include.path_info", (Object)path_info);
                } else {
                    baseRequest.setServletPath(servlet_path);
                    baseRequest.setPathInfo(path_info);
                }
            }
        } else {
            servlet_holder = this._servletNameMap.get(target);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("servlet {} -> {}", new Object[]{baseRequest.getContextPath() + "|" + baseRequest.getServletPath() + "|" + baseRequest.getPathInfo(), servlet_holder});
        }
        try {
            if (servlet_holder != null) {
                old_scope = baseRequest.getUserIdentityScope();
                baseRequest.setUserIdentityScope((UserIdentity.Scope)servlet_holder);
                if (this.never()) {
                    this.nextScope(target, baseRequest, request, response);
                } else if (this._nextScope != null) {
                    this._nextScope.doScope(target, baseRequest, request, response);
                } else if (this._outerScope != null) {
                    this._outerScope.doHandle(target, baseRequest, request, response);
                } else {
                    this.doHandle(target, baseRequest, request, response);
                }
            }
        }
        finally {
            if (old_scope != null) {
                baseRequest.setUserIdentityScope(old_scope);
            }
            if (!DispatcherType.INCLUDE.equals((Object)type)) {
                baseRequest.setServletPath(old_servlet_path);
                baseRequest.setPathInfo(old_path_info);
            }
        }
    }

    public void doHandle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        DispatcherType type = baseRequest.getDispatcherType();
        ServletHolder servlet_holder = (ServletHolder)baseRequest.getUserIdentityScope();
        FilterChain chain = null;
        if (target.startsWith("/")) {
            if (servlet_holder != null && this._filterMappings != null && this._filterMappings.length > 0) {
                chain = this.getFilterChain(baseRequest, target, servlet_holder);
            }
        } else if (servlet_holder != null && this._filterMappings != null && this._filterMappings.length > 0) {
            chain = this.getFilterChain(baseRequest, null, servlet_holder);
        }
        LOG.debug("chain=", new Object[]{chain});
        try {
            if (servlet_holder == null) {
                this.notFound(request, response);
            } else {
                HttpServletResponse res;
                HttpServletRequest req = request;
                if (req instanceof ServletRequestHttpWrapper) {
                    req = ((ServletRequestHttpWrapper)req).getRequest();
                }
                if ((res = response) instanceof ServletResponseHttpWrapper) {
                    res = ((ServletResponseHttpWrapper)res).getResponse();
                }
                baseRequest.setHandled(true);
                if (chain != null) {
                    chain.doFilter((ServletRequest)req, (ServletResponse)res);
                } else {
                    servlet_holder.handle(baseRequest, (ServletRequest)req, (ServletResponse)res);
                }
            }
        }
        catch (EofException e) {
            throw e;
        }
        catch (RuntimeIOException e) {
            throw e;
        }
        catch (ContinuationThrowable e) {
            throw e;
        }
        catch (Exception e) {
            Throwable cause;
            Throwable th;
            if (!DispatcherType.REQUEST.equals((Object)type) && !DispatcherType.ASYNC.equals((Object)type)) {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                if (e instanceof ServletException) {
                    throw (ServletException)((Object)e);
                }
            }
            if ((th = e) instanceof UnavailableException) {
                LOG.debug(th);
            } else if (th instanceof ServletException) {
                LOG.debug(th);
                cause = ((ServletException)th).getRootCause();
                if (cause != null) {
                    th = cause;
                }
            } else if (th instanceof RuntimeIOException) {
                LOG.debug(th);
                cause = (IOException)((RuntimeIOException)th).getCause();
                if (cause != null) {
                    th = cause;
                }
            }
            if (th instanceof HttpException) {
                throw (HttpException)th;
            }
            if (th instanceof RuntimeIOException) {
                throw (RuntimeIOException)th;
            }
            if (th instanceof EofException) {
                throw (EofException)th;
            }
            if (LOG.isDebugEnabled()) {
                LOG.warn(request.getRequestURI(), th);
                LOG.debug(request.toString(), new Object[0]);
            } else if (th instanceof IOException || th instanceof UnavailableException) {
                LOG.debug(request.getRequestURI(), th);
            } else {
                LOG.warn(request.getRequestURI(), th);
            }
            if (!response.isCommitted()) {
                request.setAttribute("javax.servlet.error.exception_type", th.getClass());
                request.setAttribute("javax.servlet.error.exception", (Object)th);
                if (th instanceof UnavailableException) {
                    UnavailableException ue = (UnavailableException)th;
                    if (ue.isPermanent()) {
                        response.sendError(404, th.getMessage());
                    } else {
                        response.sendError(503, th.getMessage());
                    }
                } else {
                    response.sendError(500, th.getMessage());
                }
            } else {
                LOG.debug("Response already committed for handling " + th, new Object[0]);
            }
        }
        catch (Error e) {
            if (!DispatcherType.REQUEST.equals((Object)type) && !DispatcherType.ASYNC.equals((Object)type)) {
                throw e;
            }
            LOG.warn("Error for " + request.getRequestURI(), (Throwable)e);
            if (LOG.isDebugEnabled()) {
                LOG.debug(request.toString(), new Object[0]);
            }
            if (!response.isCommitted()) {
                request.setAttribute("javax.servlet.error.exception_type", e.getClass());
                request.setAttribute("javax.servlet.error.exception", (Object)e);
                response.sendError(500, e.getMessage());
            }
            LOG.debug("Response already committed for handling ", (Throwable)e);
        }
    }

    private FilterChain getFilterChain(Request baseRequest, String pathInContext, ServletHolder servletHolder) {
        FilterChain chain;
        String key = pathInContext == null ? servletHolder.getName() : pathInContext;
        int dispatch = FilterMapping.dispatch(baseRequest.getDispatcherType());
        if (this._filterChainsCached && this._chainCache != null && (chain = (FilterChain)this._chainCache[dispatch].get(key)) != null) {
            return chain;
        }
        Object filters = null;
        if (pathInContext != null && this._filterPathMappings != null) {
            for (int i = 0; i < this._filterPathMappings.size(); ++i) {
                FilterMapping mapping = this._filterPathMappings.get(i);
                if (!mapping.appliesTo(pathInContext, dispatch)) continue;
                filters = LazyList.add(filters, (Object)((Object)mapping.getFilterHolder()));
            }
        }
        if (servletHolder != null && this._filterNameMappings != null && this._filterNameMappings.size() > 0 && this._filterNameMappings.size() > 0) {
            FilterMapping mapping;
            int i;
            Object o = this._filterNameMappings.get((Object)servletHolder.getName());
            for (i = 0; i < LazyList.size((Object)o); ++i) {
                mapping = (FilterMapping)LazyList.get((Object)o, (int)i);
                if (!mapping.appliesTo(dispatch)) continue;
                filters = LazyList.add((Object)filters, (Object)((Object)mapping.getFilterHolder()));
            }
            o = this._filterNameMappings.get((Object)"*");
            for (i = 0; i < LazyList.size((Object)o); ++i) {
                mapping = (FilterMapping)LazyList.get((Object)o, (int)i);
                if (!mapping.appliesTo(dispatch)) continue;
                filters = LazyList.add((Object)filters, (Object)((Object)mapping.getFilterHolder()));
            }
        }
        if (filters == null) {
            return null;
        }
        Object chain2 = null;
        if (this._filterChainsCached) {
            if (LazyList.size(filters) > 0) {
                chain2 = new CachedChain(filters, servletHolder);
            }
            ConcurrentMap<String, FilterChain> cache = this._chainCache[dispatch];
            Queue<String> lru = this._chainLRU[dispatch];
            while (this._maxFilterChainsCacheSize > 0 && cache.size() >= this._maxFilterChainsCacheSize) {
                String k = lru.poll();
                if (k == null) {
                    cache.clear();
                    break;
                }
                cache.remove(k);
            }
            cache.put(key, (FilterChain)chain2);
            lru.add(key);
        } else if (LazyList.size(filters) > 0) {
            chain2 = new Chain(baseRequest, filters, servletHolder);
        }
        return chain2;
    }

    private void invalidateChainsCache() {
        if (this._chainLRU[1] != null) {
            this._chainLRU[1].clear();
            this._chainLRU[2].clear();
            this._chainLRU[4].clear();
            this._chainLRU[8].clear();
            this._chainLRU[16].clear();
            this._chainCache[1].clear();
            this._chainCache[2].clear();
            this._chainCache[4].clear();
            this._chainCache[8].clear();
            this._chainCache[16].clear();
        }
    }

    public boolean isAvailable() {
        if (!this.isStarted()) {
            return false;
        }
        ServletHolder[] holders = this.getServlets();
        for (int i = 0; i < holders.length; ++i) {
            ServletHolder holder = holders[i];
            if (holder == null || holder.isAvailable()) continue;
            return false;
        }
        return true;
    }

    public void setStartWithUnavailable(boolean start) {
        this._startWithUnavailable = start;
    }

    public boolean isStartWithUnavailable() {
        return this._startWithUnavailable;
    }

    public void initialize() throws Exception {
        MultiException mx = new MultiException();
        if (this._filters != null) {
            for (int i = 0; i < this._filters.length; ++i) {
                this._filters[i].start();
            }
        }
        if (this._servlets != null) {
            Object[] servlets = (ServletHolder[])this._servlets.clone();
            Arrays.sort(servlets);
            for (int i = 0; i < servlets.length; ++i) {
                try {
                    if (((Holder)((Object)servlets[i])).getClassName() == null && ((ServletHolder)servlets[i]).getForcedPath() != null) {
                        ServletHolder forced_holder = (ServletHolder)this._servletPathMap.match(((ServletHolder)servlets[i]).getForcedPath());
                        if (forced_holder == null || forced_holder.getClassName() == null) {
                            mx.add((Throwable)new IllegalStateException("No forced path servlet for " + ((ServletHolder)servlets[i]).getForcedPath()));
                            continue;
                        }
                        ((Holder)((Object)servlets[i])).setClassName(forced_holder.getClassName());
                    }
                    servlets[i].start();
                    continue;
                }
                catch (Throwable e) {
                    LOG.debug("EXCEPTION ", e);
                    mx.add(e);
                }
            }
            mx.ifExceptionThrow();
        }
    }

    public boolean isFilterChainsCached() {
        return this._filterChainsCached;
    }

    public ServletHolder newServletHolder() {
        return new ServletHolder();
    }

    public ServletHolder newServletHolder(Class<? extends Servlet> servlet) {
        return new ServletHolder(servlet);
    }

    public ServletHolder addServletWithMapping(String className, String pathSpec) {
        ServletHolder holder = this.newServletHolder(null);
        holder.setName(className + "-" + LazyList.size((Object)this._servlets));
        holder.setClassName(className);
        this.addServletWithMapping(holder, pathSpec);
        return holder;
    }

    public ServletHolder addServletWithMapping(Class<? extends Servlet> servlet, String pathSpec) {
        ServletHolder holder = this.newServletHolder();
        holder.setHeldClass(servlet);
        this.setServlets((ServletHolder[])LazyList.addToArray((Object[])this.getServlets(), (Object)holder, ServletHolder.class));
        this.addServletWithMapping(holder, pathSpec);
        return holder;
    }

    public void addServletWithMapping(ServletHolder servlet, String pathSpec) {
        Object[] holders = this.getServlets();
        if (holders != null) {
            holders = (ServletHolder[])holders.clone();
        }
        try {
            this.setServlets((ServletHolder[])LazyList.addToArray((Object[])holders, (Object)servlet, ServletHolder.class));
            ServletMapping mapping = new ServletMapping();
            mapping.setServletName(servlet.getName());
            mapping.setPathSpec(pathSpec);
            this.setServletMappings((ServletMapping[])LazyList.addToArray((Object[])this.getServletMappings(), (Object)mapping, ServletMapping.class));
        }
        catch (Exception e) {
            this.setServlets((ServletHolder[])holders);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public void addServlet(ServletHolder holder) {
        this.setServlets((ServletHolder[])LazyList.addToArray((Object[])this.getServlets(), (Object)holder, ServletHolder.class));
    }

    public void addServletMapping(ServletMapping mapping) {
        this.setServletMappings((ServletMapping[])LazyList.addToArray((Object[])this.getServletMappings(), (Object)mapping, ServletMapping.class));
    }

    public FilterHolder newFilterHolder(Class<? extends Filter> filter) {
        return new FilterHolder(filter);
    }

    public FilterHolder newFilterHolder() {
        return new FilterHolder();
    }

    public FilterHolder getFilter(String name) {
        return this._filterNameMap.get(name);
    }

    public FilterHolder addFilterWithMapping(Class<? extends Filter> filter, String pathSpec, EnumSet<DispatcherType> dispatches) {
        FilterHolder holder = this.newFilterHolder();
        holder.setHeldClass(filter);
        this.addFilterWithMapping(holder, pathSpec, dispatches);
        return holder;
    }

    public FilterHolder addFilterWithMapping(String className, String pathSpec, EnumSet<DispatcherType> dispatches) {
        FilterHolder holder = this.newFilterHolder();
        holder.setName(className + "-" + this._filters.length);
        holder.setClassName(className);
        this.addFilterWithMapping(holder, pathSpec, dispatches);
        return holder;
    }

    public void addFilterWithMapping(FilterHolder holder, String pathSpec, EnumSet<DispatcherType> dispatches) {
        FilterHolder[] holders = this.getFilters();
        if (holders != null) {
            holders = (FilterHolder[])holders.clone();
        }
        try {
            this.setFilters((FilterHolder[])LazyList.addToArray((Object[])holders, (Object)((Object)holder), FilterHolder.class));
            FilterMapping mapping = new FilterMapping();
            mapping.setFilterName(holder.getName());
            mapping.setPathSpec(pathSpec);
            mapping.setDispatcherTypes(dispatches);
            this.setFilterMappings((FilterMapping[])LazyList.addToArray((Object[])this.getFilterMappings(), (Object)mapping, FilterMapping.class));
        }
        catch (RuntimeException e) {
            this.setFilters(holders);
            throw e;
        }
        catch (Error e) {
            this.setFilters(holders);
            throw e;
        }
    }

    public FilterHolder addFilterWithMapping(Class<? extends Filter> filter, String pathSpec, int dispatches) {
        FilterHolder holder = this.newFilterHolder(filter);
        this.addFilterWithMapping(holder, pathSpec, dispatches);
        return holder;
    }

    public FilterHolder addFilterWithMapping(String className, String pathSpec, int dispatches) {
        FilterHolder holder = this.newFilterHolder(null);
        holder.setName(className + "-" + this._filters.length);
        holder.setClassName(className);
        this.addFilterWithMapping(holder, pathSpec, dispatches);
        return holder;
    }

    public void addFilterWithMapping(FilterHolder holder, String pathSpec, int dispatches) {
        FilterHolder[] holders = this.getFilters();
        if (holders != null) {
            holders = (FilterHolder[])holders.clone();
        }
        try {
            this.setFilters((FilterHolder[])LazyList.addToArray((Object[])holders, (Object)((Object)holder), FilterHolder.class));
            FilterMapping mapping = new FilterMapping();
            mapping.setFilterName(holder.getName());
            mapping.setPathSpec(pathSpec);
            mapping.setDispatches(dispatches);
            this.setFilterMappings((FilterMapping[])LazyList.addToArray((Object[])this.getFilterMappings(), (Object)mapping, FilterMapping.class));
        }
        catch (RuntimeException e) {
            this.setFilters(holders);
            throw e;
        }
        catch (Error e) {
            this.setFilters(holders);
            throw e;
        }
    }

    public FilterHolder addFilter(String className, String pathSpec, EnumSet<DispatcherType> dispatches) {
        return this.addFilterWithMapping(className, pathSpec, dispatches);
    }

    public void addFilter(FilterHolder filter, FilterMapping filterMapping) {
        if (filter != null) {
            this.setFilters((FilterHolder[])LazyList.addToArray((Object[])this.getFilters(), (Object)((Object)filter), FilterHolder.class));
        }
        if (filterMapping != null) {
            this.setFilterMappings((FilterMapping[])LazyList.addToArray((Object[])this.getFilterMappings(), (Object)filterMapping, FilterMapping.class));
        }
    }

    public void addFilter(FilterHolder filter) {
        if (filter != null) {
            this.setFilters((FilterHolder[])LazyList.addToArray((Object[])this.getFilters(), (Object)((Object)filter), FilterHolder.class));
        }
    }

    public void addFilterMapping(FilterMapping mapping) {
        if (mapping != null) {
            this.setFilterMappings((FilterMapping[])LazyList.addToArray((Object[])this.getFilterMappings(), (Object)mapping, FilterMapping.class));
        }
    }

    public void prependFilterMapping(FilterMapping mapping) {
        if (mapping != null) {
            FilterMapping[] mappings = this.getFilterMappings();
            if (mappings == null || mappings.length == 0) {
                this.setFilterMappings(new FilterMapping[]{mapping});
            } else {
                FilterMapping[] new_mappings = new FilterMapping[mappings.length + 1];
                System.arraycopy(mappings, 0, new_mappings, 1, mappings.length);
                new_mappings[0] = mapping;
                this.setFilterMappings(new_mappings);
            }
        }
    }

    protected synchronized void updateNameMappings() {
        int i;
        this._filterNameMap.clear();
        if (this._filters != null) {
            for (i = 0; i < this._filters.length; ++i) {
                this._filterNameMap.put(this._filters[i].getName(), this._filters[i]);
                this._filters[i].setServletHandler(this);
            }
        }
        this._servletNameMap.clear();
        if (this._servlets != null) {
            for (i = 0; i < this._servlets.length; ++i) {
                this._servletNameMap.put(this._servlets[i].getName(), this._servlets[i]);
                this._servlets[i].setServletHandler(this);
            }
        }
    }

    protected synchronized void updateMappings() {
        int i;
        if (this._filterMappings == null) {
            this._filterPathMappings = null;
            this._filterNameMappings = null;
        } else {
            this._filterPathMappings = new ArrayList<FilterMapping>();
            this._filterNameMappings = new MultiMap();
            for (i = 0; i < this._filterMappings.length; ++i) {
                FilterHolder filter_holder = this._filterNameMap.get(this._filterMappings[i].getFilterName());
                if (filter_holder == null) {
                    throw new IllegalStateException("No filter named " + this._filterMappings[i].getFilterName());
                }
                this._filterMappings[i].setFilterHolder(filter_holder);
                if (this._filterMappings[i].getPathSpecs() != null) {
                    this._filterPathMappings.add(this._filterMappings[i]);
                }
                if (this._filterMappings[i].getServletNames() == null) continue;
                String[] names = this._filterMappings[i].getServletNames();
                for (int j = 0; j < names.length; ++j) {
                    if (names[j] == null) continue;
                    this._filterNameMappings.add((Object)names[j], (Object)this._filterMappings[i]);
                }
            }
        }
        if (this._servletMappings == null || this._servletNameMap == null) {
            this._servletPathMap = null;
        } else {
            PathMap pm = new PathMap();
            for (int i2 = 0; i2 < this._servletMappings.length; ++i2) {
                ServletHolder servlet_holder = this._servletNameMap.get(this._servletMappings[i2].getServletName());
                if (servlet_holder == null) {
                    throw new IllegalStateException("No such servlet: " + this._servletMappings[i2].getServletName());
                }
                if (this._servletMappings[i2].getPathSpecs() == null) continue;
                String[] pathSpecs = this._servletMappings[i2].getPathSpecs();
                for (int j = 0; j < pathSpecs.length; ++j) {
                    if (pathSpecs[j] == null) continue;
                    pm.put((Object)pathSpecs[j], (Object)servlet_holder);
                }
            }
            this._servletPathMap = pm;
        }
        if (this._chainCache != null) {
            i = this._chainCache.length;
            while (i-- > 0) {
                if (this._chainCache[i] == null) continue;
                this._chainCache[i].clear();
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("filterNameMap=" + this._filterNameMap, new Object[0]);
            LOG.debug("pathFilters=" + this._filterPathMappings, new Object[0]);
            LOG.debug("servletFilterMap=" + this._filterNameMappings, new Object[0]);
            LOG.debug("servletPathMap=" + this._servletPathMap, new Object[0]);
            LOG.debug("servletNameMap=" + this._servletNameMap, new Object[0]);
        }
        try {
            if (this.isStarted()) {
                this.initialize();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void notFound(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Not Found " + request.getRequestURI(), new Object[0]);
        }
        response.sendError(404);
    }

    public void setFilterChainsCached(boolean filterChainsCached) {
        this._filterChainsCached = filterChainsCached;
    }

    public void setFilterMappings(FilterMapping[] filterMappings) {
        if (this.getServer() != null) {
            this.getServer().getContainer().update((Object)this, (Object[])this._filterMappings, (Object[])filterMappings, "filterMapping", true);
        }
        this._filterMappings = filterMappings;
        this.updateMappings();
        this.invalidateChainsCache();
    }

    public synchronized void setFilters(FilterHolder[] holders) {
        if (this.getServer() != null) {
            this.getServer().getContainer().update((Object)this, (Object[])this._filters, (Object[])holders, "filter", true);
        }
        this._filters = holders;
        this.updateNameMappings();
        this.invalidateChainsCache();
    }

    public void setServletMappings(ServletMapping[] servletMappings) {
        if (this.getServer() != null) {
            this.getServer().getContainer().update((Object)this, (Object[])this._servletMappings, (Object[])servletMappings, "servletMapping", true);
        }
        this._servletMappings = servletMappings;
        this.updateMappings();
        this.invalidateChainsCache();
    }

    public synchronized void setServlets(ServletHolder[] holders) {
        if (this.getServer() != null) {
            this.getServer().getContainer().update((Object)this, (Object[])this._servlets, (Object[])holders, "servlet", true);
        }
        this._servlets = holders;
        this.updateNameMappings();
        this.invalidateChainsCache();
    }

    public int getMaxFilterChainsCacheSize() {
        return this._maxFilterChainsCacheSize;
    }

    public void setMaxFilterChainsCacheSize(int maxFilterChainsCacheSize) {
        this._maxFilterChainsCacheSize = maxFilterChainsCacheSize;
    }

    void destroyServlet(Servlet servlet) {
        if (this._contextHandler != null) {
            this._contextHandler.destroyServlet(servlet);
        }
    }

    void destroyFilter(Filter filter) {
        if (this._contextHandler != null) {
            this._contextHandler.destroyFilter(filter);
        }
    }

    public void dump(Appendable out, String indent) throws IOException {
        super.dumpThis(out);
        ServletHandler.dump((Appendable)out, (String)indent, (Collection[])new Collection[]{TypeUtil.asList((Object[])this.getHandlers()), this.getBeans(), TypeUtil.asList((Object[])this.getFilterMappings()), TypeUtil.asList((Object[])this.getFilters()), TypeUtil.asList((Object[])this.getServletMappings()), TypeUtil.asList((Object[])this.getServlets())});
    }

    private class Chain
    implements FilterChain {
        final Request _baseRequest;
        final Object _chain;
        final ServletHolder _servletHolder;
        int _filter = 0;

        Chain(Request baseRequest, Object filters, ServletHolder servletHolder) {
            this._baseRequest = baseRequest;
            this._chain = filters;
            this._servletHolder = servletHolder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("doFilter " + this._filter, new Object[0]);
            }
            if (this._filter < LazyList.size((Object)this._chain)) {
                FilterHolder holder = (FilterHolder)((Object)LazyList.get((Object)this._chain, (int)this._filter++));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("call filter " + (Object)((Object)holder), new Object[0]);
                }
                Filter filter = holder.getFilter();
                if (holder.isAsyncSupported() || !this._baseRequest.isAsyncSupported()) {
                    filter.doFilter(request, response, (FilterChain)this);
                } else {
                    try {
                        this._baseRequest.setAsyncSupported(false);
                        filter.doFilter(request, response, (FilterChain)this);
                    }
                    finally {
                        this._baseRequest.setAsyncSupported(true);
                    }
                }
                return;
            }
            if (this._servletHolder != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("call servlet " + this._servletHolder, new Object[0]);
                }
                this._servletHolder.handle(this._baseRequest, request, response);
            } else {
                ServletHandler.this.notFound((HttpServletRequest)request, (HttpServletResponse)response);
            }
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < LazyList.size((Object)this._chain); ++i) {
                Object o = LazyList.get((Object)this._chain, (int)i);
                b.append(o.toString());
                b.append("->");
            }
            b.append(this._servletHolder);
            return b.toString();
        }
    }

    private class CachedChain
    implements FilterChain {
        FilterHolder _filterHolder;
        CachedChain _next;
        ServletHolder _servletHolder;

        CachedChain(Object filters, ServletHolder servletHolder) {
            if (LazyList.size((Object)filters) > 0) {
                this._filterHolder = (FilterHolder)((Object)LazyList.get((Object)filters, (int)0));
                filters = LazyList.remove((Object)filters, (int)0);
                this._next = new CachedChain(filters, servletHolder);
            } else {
                this._servletHolder = servletHolder;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            if (this._filterHolder != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("call filter " + (Object)((Object)this._filterHolder), new Object[0]);
                }
                Filter filter = this._filterHolder.getFilter();
                if (this._filterHolder.isAsyncSupported()) {
                    filter.doFilter(request, response, (FilterChain)this._next);
                } else {
                    Request baseRequest = request instanceof Request ? (Request)request : HttpConnection.getCurrentConnection().getRequest();
                    boolean suspendable = baseRequest.isAsyncSupported();
                    if (suspendable) {
                        try {
                            baseRequest.setAsyncSupported(false);
                            filter.doFilter(request, response, (FilterChain)this._next);
                        }
                        finally {
                            baseRequest.setAsyncSupported(true);
                        }
                    } else {
                        filter.doFilter(request, response, (FilterChain)this._next);
                    }
                }
                return;
            }
            if (this._servletHolder != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("call servlet " + this._servletHolder, new Object[0]);
                }
                Request baseRequest = request instanceof Request ? (Request)request : HttpConnection.getCurrentConnection().getRequest();
                this._servletHolder.handle(baseRequest, request, response);
            } else {
                ServletHandler.this.notFound((HttpServletRequest)request, (HttpServletResponse)response);
            }
        }

        public String toString() {
            if (this._filterHolder != null) {
                return (Object)((Object)this._filterHolder) + "->" + this._next.toString();
            }
            if (this._servletHolder != null) {
                return this._servletHolder.toString();
            }
            return "null";
        }
    }
}

