/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet.listener;

import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.eclipse.jetty.util.Loader;
import org.eclipse.jetty.util.log.Log;

public class ELContextCleaner
implements ServletContextListener {
    public void contextInitialized(ServletContextEvent sce) {
    }

    public void contextDestroyed(ServletContextEvent sce) {
        try {
            Class beanELResolver = Loader.loadClass(this.getClass(), (String)"javax.el.BeanELResolver");
            Field field = this.getField(beanELResolver);
            this.purgeEntries(field);
            Log.info((String)"javax.el.BeanELResolver purged");
        }
        catch (ClassNotFoundException e) {
        }
        catch (SecurityException e) {
            Log.warn((String)"Cannot purge classes from javax.el.BeanELResolver", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            Log.warn((String)"Cannot purge classes from javax.el.BeanELResolver", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            Log.warn((String)"Cannot purge classes from javax.el.BeanELResolver", (Throwable)e);
        }
        catch (NoSuchFieldException e) {
            Log.warn((String)"Cannot purge classes from javax.el.BeanELResolver", (Throwable)e);
        }
    }

    protected Field getField(Class beanELResolver) throws SecurityException, NoSuchFieldException {
        if (beanELResolver == null) {
            return null;
        }
        return beanELResolver.getDeclaredField("properties");
    }

    protected void purgeEntries(Field properties) throws IllegalArgumentException, IllegalAccessException {
        ConcurrentHashMap map;
        if (properties == null) {
            return;
        }
        if (!properties.isAccessible()) {
            properties.setAccessible(true);
        }
        if ((map = (ConcurrentHashMap)properties.get(null)) == null) {
            return;
        }
        Iterator itor = map.keySet().iterator();
        while (itor.hasNext()) {
            Class clazz = (Class)itor.next();
            Log.info((String)("Clazz: " + clazz + " loaded by " + clazz.getClassLoader()));
            if (Thread.currentThread().getContextClassLoader().equals(clazz.getClassLoader())) {
                itor.remove();
                Log.info((String)"removed");
                continue;
            }
            Log.info((String)("not removed: contextclassloader=" + Thread.currentThread().getContextClassLoader() + "clazz's classloader=" + clazz.getClassLoader()));
        }
    }
}

