/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Ignore
public class BadRequestLogHandlerTest {
    private static final Logger LOG = Log.getLogger(BadRequestLogHandlerTest.class);
    @Parameterized.Parameter(value=0)
    public String requestHeader;
    @Parameterized.Parameter(value=1)
    public String expectedLog;

    @Parameterized.Parameters
    public static List<Object[]> data() {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        data.add(new String[]{"GET /bad VER\r\nHost: localhost\r\nConnection: close\r\n\r\n", "GET <invalidrequest> HTTP/1.1 400"});
        data.add(new String[]{"GET /%%adsasd HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\n\r\n", "GET <invalidrequest> HTTP/1.1 400"});
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=4000L)
    public void testLogHandler() throws Exception {
        Server server = new Server();
        ServerConnector connector = new ServerConnector(server);
        connector.setPort(0);
        server.setConnectors(new Connector[]{connector});
        CaptureLog captureLog = new CaptureLog();
        RequestLogHandler requestLog = new RequestLogHandler();
        requestLog.setRequestLog((RequestLog)captureLog);
        requestLog.setHandler((Handler)new HelloHandler());
        server.setHandler((Handler)requestLog);
        try {
            server.start();
            String host = connector.getHost();
            if (host == null) {
                host = "localhost";
            }
            InetAddress destAddr = InetAddress.getByName(host);
            int port = connector.getLocalPort();
            InetSocketAddress endpoint = new InetSocketAddress(destAddr, port);
            Socket socket = new Socket();
            socket.setSoTimeout(1000);
            socket.connect(endpoint);
            try (OutputStream out = socket.getOutputStream();
                 OutputStreamWriter writer = new OutputStreamWriter(out, StandardCharsets.UTF_8);
                 InputStream in = socket.getInputStream();
                 InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);){
                StringReader request = new StringReader(this.requestHeader);
                IO.copy((Reader)request, (Writer)writer);
                writer.flush();
                StringWriter response = new StringWriter();
                IO.copy((Reader)reader, (Writer)response);
                LOG.info("Response: {}", new Object[]{response});
            }
            finally {
                socket.close();
            }
            this.assertRequestLog(captureLog);
        }
        finally {
            server.stop();
        }
    }

    private void assertRequestLog(CaptureLog captureLog) {
        int captureCount = captureLog.captured.size();
        if (captureCount != 1) {
            LOG.warn("Capture Log size is {}, expected to be 1", new Object[]{captureCount});
            if (captureCount > 1) {
                for (int i = 0; i < captureCount; ++i) {
                    LOG.warn("[{}] {}", new Object[]{i, captureLog.captured.get(i)});
                }
            }
            Assert.assertThat((String)"Capture Log Entry Count", (Object)captureLog.captured.size(), (Matcher)Matchers.is((Object)1));
        }
        String actual = captureLog.captured.get(0);
        Assert.assertThat((String)"Capture Log", (Object)actual, (Matcher)Matchers.is((Object)this.expectedLog));
    }

    private static class HelloHandler
    extends AbstractHandler {
        private HelloHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            response.setContentType("text/plain");
            response.getWriter().print("Hello World");
            baseRequest.setHandled(true);
        }
    }

    public static class CaptureLog
    extends AbstractLifeCycle
    implements RequestLog {
        public List<String> captured = new ArrayList<String>();

        public void log(Request request, Response response) {
            this.captured.add(String.format("%s %s %s %03d", request.getMethod(), request.getUri().toString(), request.getProtocol(), response.getStatus()));
        }
    }
}

