/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import org.eclipse.jetty.server.ConnectorTimeoutTest;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SuspendHandler;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.util.IO;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ServerConnectorTimeoutTest
extends ConnectorTimeoutTest {
    @Before
    public void init() throws Exception {
        ServerConnector connector = new ServerConnector(this._server, 1, 1);
        connector.setIdleTimeout(500L);
        this.startServer(connector);
    }

    @Test(timeout=60000L)
    public void testIdleTimeoutAfterSuspend() throws Exception {
        SuspendHandler _handler = new SuspendHandler();
        this._server.stop();
        SessionHandler session = new SessionHandler();
        session.setHandler((Handler)_handler);
        this._server.setHandler((Handler)session);
        this._server.start();
        _handler.setSuspendFor(100L);
        _handler.setResumeAfter(25L);
        Assert.assertTrue((boolean)this.process(null).toUpperCase(Locale.ENGLISH).contains("RESUMED"));
    }

    @Test(timeout=60000L)
    public void testIdleTimeoutAfterTimeout() throws Exception {
        SuspendHandler _handler = new SuspendHandler();
        this._server.stop();
        SessionHandler session = new SessionHandler();
        session.setHandler((Handler)_handler);
        this._server.setHandler((Handler)session);
        this._server.start();
        _handler.setSuspendFor(50L);
        Assert.assertTrue((boolean)this.process(null).toUpperCase(Locale.ENGLISH).contains("TIMEOUT"));
    }

    @Test(timeout=60000L)
    public void testIdleTimeoutAfterComplete() throws Exception {
        SuspendHandler _handler = new SuspendHandler();
        this._server.stop();
        SessionHandler session = new SessionHandler();
        session.setHandler((Handler)_handler);
        this._server.setHandler((Handler)session);
        this._server.start();
        _handler.setSuspendFor(100L);
        _handler.setCompleteAfter(25L);
        Assert.assertTrue((boolean)this.process(null).toUpperCase(Locale.ENGLISH).contains("COMPLETED"));
    }

    private synchronized String process(String content) throws UnsupportedEncodingException, IOException, InterruptedException {
        String request = "GET / HTTP/1.1\r\nHost: localhost\r\n";
        request = content == null ? request + "\r\n" : request + "Content-Length: " + content.length() + "\r\n" + "\r\n" + content;
        return this.getResponse(request);
    }

    private String getResponse(String request) throws UnsupportedEncodingException, IOException, InterruptedException {
        ServerConnector connector = this._connector;
        Socket socket = new Socket((String)null, connector.getLocalPort());
        socket.setSoTimeout(5000);
        socket.getOutputStream().write(request.getBytes(StandardCharsets.UTF_8));
        InputStream inputStream = socket.getInputStream();
        long start = System.currentTimeMillis();
        String response = IO.toString((InputStream)inputStream);
        long timeElapsed = System.currentTimeMillis() - start;
        Assert.assertTrue((String)"Time elapsed should be at least MAX_IDLE_TIME", (timeElapsed > 500L ? 1 : 0) != 0);
        return response;
    }
}

