/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.DumpHandler;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PartialRFC2616Test {
    private Server server;
    private LocalConnector connector;

    @Before
    public void init() throws Exception {
        this.server = new Server();
        this.connector = new LocalConnector(this.server);
        this.connector.setIdleTimeout(10000L);
        this.server.addConnector((Connector)this.connector);
        ContextHandler vcontext = new ContextHandler();
        vcontext.setContextPath("/");
        vcontext.setVirtualHosts(new String[]{"VirtualHost"});
        vcontext.setHandler((Handler)new DumpHandler("Virtual Dump"));
        ContextHandler context = new ContextHandler();
        context.setContextPath("/");
        context.setHandler((Handler)new DumpHandler());
        HandlerCollection collection = new HandlerCollection();
        collection.setHandlers(new Handler[]{vcontext, context});
        this.server.setHandler((Handler)collection);
        this.server.start();
    }

    @After
    public void destroy() throws Exception {
        this.server.stop();
        this.server.join();
    }

    @Test
    public void test3_3() {
        try {
            HttpFields fields = new HttpFields();
            fields.put("D1", "Sun, 6 Nov 1994 08:49:37 GMT");
            fields.put("D2", "Sunday, 6-Nov-94 08:49:37 GMT");
            fields.put("D3", "Sun Nov  6 08:49:37 1994");
            Date d1 = new Date(fields.getDateField("D1"));
            Date d2 = new Date(fields.getDateField("D2"));
            Date d3 = new Date(fields.getDateField("D3"));
            Assert.assertEquals((String)"3.3.1 RFC 822 RFC 850", (Object)d2, (Object)d1);
            Assert.assertEquals((String)"3.3.1 RFC 850 ANSI C", (Object)d3, (Object)d2);
            fields.putDateField("Date", d1.getTime());
            Assert.assertEquals((String)"3.3.1 RFC 822 preferred", (Object)"Sun, 06 Nov 1994 08:49:37 GMT", (Object)fields.getStringField("Date"));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void test3_6_a() throws Exception {
        int offset = 0;
        String response = this.connector.getResponses("GET /R1 HTTP/1.1\nHost: localhost\nTransfer-Encoding: chunked,identity\nContent-Type: text/plain\n\r\n5;\r\n123\r\n\r\n0;\r\n\r\n");
        this.checkContains(response, offset, "HTTP/1.1 400 Bad", "Chunked last");
    }

    @Test
    public void test3_6_b() throws Exception {
        int offset = 0;
        String response = this.connector.getResponses("GET /R1 HTTP/1.1\nHost: localhost\nTransfer-Encoding: chunked\nContent-Type: text/plain\n\n2;\n12\n3;\n345\n0;\n\nGET /R2 HTTP/1.1\nHost: localhost\nTransfer-Encoding: chunked\nContent-Type: text/plain\n\n4;\n6789\n5;\nabcde\n0;\n\nGET /R3 HTTP/1.1\nHost: localhost\nConnection: close\n\n");
        offset = this.checkContains(response, offset, "HTTP/1.1 200", "3.6.1 Chunking");
        offset = this.checkContains(response, offset, "12345", "3.6.1 Chunking");
        offset = this.checkContains(response, offset, "HTTP/1.1 200", "3.6.1 Chunking");
        offset = this.checkContains(response, offset, "6789abcde", "3.6.1 Chunking");
        offset = this.checkContains(response, offset, "/R3", "3.6.1 Chunking");
    }

    @Test
    public void test3_6_c() throws Exception {
        int offset = 0;
        String response = this.connector.getResponses("POST /R1 HTTP/1.1\nHost: localhost\nTransfer-Encoding: chunked\nContent-Type: text/plain\n\n3;\nfgh\n3;\nIjk\n0;\n\nPOST /R2 HTTP/1.1\nHost: localhost\nTransfer-Encoding: chunked\nContent-Type: text/plain\n\n4;\nlmno\n5;\nPqrst\n0;\n\nGET /R3 HTTP/1.1\nHost: localhost\nConnection: close\n\n");
        this.checkNotContained(response, "HTTP/1.1 100", "3.6.1 Chunking");
        offset = this.checkContains(response, offset, "HTTP/1.1 200", "3.6.1 Chunking");
        offset = this.checkContains(response, offset, "fghIjk", "3.6.1 Chunking");
        offset = this.checkContains(response, offset, "HTTP/1.1 200", "3.6.1 Chunking");
        offset = this.checkContains(response, offset, "lmnoPqrst", "3.6.1 Chunking");
        offset = this.checkContains(response, offset, "/R3", "3.6.1 Chunking");
    }

    @Test
    public void test3_6_d() throws Exception {
        int offset = 0;
        String response = this.connector.getResponses("GET /R1 HTTP/1.1\nHost: localhost\nTransfer-Encoding: chunked\nContent-Type: text/plain\nConnection: keep-alive\n\n3;\n123\n3;\n456\n0;\n\nGET /R2 HTTP/1.1\nHost: localhost\nConnection: close\n\n");
        offset = this.checkContains(response, offset, "HTTP/1.1 200", "3.6.1 Chunking") + 10;
        offset = this.checkContains(response, offset, "123456", "3.6.1 Chunking");
        offset = this.checkContains(response, offset, "/R2", "3.6.1 Chunking") + 10;
    }

    @Test
    public void test3_9() throws Exception {
        HttpFields fields = new HttpFields();
        fields.put("Q", "bbb;q=0.5,aaa,ccc;q=0.002,d;q=0,e;q=0.0001,ddd;q=0.001,aa2,abb;q=0.7");
        Enumeration qualities = fields.getValues("Q", ", \t");
        List list = HttpFields.qualityList((Enumeration)qualities);
        Assert.assertEquals((String)"Quality parameters", (Object)"aaa", (Object)HttpFields.valueParameters((String)((String)list.get(0)), null));
        Assert.assertEquals((String)"Quality parameters", (Object)"aa2", (Object)HttpFields.valueParameters((String)((String)list.get(1)), null));
        Assert.assertEquals((String)"Quality parameters", (Object)"abb", (Object)HttpFields.valueParameters((String)((String)list.get(2)), null));
        Assert.assertEquals((String)"Quality parameters", (Object)"bbb", (Object)HttpFields.valueParameters((String)((String)list.get(3)), null));
        Assert.assertEquals((String)"Quality parameters", (Object)"ccc", (Object)HttpFields.valueParameters((String)((String)list.get(4)), null));
        Assert.assertEquals((String)"Quality parameters", (Object)"ddd", (Object)HttpFields.valueParameters((String)((String)list.get(5)), null));
    }

    @Test
    public void test4_4_2() throws Exception {
        int offset = 0;
        String response = this.connector.getResponses("GET /R1 HTTP/1.1\nHost: localhost\nTransfer-Encoding: identity\nContent-Type: text/plain\nContent-Length: 5\n\n123\r\nGET /R2 HTTP/1.1\nHost: localhost\nTransfer-Encoding: other\nConnection: close\n\n");
        offset = this.checkContains(response, offset, "HTTP/1.1 200 OK", "2. identity") + 10;
        offset = this.checkContains(response, offset, "/R1", "2. identity") + 3;
        offset = this.checkContains(response, offset, "HTTP/1.1 200 OK", "2. identity") + 10;
        offset = this.checkContains(response, offset, "/R2", "2. identity") + 3;
    }

    @Test
    public void test4_4_3() throws Exception {
        int offset = 0;
        String response = this.connector.getResponses("GET /R1 HTTP/1.1\nHost: localhost\nTransfer-Encoding: chunked\nContent-Type: text/plain\nContent-Length: 100\n\n3;\n123\n3;\n456\n0;\n\nGET /R2 HTTP/1.1\nHost: localhost\nConnection: close\nContent-Type: text/plain\nContent-Length: 6\n\nabcdef");
        offset = this.checkContains(response, offset, "HTTP/1.1 200 OK", "3. ignore c-l") + 1;
        offset = this.checkContains(response, offset, "/R1", "3. ignore c-l") + 1;
        offset = this.checkContains(response, offset, "123456", "3. ignore c-l") + 1;
        offset = this.checkContains(response, offset, "HTTP/1.1 200 OK", "3. ignore c-l") + 1;
        offset = this.checkContains(response, offset, "/R2", "3. _content-length") + 1;
        offset = this.checkContains(response, offset, "abcdef", "3. _content-length") + 1;
    }

    @Test
    public void test4_4_4() throws Exception {
        Assert.assertTrue((String)"Skip 411 checks as IE breaks this rule", (boolean)true);
    }

    @Test
    public void test5_2_1() throws Exception {
        int offset = 0;
        String response = this.connector.getResponses("GET http://VirtualHost:8888/path/R1 HTTP/1.1\nHost: wronghost\nConnection: close\n\n");
        offset = this.checkContains(response, offset, "HTTP/1.1 200", "Virtual host") + 1;
        offset = this.checkContains(response, offset, "Virtual Dump", "Virtual host") + 1;
        offset = this.checkContains(response, offset, "pathInfo=/path/R1", "Virtual host") + 1;
        offset = this.checkContains(response, offset, "servername=VirtualHost", "Virtual host") + 1;
    }

    @Test
    public void test5_2_2() throws Exception {
        int offset = 0;
        String response = this.connector.getResponses("GET /path/R1 HTTP/1.1\nHost: localhost\nConnection: close\n\n");
        offset = this.checkContains(response, offset, "HTTP/1.1 200", "Default host") + 1;
        offset = this.checkContains(response, offset, "Dump HttpHandler", "Default host") + 1;
        offset = this.checkContains(response, offset, "pathInfo=/path/R1", "Default host") + 1;
        offset = 0;
        response = this.connector.getResponses("GET /path/R2 HTTP/1.1\nHost: VirtualHost\nConnection: close\n\n");
        offset = this.checkContains(response, offset, "HTTP/1.1 200", "Default host") + 1;
        offset = this.checkContains(response, offset, "Virtual Dump", "virtual host") + 1;
        offset = this.checkContains(response, offset, "pathInfo=/path/R2", "Default host") + 1;
    }

    @Test
    public void test5_2() throws Exception {
        int offset = 0;
        String response = this.connector.getResponses("GET /path/R1 HTTP/1.1\nHost: VirtualHost\nConnection: close\n\n");
        offset = this.checkContains(response, offset, "HTTP/1.1 200", "2. virtual host field") + 1;
        offset = this.checkContains(response, offset, "Virtual Dump", "2. virtual host field") + 1;
        offset = this.checkContains(response, offset, "pathInfo=/path/R1", "2. virtual host field") + 1;
        offset = 0;
        response = this.connector.getResponses("GET /path/R1 HTTP/1.1\nHost: ViRtUalhOst\nConnection: close\n\n");
        offset = this.checkContains(response, offset, "HTTP/1.1 200", "2. virtual host field") + 1;
        offset = this.checkContains(response, offset, "Virtual Dump", "2. virtual host field") + 1;
        offset = this.checkContains(response, offset, "pathInfo=/path/R1", "2. virtual host field") + 1;
        offset = 0;
        response = this.connector.getResponses("GET /path/R1 HTTP/1.1\n\n");
        offset = this.checkContains(response, offset, "HTTP/1.1 400", "3. no host") + 1;
    }

    @Test
    public void test8_1() throws Exception {
        int offset = 0;
        String response = this.connector.getResponses("GET /R1 HTTP/1.1\nHost: localhost\n\n", 250L, TimeUnit.MILLISECONDS);
        offset = this.checkContains(response, offset, "HTTP/1.1 200 OK\r\n", "8.1.2 default") + 10;
        this.checkContains(response, offset, "Content-Length: ", "8.1.2 default");
        offset = 0;
        response = this.connector.getResponses("GET /R1 HTTP/1.1\nHost: localhost\n\nGET /R2 HTTP/1.1\nHost: localhost\nConnection: close\n\nGET /R3 HTTP/1.1\nHost: localhost\nConnection: close\n\n");
        offset = this.checkContains(response, offset, "HTTP/1.1 200 OK\r\n", "8.1.2 default") + 1;
        offset = this.checkContains(response, offset, "/R1", "8.1.2 default") + 1;
        offset = this.checkContains(response, offset, "HTTP/1.1 200 OK\r\n", "8.1.2.2 pipeline") + 11;
        offset = this.checkContains(response, offset, "Connection: close", "8.1.2.2 pipeline") + 1;
        offset = this.checkContains(response, offset, "/R2", "8.1.2.1 close") + 3;
        Assert.assertEquals((String)"8.1.2.1 close", (long)-1L, (long)response.indexOf("/R3"));
    }

    @Test
    public void test10_4_18() throws Exception {
        int offset = 0;
        String response = this.connector.getResponses("GET /R1 HTTP/1.1\nHost: localhost\nExpect: unknown\nContent-Type: text/plain\nContent-Length: 8\n\n");
        offset = this.checkContains(response, offset, "HTTP/1.1 417", "8.2.3 expect failure") + 1;
    }

    @Test
    public void test8_2_3_dash5() throws Exception {
        int offset = 0;
        String response = this.connector.getResponses("GET /R1 HTTP/1.1\nHost: localhost\nExpect: 100-continue\nContent-Type: text/plain\nContent-Length: 8\nConnection: close\n\n123456\r\n");
        this.checkNotContained(response, offset, "HTTP/1.1 100 ", "8.2.3 expect 100");
        offset = this.checkContains(response, offset, "HTTP/1.1 200 OK", "8.2.3 expect with body") + 1;
    }

    @Test
    public void test8_2_3() throws Exception {
        int offset = 0;
        LocalConnector.LocalEndPoint endp = this.connector.executeRequest("GET /R1 HTTP/1.1\nHost: localhost\nConnection: close\nExpect: 100-continue\nContent-Type: text/plain\nContent-Length: 8\n\n");
        Thread.sleep(200L);
        String infomational = endp.takeOutputString();
        offset = this.checkContains(infomational, offset, "HTTP/1.1 100 ", "8.2.3 expect 100") + 1;
        this.checkNotContained(infomational, offset, "HTTP/1.1 200", "8.2.3 expect 100");
        endp.addInput("654321\r\n");
        Thread.sleep(200L);
        String response = endp.takeOutputString();
        offset = 0;
        offset = this.checkContains(response, offset, "HTTP/1.1 200", "8.2.3 expect 100") + 1;
        offset = this.checkContains(response, offset, "654321", "8.2.3 expect 100") + 1;
    }

    @Test
    public void test8_2_4() throws Exception {
        int offset = 0;
        String response = this.connector.getResponses("GET /R1?error=401 HTTP/1.1\nHost: localhost\nExpect: 100-continue\nContent-Type: text/plain\nContent-Length: 8\n\n");
        this.checkNotContained(response, offset, "HTTP/1.1 100", "8.2.3 expect 100");
        offset = this.checkContains(response, offset, "HTTP/1.1 401 ", "8.2.3 expect 100") + 1;
        offset = this.checkContains(response, offset, "Connection: close", "8.2.3 expect 100") + 1;
    }

    @Test
    public void test9_2() throws Exception {
        int offset = 0;
        String response = this.connector.getResponses("OPTIONS * HTTP/1.1\nConnection: close\nHost: localhost\n\n");
        offset = this.checkContains(response, offset, "HTTP/1.1 200", "200") + 1;
        offset = 0;
        response = this.connector.getResponses("GET * HTTP/1.1\nConnection: close\nHost: localhost\n\n");
        offset = this.checkContains(response, offset, "HTTP/1.1 400", "400") + 1;
    }

    @Test
    public void test9_4() {
        try {
            String get = this.connector.getResponses("GET /R1 HTTP/1.0\nHost: localhost\n\n");
            this.checkContains(get, 0, "HTTP/1.1 200", "GET");
            this.checkContains(get, 0, "Content-Type: text/html", "GET _content");
            this.checkContains(get, 0, "<html>", "GET body");
            String head = this.connector.getResponses("HEAD /R1 HTTP/1.0\nHost: localhost\n\n");
            this.checkContains(head, 0, "HTTP/1.1 200", "HEAD");
            this.checkContains(head, 0, "Content-Type: text/html", "HEAD _content");
            Assert.assertEquals((String)"HEAD no body", (long)-1L, (long)head.indexOf("<html>"));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.assertTrue((boolean)false);
        }
    }

    @Test
    public void test14_23() throws Exception {
        int offset = 0;
        String response = this.connector.getResponses("GET /R1 HTTP/1.0\nConnection: close\n\n");
        offset = this.checkContains(response, offset, "HTTP/1.1 200", "200") + 1;
        offset = 0;
        response = this.connector.getResponses("GET /R1 HTTP/1.1\nConnection: close\n\n");
        offset = this.checkContains(response, offset, "HTTP/1.1 400", "400") + 1;
        offset = 0;
        response = this.connector.getResponses("GET /R1 HTTP/1.1\nHost: localhost\nConnection: close\n\n");
        offset = this.checkContains(response, offset, "HTTP/1.1 200", "200") + 1;
        offset = 0;
        response = this.connector.getResponses("GET /R1 HTTP/1.1\nHost:\nConnection: close\n\n");
        offset = this.checkContains(response, offset, "HTTP/1.1 200", "200") + 1;
    }

    @Test
    public void test19_6() {
        try {
            int offset = 0;
            String response = this.connector.getResponses("GET /R1 HTTP/1.0\n\n");
            offset = this.checkContains(response, offset, "HTTP/1.1 200 OK\r\n", "19.6.2 default close") + 10;
            this.checkNotContained(response, offset, "Connection: close", "19.6.2 not assumed");
            offset = 0;
            response = this.connector.getResponses("GET /R1 HTTP/1.0\nHost: localhost\nConnection: keep-alive\n\nGET /R2 HTTP/1.0\nHost: localhost\nConnection: close\n\nGET /R3 HTTP/1.0\nHost: localhost\nConnection: close\n\n");
            offset = this.checkContains(response, offset, "HTTP/1.1 200 OK\r\n", "19.6.2 Keep-alive 1") + 1;
            offset = this.checkContains(response, offset, "Connection: keep-alive", "19.6.2 Keep-alive 1") + 1;
            offset = this.checkContains(response, offset, "<html>", "19.6.2 Keep-alive 1") + 1;
            offset = this.checkContains(response, offset, "/R1", "19.6.2 Keep-alive 1") + 1;
            offset = this.checkContains(response, offset, "HTTP/1.1 200 OK\r\n", "19.6.2 Keep-alive 2") + 11;
            offset = this.checkContains(response, offset, "/R2", "19.6.2 Keep-alive close") + 3;
            Assert.assertEquals((String)"19.6.2 closed", (long)-1L, (long)response.indexOf("/R3"));
            offset = 0;
            response = this.connector.getResponses("GET /R1 HTTP/1.0\nHost: localhost\nConnection: keep-alive\nContent-Length: 10\n\n1234567890\nGET /RA HTTP/1.0\nHost: localhost\nConnection: keep-alive\nContent-Length: 10\n\nABCDEFGHIJ\nGET /R2 HTTP/1.0\nHost: localhost\nConnection: close\n\nGET /R3 HTTP/1.0\nHost: localhost\nConnection: close\n\n");
            offset = this.checkContains(response, offset, "HTTP/1.1 200 OK\r\n", "19.6.2 Keep-alive 1") + 1;
            offset = this.checkContains(response, offset, "Connection: keep-alive", "19.6.2 Keep-alive 1") + 1;
            offset = this.checkContains(response, offset, "<html>", "19.6.2 Keep-alive 1") + 1;
            offset = this.checkContains(response, offset, "1234567890", "19.6.2 Keep-alive 1") + 1;
            offset = this.checkContains(response, offset, "HTTP/1.1 200 OK\r\n", "19.6.2 Keep-alive 1") + 1;
            offset = this.checkContains(response, offset, "Connection: keep-alive", "19.6.2 Keep-alive 1") + 1;
            offset = this.checkContains(response, offset, "<html>", "19.6.2 Keep-alive 1") + 1;
            offset = this.checkContains(response, offset, "ABCDEFGHIJ", "19.6.2 Keep-alive 1") + 1;
            offset = this.checkContains(response, offset, "HTTP/1.1 200 OK\r\n", "19.6.2 Keep-alive 2") + 11;
            offset = this.checkContains(response, offset, "/R2", "19.6.2 Keep-alive close") + 3;
            Assert.assertEquals((String)"19.6.2 closed", (long)-1L, (long)response.indexOf("/R3"));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.assertTrue((boolean)false);
        }
    }

    private int checkContains(String s, int offset, String c, String test) {
        Assert.assertThat((String)test, (Object)s.substring(offset), (Matcher)Matchers.containsString((String)c));
        return s.indexOf(c, offset);
    }

    private void checkNotContained(String s, int offset, String c, String test) {
        Assert.assertThat((String)test, (Object)s.substring(offset), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)c)));
    }

    private void checkNotContained(String s, String c, String test) {
        this.checkNotContained(s, 0, c, test);
    }
}

