/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.util.List;
import java.util.Vector;
import org.eclipse.jetty.server.InclusiveByteRange;
import org.junit.Assert;
import org.junit.Test;

public class InclusiveByteRangeTest {
    private void assertInvalidRange(String rangeString) {
        Vector<String> strings = new Vector<String>();
        strings.add(rangeString);
        List ranges = InclusiveByteRange.satisfiableRanges(strings.elements(), (long)200L);
        Assert.assertNull((String)("Invalid Range [" + rangeString + "] should result in no satisfiable ranges"), (Object)ranges);
    }

    private void assertRange(String msg, int expectedFirst, int expectedLast, int size, InclusiveByteRange actualRange) {
        Assert.assertEquals((String)(msg + " - first"), (long)expectedFirst, (long)actualRange.getFirst((long)size));
        Assert.assertEquals((String)(msg + " - last"), (long)expectedLast, (long)actualRange.getLast((long)size));
        String expectedHeader = String.format("bytes %d-%d/%d", expectedFirst, expectedLast, size);
        Assert.assertEquals((String)(msg + " - header range string"), (Object)expectedHeader, (Object)actualRange.toHeaderRangeString((long)size));
    }

    private void assertSimpleRange(int expectedFirst, int expectedLast, String rangeId, int size) {
        InclusiveByteRange range = this.parseRange(rangeId, size);
        Assert.assertEquals((String)("Range [" + rangeId + "] - first"), (long)expectedFirst, (long)range.getFirst((long)size));
        Assert.assertEquals((String)("Range [" + rangeId + "] - last"), (long)expectedLast, (long)range.getLast((long)size));
        String expectedHeader = String.format("bytes %d-%d/%d", expectedFirst, expectedLast, size);
        Assert.assertEquals((String)("Range [" + rangeId + "] - header range string"), (Object)expectedHeader, (Object)range.toHeaderRangeString((long)size));
    }

    private InclusiveByteRange parseRange(String rangeString, int size) {
        Vector<String> strings = new Vector<String>();
        strings.add(rangeString);
        List ranges = InclusiveByteRange.satisfiableRanges(strings.elements(), (long)size);
        Assert.assertNotNull((String)"Satisfiable Ranges should not be null", (Object)ranges);
        Assert.assertEquals((String)("Satisfiable Ranges of [" + rangeString + "] count"), (long)1L, (long)ranges.size());
        return (InclusiveByteRange)ranges.get(0);
    }

    private List<InclusiveByteRange> parseRanges(String rangeString, int size) {
        Vector<String> strings = new Vector<String>();
        strings.add(rangeString);
        List ranges = InclusiveByteRange.satisfiableRanges(strings.elements(), (long)size);
        Assert.assertNotNull((String)"Satisfiable Ranges should not be null", (Object)ranges);
        return ranges;
    }

    @Test
    public void testHeader416RangeString() {
        Assert.assertEquals((String)"416 Header on size 100", (Object)"bytes */100", (Object)InclusiveByteRange.to416HeaderRangeString((long)100L));
        Assert.assertEquals((String)"416 Header on size 123456789", (Object)"bytes */123456789", (Object)InclusiveByteRange.to416HeaderRangeString((long)123456789L));
    }

    @Test
    public void testInvalidRanges() {
        this.assertInvalidRange("bytes=a-b");
        this.assertInvalidRange("byte=10-3");
        this.assertInvalidRange("onceuponatime=5-10");
        this.assertInvalidRange("bytes=300-310");
    }

    @Test
    public void testMultipleAbsoluteRanges() {
        int size = 50;
        String rangeString = "bytes=5-20,35-65";
        List<InclusiveByteRange> ranges = this.parseRanges(rangeString, size);
        Assert.assertEquals((String)("Satisfiable Ranges of [" + rangeString + "] count"), (long)2L, (long)ranges.size());
        this.assertRange("Range [" + rangeString + "]", 5, 20, size, ranges.get(0));
        this.assertRange("Range [" + rangeString + "]", 35, 49, size, ranges.get(1));
    }

    @Test
    public void testMultipleRangesClipped() {
        String rangeString = "bytes=5-20,35-65,-5";
        List<InclusiveByteRange> ranges = this.parseRanges(rangeString, 50);
        Assert.assertEquals((String)("Satisfiable Ranges of [" + rangeString + "] count"), (long)3L, (long)ranges.size());
        this.assertRange("Range [" + rangeString + "]", 5, 20, 50, ranges.get(0));
        this.assertRange("Range [" + rangeString + "]", 35, 49, 50, ranges.get(1));
        this.assertRange("Range [" + rangeString + "]", 45, 49, 50, ranges.get(2));
    }

    @Test
    public void testMultipleRangesOverlapping() {
        String rangeString = "bytes=5-20,15-25";
        List<InclusiveByteRange> ranges = this.parseRanges(rangeString, 200);
        Assert.assertEquals((String)("Satisfiable Ranges of [" + rangeString + "] count"), (long)2L, (long)ranges.size());
        this.assertRange("Range [" + rangeString + "]", 5, 20, 200, ranges.get(0));
        this.assertRange("Range [" + rangeString + "]", 15, 25, 200, ranges.get(1));
    }

    @Test
    public void testMultipleRangesSplit() {
        String rangeString = "bytes=5-10,15-20";
        List<InclusiveByteRange> ranges = this.parseRanges(rangeString, 200);
        Assert.assertEquals((String)("Satisfiable Ranges of [" + rangeString + "] count"), (long)2L, (long)ranges.size());
        this.assertRange("Range [" + rangeString + "]", 5, 10, 200, ranges.get(0));
        this.assertRange("Range [" + rangeString + "]", 15, 20, 200, ranges.get(1));
    }

    @Test
    public void testSimpleRange() {
        this.assertSimpleRange(5, 10, "bytes=5-10", 200);
        this.assertSimpleRange(195, 199, "bytes=-5", 200);
        this.assertSimpleRange(50, 119, "bytes=50-150", 120);
        this.assertSimpleRange(50, 119, "bytes=50-", 120);
    }
}

