/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.TypeUtil;
import org.junit.Assert;
import org.junit.Test;

public class HttpURITest {
    private final String[][] partial_tests = new String[][]{{"/path/info", null, null, null, null, "/path/info", null, null, null}, {"/path/info#fragment", null, null, null, null, "/path/info", null, null, "fragment"}, {"/path/info?query", null, null, null, null, "/path/info", null, "query", null}, {"/path/info?query#fragment", null, null, null, null, "/path/info", null, "query", "fragment"}, {"/path/info;param", null, null, null, null, "/path/info", "param", null, null}, {"/path/info;param#fragment", null, null, null, null, "/path/info", "param", null, "fragment"}, {"/path/info;param?query", null, null, null, null, "/path/info", "param", "query", null}, {"/path/info;param?query#fragment", null, null, null, null, "/path/info", "param", "query", "fragment"}, {"//host/path/info", null, "//host", "host", null, "/path/info", null, null, null}, {"//user@host/path/info", null, "//user@host", "host", null, "/path/info", null, null, null}, {"//user@host:8080/path/info", null, "//user@host:8080", "host", "8080", "/path/info", null, null, null}, {"//host:8080/path/info", null, "//host:8080", "host", "8080", "/path/info", null, null, null}, {"http:/path/info", "http", null, null, null, "/path/info", null, null, null}, {"http:/path/info#fragment", "http", null, null, null, "/path/info", null, null, "fragment"}, {"http:/path/info?query", "http", null, null, null, "/path/info", null, "query", null}, {"http:/path/info?query#fragment", "http", null, null, null, "/path/info", null, "query", "fragment"}, {"http:/path/info;param", "http", null, null, null, "/path/info", "param", null, null}, {"http:/path/info;param#fragment", "http", null, null, null, "/path/info", "param", null, "fragment"}, {"http:/path/info;param?query", "http", null, null, null, "/path/info", "param", "query", null}, {"http:/path/info;param?query#fragment", "http", null, null, null, "/path/info", "param", "query", "fragment"}, {"http://user@host:8080/path/info;param?query#fragment", "http", "//user@host:8080", "host", "8080", "/path/info", "param", "query", "fragment"}, {"xxxxx://user@host:8080/path/info;param?query#fragment", "xxxxx", "//user@host:8080", "host", "8080", "/path/info", "param", "query", "fragment"}, {"http:///;?#", "http", "//", null, null, "/", "", "", ""}, {"/path/info?a=?query", null, null, null, null, "/path/info", null, "a=?query", null}, {"/path/info?a=;query", null, null, null, null, "/path/info", null, "a=;query", null}, {"//host:8080//", null, "//host:8080", "host", "8080", "//", null, null, null}, {"file:///path/info", "file", "//", null, null, "/path/info", null, null, null}, {"//", null, "//", null, null, null, null, null, null}, {"/;param", null, null, null, null, "/", "param", null, null}, {"/?x=y", null, null, null, null, "/", null, "x=y", null}, {"/?abc=test", null, null, null, null, "/", null, "abc=test", null}, {"/#fragment", null, null, null, null, "/", null, null, "fragment"}, {"http://localhost:8080", "http", "//localhost:8080", "localhost", "8080", null, null, null, null}, {"./?foo:bar=:1:1::::", null, null, null, null, "./", null, "foo:bar=:1:1::::", null}};
    private final String[][] path_tests = new String[][]{{"/path/info", null, null, null, null, "/path/info", null, null, null}, {"/path/info#fragment", null, null, null, null, "/path/info", null, null, "fragment"}, {"/path/info?query", null, null, null, null, "/path/info", null, "query", null}, {"/path/info?query#fragment", null, null, null, null, "/path/info", null, "query", "fragment"}, {"/path/info;param", null, null, null, null, "/path/info", "param", null, null}, {"/path/info;param#fragment", null, null, null, null, "/path/info", "param", null, "fragment"}, {"/path/info;param?query", null, null, null, null, "/path/info", "param", "query", null}, {"/path/info;param?query#fragment", null, null, null, null, "/path/info", "param", "query", "fragment"}, {"//host/path/info", null, null, null, null, "//host/path/info", null, null, null}, {"//user@host/path/info", null, null, null, null, "//user@host/path/info", null, null, null}, {"//user@host:8080/path/info", null, null, null, null, "//user@host:8080/path/info", null, null, null}, {"//host:8080/path/info", null, null, null, null, "//host:8080/path/info", null, null, null}, {"http:/path/info", "http", null, null, null, "/path/info", null, null, null}, {"http:/path/info#fragment", "http", null, null, null, "/path/info", null, null, "fragment"}, {"http:/path/info?query", "http", null, null, null, "/path/info", null, "query", null}, {"http:/path/info?query#fragment", "http", null, null, null, "/path/info", null, "query", "fragment"}, {"http:/path/info;param", "http", null, null, null, "/path/info", "param", null, null}, {"http:/path/info;param#fragment", "http", null, null, null, "/path/info", "param", null, "fragment"}, {"http:/path/info;param?query", "http", null, null, null, "/path/info", "param", "query", null}, {"http:/path/info;param?query#fragment", "http", null, null, null, "/path/info", "param", "query", "fragment"}, {"http://user@host:8080/path/info;param?query#fragment", "http", "//user@host:8080", "host", "8080", "/path/info", "param", "query", "fragment"}, {"xxxxx://user@host:8080/path/info;param?query#fragment", "xxxxx", "//user@host:8080", "host", "8080", "/path/info", "param", "query", "fragment"}, {"http:///;?#", "http", "//", null, null, "/", "", "", ""}, {"/path/info?a=?query", null, null, null, null, "/path/info", null, "a=?query", null}, {"/path/info?a=;query", null, null, null, null, "/path/info", null, "a=;query", null}, {"//host:8080//", null, null, null, null, "//host:8080//", null, null, null}, {"file:///path/info", "file", "//", null, null, "/path/info", null, null, null}, {"//", null, null, null, null, "//", null, null, null}, {"http://localhost/", "http", "//localhost", "localhost", null, "/", null, null, null}, {"http://localhost:8080/", "http", "//localhost:8080", "localhost", "8080", "/", null, null, null}, {"http://localhost/?x=y", "http", "//localhost", "localhost", null, "/", null, "x=y", null}, {"/;param", null, null, null, null, "/", "param", null, null}, {"/?x=y", null, null, null, null, "/", null, "x=y", null}, {"/?abc=test", null, null, null, null, "/", null, "abc=test", null}, {"/#fragment", null, null, null, null, "/", null, null, "fragment"}, {"http://192.0.0.1:8080/", "http", "//192.0.0.1:8080", "192.0.0.1", "8080", "/", null, null, null}, {"http://[2001:db8::1]:8080/", "http", "//[2001:db8::1]:8080", "[2001:db8::1]", "8080", "/", null, null, null}, {"http://user@[2001:db8::1]:8080/", "http", "//user@[2001:db8::1]:8080", "[2001:db8::1]", "8080", "/", null, null, null}, {"http://[2001:db8::1]/", "http", "//[2001:db8::1]", "[2001:db8::1]", null, "/", null, null, null}, {"//[2001:db8::1]:8080/", null, null, null, null, "//[2001:db8::1]:8080/", null, null, null}, {"http://user@[2001:db8::1]:8080/", "http", "//user@[2001:db8::1]:8080", "[2001:db8::1]", "8080", "/", null, null, null}, {"*", null, null, null, null, "*", null, null, null}};
    private final String[][] encoding_tests = new String[][]{{"/path/info", "/path/info", "UTF-8"}, {"/path/%69nfo", "/path/info", "UTF-8"}, {"http://host/path/%69nfo", "/path/info", "UTF-8"}, {"http://host/path/%69nf%c2%a4", "/path/inf\u00a4", "UTF-8"}, {"http://host/path/%E5", "/path/\u00e5", "ISO-8859-1"}, {"/foo/%u30ED/bar%3Fabc%3D123%26xyz%3D456", "/foo/\u30ed/bar?abc=123&xyz=456", "UTF-8"}};
    private final String[][] connect_tests = new String[][]{{"  localhost:8080  ", "localhost", "8080"}, {"  127.0.0.1:8080  ", "127.0.0.1", "8080"}, {"  [127::0::0::1]:8080  ", "[127::0::0::1]", "8080"}, {"  error  ", null, null}, {"  http://localhost:8080/  ", null, null}};

    @Test
    public void testPartialURIs() throws Exception {
        HttpURI uri = new HttpURI(true);
        for (int t = 0; t < this.partial_tests.length; ++t) {
            uri.parse(this.partial_tests[t][0].getBytes(), 0, this.partial_tests[t][0].length());
            Assert.assertEquals((String)(t + " " + this.partial_tests[t][0]), (Object)this.partial_tests[t][1], (Object)uri.getScheme());
            Assert.assertEquals((String)(t + " " + this.partial_tests[t][0]), (Object)this.partial_tests[t][2], (Object)uri.getAuthority());
            Assert.assertEquals((String)(t + " " + this.partial_tests[t][0]), (Object)this.partial_tests[t][3], (Object)uri.getHost());
            Assert.assertEquals((String)(t + " " + this.partial_tests[t][0]), (long)(this.partial_tests[t][4] == null ? -1L : (long)Integer.parseInt(this.partial_tests[t][4])), (long)uri.getPort());
            Assert.assertEquals((String)(t + " " + this.partial_tests[t][0]), (Object)this.partial_tests[t][5], (Object)uri.getPath());
            Assert.assertEquals((String)(t + " " + this.partial_tests[t][0]), (Object)this.partial_tests[t][6], (Object)uri.getParam());
            Assert.assertEquals((String)(t + " " + this.partial_tests[t][0]), (Object)this.partial_tests[t][7], (Object)uri.getQuery());
            Assert.assertEquals((String)(t + " " + this.partial_tests[t][0]), (Object)this.partial_tests[t][8], (Object)uri.getFragment());
            Assert.assertEquals((Object)this.partial_tests[t][0], (Object)uri.toString());
        }
    }

    @Test
    public void testPathURIs() throws Exception {
        HttpURI uri = new HttpURI();
        for (int t = 0; t < this.path_tests.length; ++t) {
            uri.parse(this.path_tests[t][0].getBytes(), 0, this.path_tests[t][0].length());
            Assert.assertEquals((String)(t + " " + this.path_tests[t][0]), (Object)this.path_tests[t][1], (Object)uri.getScheme());
            Assert.assertEquals((String)(t + " " + this.path_tests[t][0]), (Object)this.path_tests[t][2], (Object)uri.getAuthority());
            Assert.assertEquals((String)(t + " " + this.path_tests[t][0]), (Object)this.path_tests[t][3], (Object)uri.getHost());
            Assert.assertEquals((String)(t + " " + this.path_tests[t][0]), (long)(this.path_tests[t][4] == null ? -1L : (long)Integer.parseInt(this.path_tests[t][4])), (long)uri.getPort());
            Assert.assertEquals((String)(t + " " + this.path_tests[t][0]), (Object)this.path_tests[t][5], (Object)uri.getPath());
            Assert.assertEquals((String)(t + " " + this.path_tests[t][0]), (Object)this.path_tests[t][6], (Object)uri.getParam());
            Assert.assertEquals((String)(t + " " + this.path_tests[t][0]), (Object)this.path_tests[t][7], (Object)uri.getQuery());
            Assert.assertEquals((String)(t + " " + this.path_tests[t][0]), (Object)this.path_tests[t][8], (Object)uri.getFragment());
            Assert.assertEquals((Object)this.path_tests[t][0], (Object)uri.toString());
        }
    }

    @Test
    public void testInvalidAddress() throws Exception {
        this.assertInvalidURI("http://[ffff::1:8080/", "Invalid URL; no closing ']' -- should throw exception");
        this.assertInvalidURI("**", "only '*', not '**'");
        this.assertInvalidURI("*/", "only '*', not '*/'");
    }

    private void assertInvalidURI(String invalidURI, String message) {
        HttpURI uri = new HttpURI();
        try {
            uri.parse(invalidURI);
            Assert.fail((String)message);
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testEncoded() {
        HttpURI uri = new HttpURI();
        for (int t = 0; t < this.encoding_tests.length; ++t) {
            uri.parse(this.encoding_tests[t][0]);
            Assert.assertEquals((String)("" + t), (Object)this.encoding_tests[t][1], (Object)uri.getDecodedPath(this.encoding_tests[t][2]));
            if (!"UTF-8".equalsIgnoreCase(this.encoding_tests[t][2])) continue;
            Assert.assertEquals((String)("" + t), (Object)this.encoding_tests[t][1], (Object)uri.getDecodedPath());
        }
    }

    @Test
    public void testNoPercentEncodingOfQueryUsingNonUTF8() throws Exception {
        byte[] utf8_bytes = "/%D0%A1%D1%82%D1%80%D0%BE%D0%BD%D0%B3-%D1%84%D0%B8%D0%BB%D1%8C%D1%82%D1%80/%D0%BA%D0%B0%D1%82%D0%B0%D0%BB%D0%BE%D0%B3?".getBytes("UTF-8");
        byte[] cp1251_bytes = TypeUtil.fromHexString((String)"e2fbe1f0e0edee3dd2e5ecefe5f0e0f2f3f0e0");
        String expectedCP1251String = new String(cp1251_bytes, "cp1251");
        String expectedCP1251Key = new String(cp1251_bytes, 0, 7, "cp1251");
        String expectedCP1251Value = new String(cp1251_bytes, 8, cp1251_bytes.length - 8, "cp1251");
        byte[] allbytes = new byte[utf8_bytes.length + cp1251_bytes.length];
        for (int i = 0; i < utf8_bytes.length; ++i) {
            allbytes[i] = utf8_bytes[i];
        }
        for (int j = 0; j < cp1251_bytes.length; ++j) {
            allbytes[i + j] = cp1251_bytes[j];
        }
        HttpURI uri = new HttpURI(Charset.forName("cp1251"));
        uri.parse(allbytes, 0, allbytes.length);
        Assert.assertEquals((Object)expectedCP1251String, (Object)uri.getQuery("cp1251"));
        MultiMap params = new MultiMap();
        uri.decodeQueryTo(params);
        String val = params.getString(expectedCP1251Key);
        Assert.assertNotNull((Object)val);
        Assert.assertEquals((Object)expectedCP1251Value, (Object)val);
        HttpURI httpuri = new HttpURI();
        httpuri.parse(allbytes, 0, allbytes.length);
        Assert.assertNotNull((Object)httpuri.getQuery("UTF-8"));
        Assert.assertEquals((Object)expectedCP1251String, (Object)httpuri.getQuery("cp1251"));
        params.clear();
        httpuri.decodeQueryTo(params, "cp1251");
        val = params.getString(expectedCP1251Key);
        Assert.assertNotNull((Object)val);
        Assert.assertEquals((Object)expectedCP1251Value, (Object)val);
        Request request = new Request(null, null);
        request.setUri(httpuri);
        request.setAttribute("org.eclipse.jetty.server.Request.queryEncoding", (Object)"ISO-8859-1");
        Assert.assertNotNull((Object)request.getQueryString());
        request.setAttribute("org.eclipse.jetty.server.Request.queryEncoding", (Object)"cp1251");
        Assert.assertEquals((Object)expectedCP1251String, (Object)request.getQueryString());
    }

    @Test
    public void testPercentEncodingOfQueryStringUsingNonUTF8() throws UnsupportedEncodingException {
        byte[] utf8_bytes = "/%D0%A1%D1%82%D1%80%D0%BE%D0%BD%D0%B3-%D1%84%D0%B8%D0%BB%D1%8C%D1%82%D1%80/%D0%BA%D0%B0%D1%82%D0%B0%D0%BB%D0%BE%D0%B3?".getBytes("UTF-8");
        byte[] cp1251_bytes = "%e2%fb%e1%f0%e0%ed%ee=%d2%e5%ec%ef%e5%f0%e0%f2%f3%f0%e0".getBytes("cp1251");
        byte[] key_bytes = TypeUtil.fromHexString((String)"e2fbe1f0e0edee");
        byte[] val_bytes = TypeUtil.fromHexString((String)"d2e5ecefe5f0e0f2f3f0e0");
        String expectedCP1251String = new String(cp1251_bytes, "cp1251");
        String expectedCP1251Key = new String(key_bytes, "cp1251");
        String expectedCP1251Value = new String(val_bytes, "cp1251");
        byte[] allbytes = new byte[utf8_bytes.length + cp1251_bytes.length];
        for (int i = 0; i < utf8_bytes.length; ++i) {
            allbytes[i] = utf8_bytes[i];
        }
        for (int j = 0; j < cp1251_bytes.length; ++j) {
            allbytes[i + j] = cp1251_bytes[j];
        }
        HttpURI httpuri = new HttpURI();
        httpuri.parse(allbytes, 0, allbytes.length);
        Assert.assertNotNull((Object)httpuri.getQuery("UTF-8"));
        Assert.assertEquals((Object)expectedCP1251String, (Object)httpuri.getQuery("cp1251"));
        MultiMap params = new MultiMap();
        httpuri.decodeQueryTo(params, "cp1251");
        String val = params.getString(expectedCP1251Key);
        Assert.assertNotNull((Object)val);
        Assert.assertEquals((Object)expectedCP1251Value, (Object)val);
        Request request = new Request(null, null);
        request.setUri(httpuri);
        request.setAttribute("org.eclipse.jetty.server.Request.queryEncoding", (Object)"ISO-8859-1");
        Assert.assertNotNull((Object)request.getQueryString());
        request.setAttribute("org.eclipse.jetty.server.Request.queryEncoding", (Object)"cp1251");
        Assert.assertEquals((Object)expectedCP1251String, (Object)request.getQueryString());
    }

    @Test
    public void testUnicodeErrors() throws UnsupportedEncodingException {
        String uri = "http://server/path?invalid=data%uXXXXhere%u000";
        try {
            URLDecoder.decode(uri, "UTF-8");
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        HttpURI huri = new HttpURI(uri);
        MultiMap params = new MultiMap();
        huri.decodeQueryTo(params);
        Assert.assertEquals((Object)"data\ufffdhere\ufffd", (Object)params.getValue("invalid", 0));
        huri = new HttpURI(uri);
        params = new MultiMap();
        huri.decodeQueryTo(params, StandardCharsets.UTF_8);
        Assert.assertEquals((Object)"data\ufffdhere\ufffd", (Object)params.getValue("invalid", 0));
    }

    @Test
    public void testExtB() throws Exception {
        for (String value : new String[]{"a", "abcdABCD", "\u00c0", "\u697c", "\ud869\uded5", "\ud840\udc08"}) {
            HttpURI uri = new HttpURI("/path?value=" + URLEncoder.encode(value, "UTF-8"));
            MultiMap parameters = new MultiMap();
            uri.decodeQueryTo(parameters, StandardCharsets.UTF_8);
            Assert.assertEquals((Object)value, (Object)parameters.getString("value"));
        }
    }

    @Test
    public void testCONNECT() throws Exception {
        HttpURI uri = new HttpURI();
        for (int i = 0; i < this.connect_tests.length; ++i) {
            try {
                byte[] buf = this.connect_tests[i][0].getBytes(StandardCharsets.UTF_8);
                uri.parseConnect(buf, 2, buf.length - 4);
                Assert.assertEquals((String)("path" + i), (Object)this.connect_tests[i][0].trim(), (Object)uri.getPath());
                Assert.assertEquals((String)("host" + i), (Object)this.connect_tests[i][1], (Object)uri.getHost());
                Assert.assertEquals((String)("port" + i), (long)Integer.parseInt(this.connect_tests[i][2]), (long)uri.getPort());
                continue;
            }
            catch (Exception e) {
                Assert.assertNull((String)("error" + i), (Object)this.connect_tests[i][1]);
            }
        }
    }

    @Test
    public void testNonURIAscii() throws Exception {
        String url = "http://www.foo.com/ma\u00f1ana";
        byte[] asISO = url.getBytes(StandardCharsets.ISO_8859_1);
        new String(asISO, StandardCharsets.ISO_8859_1);
        String s = URLEncoder.encode(url, "ISO-8859-1");
        HttpURI uri = new HttpURI(StandardCharsets.ISO_8859_1);
        uri.parse(s);
        String d = URLDecoder.decode(uri.getCompletePath(), "ISO-8859-1");
        Assert.assertEquals((Object)url, (Object)d);
    }
}

