/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.AsyncContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.util.IO;
import org.junit.Assert;
import org.junit.Test;

public class HalfCloseTest {
    @Test
    public void testHalfCloseRace() throws Exception {
        Server server = new Server();
        ServerConnector connector = new ServerConnector(server, 1, 1);
        connector.setPort(0);
        connector.setIdleTimeout(500L);
        server.addConnector((Connector)connector);
        TestHandler handler = new TestHandler();
        server.setHandler((Handler)handler);
        server.start();
        try (Socket client = new Socket("localhost", connector.getLocalPort());){
            int in = client.getInputStream().read();
            Assert.assertEquals((long)-1L, (long)in);
            client.getOutputStream().write("GET / HTTP/1.0\r\n\r\n".getBytes());
            Thread.sleep(200L);
            Assert.assertEquals((long)0L, (long)handler.getHandled());
        }
    }

    @Test
    public void testCompleteClose() throws Exception {
        Server server = new Server();
        ServerConnector connector = new ServerConnector(server, 1, 1);
        connector.setPort(0);
        connector.setIdleTimeout(5000L);
        final AtomicInteger opened = new AtomicInteger(0);
        final CountDownLatch closed = new CountDownLatch(1);
        connector.addBean((Object)new Connection.Listener(){

            public void onOpened(Connection connection) {
                opened.incrementAndGet();
            }

            public void onClosed(Connection connection) {
                closed.countDown();
            }
        });
        server.addConnector((Connector)connector);
        TestHandler handler = new TestHandler();
        server.setHandler((Handler)handler);
        server.start();
        try (Socket client = new Socket("localhost", connector.getLocalPort());){
            client.getOutputStream().write("GET / HTTP/1.0\r\n\r\n".getBytes());
            IO.toString((InputStream)client.getInputStream());
            Assert.assertEquals((long)1L, (long)handler.getHandled());
            Assert.assertEquals((long)1L, (long)opened.get());
        }
        Assert.assertEquals((Object)true, (Object)closed.await(1L, TimeUnit.SECONDS));
    }

    @Test
    public void testAsyncClose() throws Exception {
        Server server = new Server();
        ServerConnector connector = new ServerConnector(server, 1, 1);
        connector.setPort(0);
        connector.setIdleTimeout(5000L);
        final AtomicInteger opened = new AtomicInteger(0);
        final CountDownLatch closed = new CountDownLatch(1);
        connector.addBean((Object)new Connection.Listener(){

            public void onOpened(Connection connection) {
                opened.incrementAndGet();
            }

            public void onClosed(Connection connection) {
                closed.countDown();
            }
        });
        server.addConnector((Connector)connector);
        AsyncHandler handler = new AsyncHandler();
        server.setHandler((Handler)handler);
        server.start();
        try (Socket client = new Socket("localhost", connector.getLocalPort());){
            client.getOutputStream().write("GET / HTTP/1.0\r\n\r\n".getBytes());
            IO.toString((InputStream)client.getInputStream());
            Assert.assertEquals((long)1L, (long)handler.getHandled());
            Assert.assertEquals((long)1L, (long)opened.get());
        }
        Assert.assertEquals((Object)true, (Object)closed.await(1L, TimeUnit.SECONDS));
    }

    public static class AsyncHandler
    extends AbstractHandler {
        transient int handled;

        public void handle(String target, Request baseRequest, HttpServletRequest request, final HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            ++this.handled;
            final AsyncContext async = request.startAsync();
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        response.setContentType("text/html;charset=utf-8");
                        response.setStatus(200);
                        response.getWriter().println("<h1>Test</h1>");
                    }
                    catch (Exception ex) {
                        System.err.println(ex);
                    }
                    finally {
                        async.complete();
                    }
                }
            }.start();
        }

        public int getHandled() {
            return this.handled;
        }
    }

    public static class TestHandler
    extends AbstractHandler {
        transient int handled;

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            ++this.handled;
            response.setContentType("text/html;charset=utf-8");
            response.setStatus(200);
            response.getWriter().println("<h1>Test</h1>");
        }

        public int getHandled() {
            return this.handled;
        }
    }
}

