/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.ssl;

import java.io.FileInputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.eclipse.jetty.io.ssl.SslConnection;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpServerTestBase;
import org.eclipse.jetty.server.HttpServerTestFixture;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class SelectChannelServerSslTest
extends HttpServerTestBase {
    static SSLContext __sslContext;

    public SelectChannelServerSslTest() {
        this._scheme = "https";
    }

    @Override
    protected Socket newSocket(String host, int port) throws Exception {
        return __sslContext.getSocketFactory().createSocket(host, port);
    }

    @Override
    public void testFullMethod() throws Exception {
        try {
            super.testFullMethod();
        }
        catch (SocketException e) {
            Log.getLogger(SslConnection.class).warn("Close overtook 400 response", new Object[0]);
        }
    }

    @Override
    public void testFullURI() throws Exception {
        try {
            super.testFullURI();
        }
        catch (SocketException e) {
            Log.getLogger(SslConnection.class).warn("Close overtook 400 response", new Object[0]);
        }
    }

    @Override
    public void testFullHeader() throws Exception {
        try {
            super.testFullHeader();
        }
        catch (SocketException e) {
            Log.getLogger(SslConnection.class).warn("Close overtook 400 response", new Object[0]);
        }
    }

    @Before
    public void init() throws Exception {
        String keystorePath = System.getProperty("basedir", ".") + "/src/test/resources/keystore";
        SslContextFactory sslContextFactory = new SslContextFactory();
        sslContextFactory.setKeyStorePath(keystorePath);
        sslContextFactory.setKeyStorePassword("storepwd");
        sslContextFactory.setKeyManagerPassword("keypwd");
        sslContextFactory.setTrustStorePath(keystorePath);
        sslContextFactory.setTrustStorePassword("storepwd");
        ServerConnector connector = new ServerConnector(this._server, 1, 1, sslContextFactory);
        this.startServer((NetworkConnector)connector);
        KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
        try (FileInputStream stream = new FileInputStream(sslContextFactory.getKeyStorePath());){
            keystore.load(stream, "storepwd".toCharArray());
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keystore);
        __sslContext = SSLContext.getInstance("TLS");
        __sslContext.init(null, trustManagerFactory.getTrustManagers(), null);
        try {
            HttpsURLConnection.setDefaultHostnameVerifier(__hostnameverifier);
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, SslContextFactory.TRUST_ALL_CERTS, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public void testBlockingWhileReadingRequestContent() throws Exception {
        super.testBlockingWhileReadingRequestContent();
    }

    @Override
    public void testBlockingWhileWritingResponseContent() throws Exception {
        super.testBlockingWhileWritingResponseContent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRequest2FixedFragments() throws Exception {
        this.configureServer((Handler)new HttpServerTestFixture.EchoHandler());
        byte[] bytes = REQUEST2.getBytes();
        int[] points = new int[]{74, 325};
        Arrays.sort(points);
        URI uri = this._server.getURI();
        try (Socket client = this.newSocket(uri.getHost(), uri.getPort());){
            OutputStream os = client.getOutputStream();
            int last = 0;
            for (int j = 0; j < points.length; ++j) {
                int point = points[j];
                os.write(bytes, last, point - last);
                last = point;
                os.flush();
                Thread.sleep(10L);
            }
            os.write(bytes, last, bytes.length - last);
            os.flush();
            Thread.sleep(10L);
            String response = SelectChannelServerSslTest.readResponse(client);
            Assert.assertEquals((Object)RESPONSE2, (Object)response);
        }
    }

    @Override
    @Test
    @Ignore(value="Override and ignore this test as SSLSocket.shutdownOutput() is not supported, but shutdownOutput() is needed by the test.")
    public void testInterruptedRequest() {
    }

    @Override
    @Ignore
    public void testAvailable() throws Exception {
    }
}

