/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.io.File;
import javax.servlet.http.HttpServletRequest;
import junit.framework.Assert;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.session.HashSessionIdManager;
import org.eclipse.jetty.server.session.HashSessionManager;
import org.eclipse.jetty.server.session.HashedSession;
import org.eclipse.jetty.toolchain.test.MavenTestingUtils;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.StdErrLog;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class HashSessionManagerTest {
    @After
    public void enableStacks() {
        this.enableStacks(true);
    }

    @Before
    public void quietStacks() {
        this.enableStacks(false);
    }

    protected void enableStacks(boolean enabled) {
        StdErrLog log = (StdErrLog)Log.getLogger((String)"org.eclipse.jetty.server.session");
        log.setHideStacks(!enabled);
    }

    @Test
    public void testDangerousSessionIdRemoval() throws Exception {
        HashSessionManager manager = new HashSessionManager();
        manager.setDeleteUnrestorableSessions(true);
        manager.setLazyLoad(true);
        File testDir = MavenTestingUtils.getTargetTestingDir((String)"hashes");
        testDir.mkdirs();
        manager.setStoreDirectory(testDir);
        MavenTestingUtils.getTargetFile((String)"dangerFile.session").createNewFile();
        Assert.assertTrue((String)"File should exist!", (boolean)MavenTestingUtils.getTargetFile((String)"dangerFile.session").exists());
        manager.getSession("../../dangerFile.session");
        Assert.assertTrue((String)"File should exist!", (boolean)MavenTestingUtils.getTargetFile((String)"dangerFile.session").exists());
    }

    @Test
    public void testValidSessionIdRemoval() throws Exception {
        HashSessionManager manager = new HashSessionManager();
        manager.setDeleteUnrestorableSessions(true);
        manager.setLazyLoad(true);
        File testDir = MavenTestingUtils.getTargetTestingDir((String)"hashes");
        testDir.mkdirs();
        manager.setStoreDirectory(testDir);
        new File(testDir, "validFile.session").createNewFile();
        Assert.assertTrue((String)"File should exist!", (boolean)new File(testDir, "validFile.session").exists());
        manager.getSession("validFile.session");
        Assert.assertTrue((String)"File shouldn't exist!", (!new File(testDir, "validFile.session").exists() ? 1 : 0) != 0);
    }

    @Test
    public void testHashSession() throws Exception {
        File testDir = MavenTestingUtils.getTargetTestingDir((String)"saved");
        testDir.mkdirs();
        HashSessionManager manager = new HashSessionManager();
        manager.setStoreDirectory(testDir);
        manager.setMaxInactiveInterval(5);
        Assert.assertTrue((boolean)testDir.exists());
        Assert.assertTrue((boolean)testDir.canWrite());
        HashSessionIdManager idManager = new HashSessionIdManager();
        idManager.setWorkerName("foo");
        manager.setSessionIdManager((SessionIdManager)idManager);
        idManager.start();
        manager.start();
        HashedSession session = (HashedSession)manager.newHttpSession((HttpServletRequest)new Request(null, null));
        String sessionId = session.getId();
        session.setAttribute("one", (Object)new Integer(1));
        session.setAttribute("two", (Object)new Integer(2));
        idManager.stop();
        manager.setMaxInactiveInterval(30);
        manager.stop();
        Assert.assertTrue((String)"File should exist!", (boolean)new File(testDir, session.getId()).exists());
        idManager.start();
        manager.start();
        HashedSession restoredSession = (HashedSession)manager.getSession(sessionId);
        Assert.assertNotNull((Object)restoredSession);
        Object o = restoredSession.getAttribute("one");
        Assert.assertNotNull((Object)o);
        Assert.assertEquals((int)1, (int)((Integer)o));
        Assert.assertEquals((int)5, (int)restoredSession.getMaxInactiveInterval());
    }
}

