/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.toolchain.test.FS;
import org.eclipse.jetty.toolchain.test.MavenTestingUtils;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.resource.Resource;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

@Ignore(value="Unfixed range bug")
public class ResourceHandlerRangeTest {
    private static Server server;
    private static URI serverUri;

    @BeforeClass
    public static void startServer() throws Exception {
        server = new Server();
        ServerConnector connector = new ServerConnector(server);
        connector.setPort(0);
        server.addConnector((Connector)connector);
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        File dir = MavenTestingUtils.getTargetTestingDir((String)ResourceHandlerRangeTest.class.getSimpleName());
        FS.ensureEmpty((File)dir);
        File rangeFile = new File(dir, "range.txt");
        try (FileWriter writer = new FileWriter(rangeFile);){
            writer.append("0123456789");
            writer.flush();
        }
        ContextHandler contextHandler = new ContextHandler();
        ResourceHandler contentResourceHandler = new ResourceHandler();
        contextHandler.setBaseResource(Resource.newResource((String)dir.getAbsolutePath()));
        contextHandler.setHandler((Handler)contentResourceHandler);
        contextHandler.setContextPath("/");
        contexts.addHandler((Handler)contextHandler);
        server.setHandler((Handler)contexts);
        server.start();
        String host = connector.getHost();
        if (host == null) {
            host = "localhost";
        }
        int port = connector.getLocalPort();
        serverUri = new URI(String.format("http://%s:%d/", host, port));
    }

    @AfterClass
    public static void stopServer() throws Exception {
        server.stop();
    }

    @Test
    public void testGetRange() throws Exception {
        String response;
        URI uri = serverUri.resolve("range.txt");
        HttpURLConnection uconn = (HttpURLConnection)uri.toURL().openConnection();
        uconn.setRequestMethod("GET");
        uconn.addRequestProperty("Range", "bytes=5-");
        int contentLength = Integer.parseInt(uconn.getHeaderField("Content-Length"));
        try (InputStream is = uconn.getInputStream();){
            response = IO.toString((InputStream)is);
        }
        Assert.assertThat((String)"Content Length", (Object)contentLength, (Matcher)Matchers.is((Object)5));
        Assert.assertThat((String)"Response Content", (Object)response, (Matcher)Matchers.is((Object)"56789"));
    }
}

