/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AllowSymLinkAliasChecker;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.toolchain.test.FS;
import org.eclipse.jetty.toolchain.test.OS;
import org.eclipse.jetty.util.resource.Resource;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ContextHandlerGetResourceTest {
    private static Server server;
    private static ContextHandler context;
    private static File docroot;
    private static File otherroot;
    private static final AtomicBoolean allowAliases;
    private static final AtomicBoolean allowSymlinks;

    @BeforeClass
    public static void beforeClass() throws Exception {
        docroot = new File("target/tests/docroot").getCanonicalFile().getAbsoluteFile();
        FS.ensureDirExists((File)docroot);
        FS.ensureEmpty((File)docroot);
        File index = new File(docroot, "index.html");
        index.createNewFile();
        File sub = new File(docroot, "subdir");
        sub.mkdir();
        File data = new File(sub, "data.txt");
        data.createNewFile();
        File verylong = new File(sub, "TextFile.Long.txt");
        verylong.createNewFile();
        otherroot = new File("target/tests/otherroot").getCanonicalFile().getAbsoluteFile();
        FS.ensureDirExists((File)otherroot);
        FS.ensureEmpty((File)otherroot);
        File other = new File(otherroot, "other.txt");
        other.createNewFile();
        File transit = new File(docroot.getParentFile(), "transit");
        System.err.println("transit " + transit);
        transit.delete();
        if (OS.IS_UNIX) {
            File eightDotThree = new File(sub, "TEXTFI~1.TXT");
            Files.createSymbolicLink(eightDotThree.toPath(), verylong.toPath(), new FileAttribute[0]);
            Files.createSymbolicLink(new File(docroot, "other").toPath(), new File("../transit").toPath(), new FileAttribute[0]);
            Files.createSymbolicLink(transit.toPath(), otherroot.toPath(), new FileAttribute[0]);
        }
        server = new Server();
        context = new ContextHandler("/");
        context.setBaseResource(Resource.newResource((File)docroot));
        context.addAliasCheck(new ContextHandler.AliasCheck(){
            final AllowSymLinkAliasChecker symlinkcheck = new AllowSymLinkAliasChecker();

            public boolean check(String path, Resource resource) {
                if (allowAliases.get()) {
                    return true;
                }
                if (allowSymlinks.get()) {
                    return this.symlinkcheck.check(path, resource);
                }
                return allowAliases.get();
            }
        });
        server.setHandler((Handler)context);
        server.start();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        server.stop();
    }

    @Test
    public void testBadPath() throws Exception {
        String path = "bad";
        try {
            context.getResource("bad");
            Assert.fail();
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        try {
            context.getServletContext().getResource("bad");
            Assert.fail();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    @Test
    public void testGetUnknown() throws Exception {
        String path = "/unknown.txt";
        Resource resource = context.getResource("/unknown.txt");
        Assert.assertEquals((Object)"unknown.txt", (Object)resource.getFile().getName());
        Assert.assertEquals((Object)docroot, (Object)resource.getFile().getParentFile());
        Assert.assertFalse((boolean)resource.exists());
        URL url = context.getServletContext().getResource("/unknown.txt");
        Assert.assertNull((Object)url);
    }

    @Test
    public void testGetUnknownDir() throws Exception {
        String path = "/unknown/";
        Resource resource = context.getResource("/unknown/");
        Assert.assertEquals((Object)"unknown", (Object)resource.getFile().getName());
        Assert.assertEquals((Object)docroot, (Object)resource.getFile().getParentFile());
        Assert.assertFalse((boolean)resource.exists());
        URL url = context.getServletContext().getResource("/unknown/");
        Assert.assertNull((Object)url);
    }

    @Test
    public void testRoot() throws Exception {
        String path = "/";
        Resource resource = context.getResource("/");
        Assert.assertEquals((Object)docroot, (Object)resource.getFile());
        Assert.assertTrue((boolean)resource.exists());
        Assert.assertTrue((boolean)resource.isDirectory());
        URL url = context.getServletContext().getResource("/");
        Assert.assertEquals((Object)docroot, (Object)new File(url.toURI()));
    }

    @Test
    public void testSubdir() throws Exception {
        String path = "/subdir";
        Resource resource = context.getResource("/subdir");
        Assert.assertEquals((Object)docroot, (Object)resource.getFile().getParentFile());
        Assert.assertTrue((boolean)resource.exists());
        Assert.assertTrue((boolean)resource.isDirectory());
        Assert.assertTrue((boolean)resource.toString().endsWith("/"));
        URL url = context.getServletContext().getResource("/subdir");
        Assert.assertEquals((Object)docroot, (Object)new File(url.toURI()).getParentFile());
    }

    @Test
    public void testSubdirSlash() throws Exception {
        String path = "/subdir/";
        Resource resource = context.getResource("/subdir/");
        Assert.assertEquals((Object)docroot, (Object)resource.getFile().getParentFile());
        Assert.assertTrue((boolean)resource.exists());
        Assert.assertTrue((boolean)resource.isDirectory());
        Assert.assertTrue((boolean)resource.toString().endsWith("/"));
        URL url = context.getServletContext().getResource("/subdir/");
        Assert.assertEquals((Object)docroot, (Object)new File(url.toURI()).getParentFile());
    }

    @Test
    public void testGetKnown() throws Exception {
        String path = "/index.html";
        Resource resource = context.getResource("/index.html");
        Assert.assertEquals((Object)"index.html", (Object)resource.getFile().getName());
        Assert.assertEquals((Object)docroot, (Object)resource.getFile().getParentFile());
        Assert.assertTrue((boolean)resource.exists());
        URL url = context.getServletContext().getResource("/index.html");
        Assert.assertEquals((Object)docroot, (Object)new File(url.toURI()).getParentFile());
    }

    @Test
    public void testNormalize() throws Exception {
        String path = "/down/.././index.html";
        Resource resource = context.getResource("/down/.././index.html");
        Assert.assertEquals((Object)"index.html", (Object)resource.getFile().getName());
        Assert.assertEquals((Object)docroot, (Object)resource.getFile().getParentFile());
        Assert.assertTrue((boolean)resource.exists());
        URL url = context.getServletContext().getResource("/down/.././index.html");
        Assert.assertEquals((Object)docroot, (Object)new File(url.toURI()).getParentFile());
    }

    @Test
    public void testTooNormal() throws Exception {
        String path = "/down/.././../";
        Resource resource = context.getResource("/down/.././../");
        Assert.assertNull((Object)resource);
        URL url = context.getServletContext().getResource("/down/.././../");
        Assert.assertNull((Object)url);
    }

    @Test
    public void testDeep() throws Exception {
        String path = "/subdir/data.txt";
        Resource resource = context.getResource("/subdir/data.txt");
        Assert.assertEquals((Object)"data.txt", (Object)resource.getFile().getName());
        Assert.assertEquals((Object)docroot, (Object)resource.getFile().getParentFile().getParentFile());
        Assert.assertTrue((boolean)resource.exists());
        URL url = context.getServletContext().getResource("/subdir/data.txt");
        Assert.assertEquals((Object)docroot, (Object)new File(url.toURI()).getParentFile().getParentFile());
    }

    @Test
    public void testEncodedSlash() throws Exception {
        String path = "/subdir%2Fdata.txt";
        Resource resource = context.getResource("/subdir%2Fdata.txt");
        Assert.assertEquals((Object)"subdir%2Fdata.txt", (Object)resource.getFile().getName());
        Assert.assertEquals((Object)docroot, (Object)resource.getFile().getParentFile());
        Assert.assertFalse((boolean)resource.exists());
        URL url = context.getServletContext().getResource("/subdir%2Fdata.txt");
        Assert.assertNull((Object)url);
    }

    @Test
    public void testEncodedSlosh() throws Exception {
        String path = "/subdir%5Cdata.txt";
        Resource resource = context.getResource("/subdir%5Cdata.txt");
        Assert.assertEquals((Object)"subdir%5Cdata.txt", (Object)resource.getFile().getName());
        Assert.assertEquals((Object)docroot, (Object)resource.getFile().getParentFile());
        Assert.assertFalse((boolean)resource.exists());
        URL url = context.getServletContext().getResource("/subdir%5Cdata.txt");
        Assert.assertNull((Object)url);
    }

    @Test
    public void testEncodedNull() throws Exception {
        String path = "/subdir/data.txt%00";
        Resource resource = context.getResource("/subdir/data.txt%00");
        Assert.assertEquals((Object)"data.txt%00", (Object)resource.getFile().getName());
        Assert.assertEquals((Object)docroot, (Object)resource.getFile().getParentFile().getParentFile());
        Assert.assertFalse((boolean)resource.exists());
        URL url = context.getServletContext().getResource("/subdir/data.txt%00");
        Assert.assertNull((Object)url);
    }

    @Test
    public void testSlashSlash() throws Exception {
        String path = "//subdir/data.txt";
        Resource resource = context.getResource(path);
        Assert.assertNull((Object)resource);
        URL url = context.getServletContext().getResource(path);
        Assert.assertNull((Object)url);
        path = "/subdir//data.txt";
        resource = context.getResource(path);
        Assert.assertNull((Object)resource);
        url = context.getServletContext().getResource(path);
        Assert.assertNull((Object)url);
    }

    @Test
    public void testAliasedFile() throws Exception {
        String path = "/subdir/TEXTFI~1.TXT";
        Resource resource = context.getResource("/subdir/TEXTFI~1.TXT");
        Assert.assertNull((Object)resource);
        URL url = context.getServletContext().getResource("/subdir/TEXTFI~1.TXT");
        Assert.assertNull((Object)url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAliasedFileAllowed() throws Exception {
        try {
            allowAliases.set(true);
            String path = "/subdir/TEXTFI~1.TXT";
            Resource resource = context.getResource("/subdir/TEXTFI~1.TXT");
            Assert.assertNotNull((Object)resource);
            Assert.assertEquals((Object)context.getResource("/subdir/TextFile.Long.txt").getURL(), (Object)resource.getAlias());
            URL url = context.getServletContext().getResource("/subdir/TEXTFI~1.TXT");
            Assert.assertNotNull((Object)url);
            Assert.assertEquals((Object)docroot, (Object)new File(url.toURI()).getParentFile().getParentFile());
        }
        finally {
            allowAliases.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSymlinkKnown() throws Exception {
        if (!OS.IS_UNIX) {
            return;
        }
        try {
            allowSymlinks.set(true);
            String path = "/other/other.txt";
            Resource resource = context.getResource("/other/other.txt");
            Assert.assertNotNull((Object)resource);
            Assert.assertEquals((Object)"other.txt", (Object)resource.getFile().getName());
            Assert.assertEquals((Object)docroot, (Object)resource.getFile().getParentFile().getParentFile());
            Assert.assertTrue((boolean)resource.exists());
            URL url = context.getServletContext().getResource("/other/other.txt");
            Assert.assertEquals((Object)docroot, (Object)new File(url.toURI()).getParentFile().getParentFile());
        }
        finally {
            allowSymlinks.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSymlinkUnknown() throws Exception {
        if (!OS.IS_UNIX) {
            return;
        }
        try {
            allowSymlinks.set(true);
            String path = "/other/unknown.txt";
            Resource resource = context.getResource("/other/unknown.txt");
            Assert.assertNotNull((Object)resource);
            Assert.assertEquals((Object)"unknown.txt", (Object)resource.getFile().getName());
            Assert.assertEquals((Object)docroot, (Object)resource.getFile().getParentFile().getParentFile());
            Assert.assertFalse((boolean)resource.exists());
            URL url = context.getServletContext().getResource("/other/unknown.txt");
            Assert.assertNull((Object)url);
        }
        finally {
            allowSymlinks.set(false);
        }
    }

    static {
        allowAliases = new AtomicBoolean(false);
        allowSymlinks = new AtomicBoolean(false);
    }
}

