/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.DumpHandler;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.LowResourceMonitor;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.util.thread.TimerScheduler;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class LowResourcesMonitorTest {
    QueuedThreadPool _threadPool;
    Server _server;
    ServerConnector _connector;
    LowResourceMonitor _lowResourcesMonitor;

    @Before
    public void before() throws Exception {
        this._threadPool = new QueuedThreadPool();
        this._threadPool.setMaxThreads(50);
        this._server = new Server((ThreadPool)this._threadPool);
        this._server.manage((Object)this._threadPool);
        this._server.addBean((Object)new TimerScheduler());
        this._connector = new ServerConnector(this._server);
        this._connector.setPort(0);
        this._connector.setIdleTimeout(35000L);
        this._server.addConnector((Connector)this._connector);
        this._server.setHandler((Handler)new DumpHandler());
        this._lowResourcesMonitor = new LowResourceMonitor(this._server);
        this._lowResourcesMonitor.setLowResourcesIdleTimeout(200);
        this._lowResourcesMonitor.setMaxConnections(20);
        this._lowResourcesMonitor.setPeriod(900);
        this._server.addBean((Object)this._lowResourcesMonitor);
        this._server.start();
    }

    @After
    public void after() throws Exception {
        this._server.stop();
    }

    @Test
    public void testLowOnThreads() throws Exception {
        Thread.sleep(1200L);
        this._threadPool.setMaxThreads(this._threadPool.getThreads() - this._threadPool.getIdleThreads() + 10);
        Thread.sleep(1200L);
        Assert.assertFalse((boolean)this._lowResourcesMonitor.isLowOnResources());
        final CountDownLatch latch = new CountDownLatch(1);
        for (int i = 0; i < 100; ++i) {
            this._threadPool.dispatch(new Runnable(){

                @Override
                public void run() {
                    try {
                        latch.await();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        Thread.sleep(1200L);
        Assert.assertTrue((boolean)this._lowResourcesMonitor.isLowOnResources());
        latch.countDown();
        Thread.sleep(1200L);
        Assert.assertFalse((boolean)this._lowResourcesMonitor.isLowOnResources());
    }

    @Ignore(value="not reliable")
    @Test
    public void testLowOnMemory() throws Exception {
        this._lowResourcesMonitor.setMaxMemory(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory() + 0x6400000L);
        Thread.sleep(1200L);
        Assert.assertFalse((boolean)this._lowResourcesMonitor.isLowOnResources());
        byte[] data = new byte[0x6400000];
        Arrays.fill(data, (byte)1);
        int hash = Arrays.hashCode(data);
        Assert.assertThat((Object)hash, (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)0)));
        Thread.sleep(1200L);
        Assert.assertTrue((boolean)this._lowResourcesMonitor.isLowOnResources());
        data = null;
        System.gc();
        System.gc();
        Thread.sleep(1200L);
        Assert.assertFalse((boolean)this._lowResourcesMonitor.isLowOnResources());
    }

    @Test
    public void testMaxConnectionsAndMaxIdleTime() throws Exception {
        this._lowResourcesMonitor.setMaxMemory(0L);
        Assert.assertFalse((boolean)this._lowResourcesMonitor.isLowOnResources());
        Socket[] socket = new Socket[this._lowResourcesMonitor.getMaxConnections() + 1];
        for (int i = 0; i < socket.length; ++i) {
            socket[i] = new Socket("localhost", this._connector.getLocalPort());
        }
        Thread.sleep(1200L);
        Assert.assertTrue((boolean)this._lowResourcesMonitor.isLowOnResources());
        Socket newSocket = new Socket("localhost", this._connector.getLocalPort());
        Thread.sleep(1200L);
        Assert.assertFalse((boolean)this._lowResourcesMonitor.isLowOnResources());
        for (int i = 0; i < socket.length; ++i) {
            Assert.assertEquals((long)-1L, (long)socket[i].getInputStream().read());
        }
        newSocket.getOutputStream().write("GET / HTTP/1.0\r\n\r\n".getBytes(StandardCharsets.UTF_8));
        Assert.assertEquals((long)72L, (long)newSocket.getInputStream().read());
    }

    @Test
    public void testMaxLowResourceTime() throws Exception {
        this._lowResourcesMonitor.setMaxLowResourcesTime(2000);
        Assert.assertFalse((boolean)this._lowResourcesMonitor.isLowOnResources());
        Socket socket0 = new Socket("localhost", this._connector.getLocalPort());
        this._lowResourcesMonitor.setMaxMemory(1L);
        Thread.sleep(1200L);
        Assert.assertTrue((boolean)this._lowResourcesMonitor.isLowOnResources());
        Socket socket1 = new Socket("localhost", this._connector.getLocalPort());
        Thread.sleep(1200L);
        Assert.assertTrue((boolean)this._lowResourcesMonitor.isLowOnResources());
        Assert.assertEquals((long)-1L, (long)socket0.getInputStream().read());
        socket1.getOutputStream().write("G".getBytes(StandardCharsets.UTF_8));
        Thread.sleep(1200L);
        Assert.assertTrue((boolean)this._lowResourcesMonitor.isLowOnResources());
        socket1.getOutputStream().write("E".getBytes(StandardCharsets.UTF_8));
        Thread.sleep(1200L);
        Assert.assertTrue((boolean)this._lowResourcesMonitor.isLowOnResources());
        Assert.assertEquals((long)-1L, (long)socket1.getInputStream().read());
    }
}

