/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.DumpHandler;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Server;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LocalConnectorTest {
    private Server _server;
    private LocalConnector _connector;

    @Before
    public void prepare() throws Exception {
        this._server = new Server();
        this._connector = new LocalConnector(this._server);
        this._connector.setIdleTimeout(60000L);
        this._server.addConnector((Connector)this._connector);
        this._server.setHandler((Handler)new DumpHandler());
        this._server.start();
    }

    @After
    public void dispose() throws Exception {
        this._server.stop();
        this._server = null;
        this._connector = null;
    }

    @Test
    public void testOpenClose() throws Exception {
        final CountDownLatch openLatch = new CountDownLatch(1);
        final CountDownLatch closeLatch = new CountDownLatch(1);
        this._connector.addBean((Object)new Connection.Listener.Empty(){

            public void onOpened(Connection connection) {
                openLatch.countDown();
            }

            public void onClosed(Connection connection) {
                closeLatch.countDown();
            }
        });
        this._connector.getResponses("GET / HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\n\r\n");
        Assert.assertTrue((boolean)openLatch.await(5L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)closeLatch.await(5L, TimeUnit.SECONDS));
    }

    @Test
    public void testOneGET() throws Exception {
        String response = this._connector.getResponses("GET /R1 HTTP/1.0\r\n\r\n");
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"pathInfo=/R1"));
    }

    @Test
    public void testStopStart() throws Exception {
        String response = this._connector.getResponses("GET /R1 HTTP/1.0\r\n\r\n");
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"pathInfo=/R1"));
        this._server.stop();
        this._server.start();
        response = this._connector.getResponses("GET /R2 HTTP/1.0\r\n\r\n");
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"pathInfo=/R2"));
    }

    @Test
    public void testTwoGETs() throws Exception {
        String response = this._connector.getResponses("GET /R1 HTTP/1.1\r\nHost: localhost\r\n\r\nGET /R2 HTTP/1.0\r\n\r\n");
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"pathInfo=/R1"));
        response = response.substring(response.indexOf("</html>") + 8);
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"pathInfo=/R2"));
    }

    @Test
    public void testGETandGET() throws Exception {
        String response = this._connector.getResponses("GET /R1 HTTP/1.0\r\n\r\n");
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"pathInfo=/R1"));
        response = this._connector.getResponses("GET /R2 HTTP/1.0\r\n\r\n");
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"pathInfo=/R2"));
    }
}

