/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.DispatcherType;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.session.SessionHandler;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LocalAsyncContextTest {
    protected Server _server = new Server();
    protected SuspendHandler _handler = new SuspendHandler();
    protected Connector _connector;
    static AtomicInteger __completed = new AtomicInteger();
    static AtomicInteger __completed1 = new AtomicInteger();
    private static AsyncListener __asyncListener = new AsyncListener(){

        public void onComplete(AsyncEvent event) throws IOException {
            __completed.incrementAndGet();
        }

        public void onError(AsyncEvent event) throws IOException {
            __completed.incrementAndGet();
        }

        public void onStartAsync(AsyncEvent event) throws IOException {
            event.getSuppliedResponse().getOutputStream().println("startasync");
            event.getAsyncContext().addListener((AsyncListener)this);
        }

        public void onTimeout(AsyncEvent event) throws IOException {
            event.getSuppliedRequest().setAttribute("TIMEOUT", (Object)Boolean.TRUE);
            event.getAsyncContext().dispatch();
        }
    };
    private static AsyncListener __asyncListener1 = new AsyncListener(){

        public void onComplete(AsyncEvent event) throws IOException {
            __completed1.incrementAndGet();
        }

        public void onError(AsyncEvent event) throws IOException {
        }

        public void onStartAsync(AsyncEvent event) throws IOException {
        }

        public void onTimeout(AsyncEvent event) throws IOException {
        }
    };

    @Before
    public void init() throws Exception {
        this._connector = this.initConnector();
        this._server.setConnectors(new Connector[]{this._connector});
        SessionHandler session = new SessionHandler();
        session.setHandler((Handler)this._handler);
        this._server.setHandler((Handler)session);
        this._server.start();
        __completed.set(0);
        __completed1.set(0);
    }

    protected Connector initConnector() {
        return new LocalConnector(this._server);
    }

    @After
    public void destroy() throws Exception {
        this._server.stop();
        this._server.join();
    }

    @Test
    public void testSuspendTimeout() throws Exception {
        this._handler.setRead(0);
        this._handler.setSuspendFor(1000L);
        this._handler.setResumeAfter(-1L);
        this._handler.setCompleteAfter(-1L);
        String response = this.process(null);
        this.check(response, "TIMEOUT");
        Assert.assertEquals((long)1L, (long)__completed.get());
        Assert.assertEquals((long)1L, (long)__completed1.get());
    }

    @Test
    public void testSuspendResume0() throws Exception {
        this._handler.setRead(0);
        this._handler.setSuspendFor(10000L);
        this._handler.setResumeAfter(0L);
        this._handler.setCompleteAfter(-1L);
        String response = this.process(null);
        this.check(response, "STARTASYNC", "DISPATCHED");
    }

    @Test
    public void testSuspendResume100() throws Exception {
        this._handler.setRead(0);
        this._handler.setSuspendFor(10000L);
        this._handler.setResumeAfter(100L);
        this._handler.setCompleteAfter(-1L);
        String response = this.process(null);
        this.check(response, "STARTASYNC", "DISPATCHED");
    }

    @Test
    public void testSuspendComplete0() throws Exception {
        this._handler.setRead(0);
        this._handler.setSuspendFor(10000L);
        this._handler.setResumeAfter(-1L);
        this._handler.setCompleteAfter(0L);
        String response = this.process(null);
        this.check(response, "STARTASYNC", "COMPLETED");
    }

    @Test
    public void testSuspendComplete200() throws Exception {
        this._handler.setRead(0);
        this._handler.setSuspendFor(10000L);
        this._handler.setResumeAfter(-1L);
        this._handler.setCompleteAfter(200L);
        String response = this.process(null);
        this.check(response, "STARTASYNC", "COMPLETED");
    }

    @Test
    public void testSuspendReadResume0() throws Exception {
        this._handler.setSuspendFor(10000L);
        this._handler.setRead(-1);
        this._handler.setResumeAfter(0L);
        this._handler.setCompleteAfter(-1L);
        String response = this.process("wibble");
        this.check(response, "STARTASYNC", "DISPATCHED");
    }

    @Test
    public void testSuspendReadResume100() throws Exception {
        this._handler.setSuspendFor(10000L);
        this._handler.setRead(-1);
        this._handler.setResumeAfter(100L);
        this._handler.setCompleteAfter(-1L);
        String response = this.process("wibble");
        this.check(response, "DISPATCHED");
    }

    @Test
    public void testSuspendOther() throws Exception {
        this._handler.setSuspendFor(10000L);
        this._handler.setRead(-1);
        this._handler.setResumeAfter(-1L);
        this._handler.setCompleteAfter(0L);
        String response = this.process("wibble");
        this.check(response, "COMPLETED");
        this._handler.setResumeAfter(-1L);
        this._handler.setCompleteAfter(100L);
        response = this.process("wibble");
        this.check(response, "COMPLETED");
        this._handler.setRead(6);
        this._handler.setResumeAfter(0L);
        this._handler.setCompleteAfter(-1L);
        response = this.process("wibble");
        this.check(response, "DISPATCHED");
        this._handler.setResumeAfter(100L);
        this._handler.setCompleteAfter(-1L);
        response = this.process("wibble");
        this.check(response, "DISPATCHED");
        this._handler.setResumeAfter(-1L);
        this._handler.setCompleteAfter(0L);
        response = this.process("wibble");
        this.check(response, "COMPLETED");
        this._handler.setResumeAfter(-1L);
        this._handler.setCompleteAfter(100L);
        response = this.process("wibble");
        this.check(response, "COMPLETED");
    }

    @Test
    public void testTwoCycles() throws Exception {
        __completed.set(0);
        __completed1.set(0);
        this._handler.setRead(0);
        this._handler.setSuspendFor(1000L);
        this._handler.setResumeAfter(100L);
        this._handler.setCompleteAfter(-1L);
        this._handler.setSuspendFor2(1000L);
        this._handler.setResumeAfter2(200L);
        this._handler.setCompleteAfter2(-1L);
        String response = this.process(null);
        this.check(response, "STARTASYNC", "DISPATCHED", "startasync", "STARTASYNC", "DISPATCHED");
        Assert.assertEquals((long)1L, (long)__completed.get());
        Assert.assertEquals((long)0L, (long)__completed1.get());
    }

    protected void check(String response, String ... content) {
        Assert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
        int i = 0;
        for (String m : content) {
            Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)m));
            i = response.indexOf(m, i);
            i += m.length();
        }
    }

    private synchronized String process(String content) throws Exception {
        String request = "GET / HTTP/1.1\r\nHost: localhost\r\nConnection: close\r\n";
        request = content == null ? request + "\r\n" : request + "Content-Length: " + content.length() + "\r\n" + "\r\n" + content;
        String response = this.getResponse(request);
        return response;
    }

    protected String getResponse(String request) throws Exception {
        LocalConnector connector = (LocalConnector)this._connector;
        LocalConnector.LocalEndPoint endp = connector.executeRequest(request);
        endp.waitUntilClosed();
        return endp.takeOutputString();
    }

    private static class SuspendHandler
    extends HandlerWrapper {
        private int _read;
        private long _suspendFor = -1L;
        private long _resumeAfter = -1L;
        private long _completeAfter = -1L;
        private long _suspendFor2 = -1L;
        private long _resumeAfter2 = -1L;
        private long _completeAfter2 = -1L;

        public int getRead() {
            return this._read;
        }

        public void setRead(int read) {
            this._read = read;
        }

        public long getSuspendFor() {
            return this._suspendFor;
        }

        public void setSuspendFor(long suspendFor) {
            this._suspendFor = suspendFor;
        }

        public long getResumeAfter() {
            return this._resumeAfter;
        }

        public void setResumeAfter(long resumeAfter) {
            this._resumeAfter = resumeAfter;
        }

        public long getCompleteAfter() {
            return this._completeAfter;
        }

        public void setCompleteAfter(long completeAfter) {
            this._completeAfter = completeAfter;
        }

        public long getSuspendFor2() {
            return this._suspendFor2;
        }

        public void setSuspendFor2(long suspendFor2) {
            this._suspendFor2 = suspendFor2;
        }

        public long getResumeAfter2() {
            return this._resumeAfter2;
        }

        public void setResumeAfter2(long resumeAfter2) {
            this._resumeAfter2 = resumeAfter2;
        }

        public long getCompleteAfter2() {
            return this._completeAfter2;
        }

        public void setCompleteAfter2(long completeAfter2) {
            this._completeAfter2 = completeAfter2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(String target, final Request baseRequest, HttpServletRequest request, final HttpServletResponse response) throws IOException, ServletException {
            if (DispatcherType.REQUEST.equals((Object)baseRequest.getDispatcherType())) {
                if (this._read > 0) {
                    byte[] buf = new byte[this._read];
                    request.getInputStream().read(buf);
                } else if (this._read < 0) {
                    ServletInputStream in = request.getInputStream();
                    int b = in.read();
                    while (b != -1) {
                        b = in.read();
                    }
                }
                final AsyncContext asyncContext = baseRequest.startAsync();
                response.getOutputStream().println("STARTASYNC");
                asyncContext.addListener(__asyncListener);
                asyncContext.addListener(__asyncListener1);
                if (this._suspendFor > 0L) {
                    asyncContext.setTimeout(this._suspendFor);
                }
                if (this._completeAfter > 0L) {
                    new Thread(){

                        @Override
                        public void run() {
                            try {
                                Thread.sleep(SuspendHandler.this._completeAfter);
                                response.getOutputStream().println("COMPLETED");
                                response.setStatus(200);
                                baseRequest.setHandled(true);
                                asyncContext.complete();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }.start();
                } else if (this._completeAfter == 0L) {
                    response.getOutputStream().println("COMPLETED");
                    response.setStatus(200);
                    baseRequest.setHandled(true);
                    asyncContext.complete();
                }
                if (this._resumeAfter > 0L) {
                    new Thread(){

                        @Override
                        public void run() {
                            try {
                                Thread.sleep(SuspendHandler.this._resumeAfter);
                                if (((HttpServletRequest)asyncContext.getRequest()).getSession(true).getId() != null) {
                                    asyncContext.dispatch();
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }.start();
                } else if (this._resumeAfter == 0L) {
                    asyncContext.dispatch();
                }
            } else {
                if (request.getAttribute("TIMEOUT") != null) {
                    response.getOutputStream().println("TIMEOUT");
                } else {
                    response.getOutputStream().println("DISPATCHED");
                }
                if (this._suspendFor2 >= 0L) {
                    final AsyncContext asyncContext = baseRequest.startAsync();
                    response.getOutputStream().println("STARTASYNC2");
                    if (this._suspendFor2 > 0L) {
                        asyncContext.setTimeout(this._suspendFor2);
                    }
                    this._suspendFor2 = -1L;
                    if (this._completeAfter2 > 0L) {
                        new Thread(){

                            @Override
                            public void run() {
                                try {
                                    Thread.sleep(SuspendHandler.this._completeAfter2);
                                    response.getOutputStream().println("COMPLETED2");
                                    response.setStatus(200);
                                    baseRequest.setHandled(true);
                                    asyncContext.complete();
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }.start();
                    } else if (this._completeAfter2 == 0L) {
                        response.getOutputStream().println("COMPLETED2");
                        response.setStatus(200);
                        baseRequest.setHandled(true);
                        asyncContext.complete();
                    }
                    if (this._resumeAfter2 > 0L) {
                        new Thread(){

                            @Override
                            public void run() {
                                try {
                                    Thread.sleep(SuspendHandler.this._resumeAfter2);
                                    asyncContext.dispatch();
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }.start();
                    } else if (this._resumeAfter2 == 0L) {
                        asyncContext.dispatch();
                    }
                } else {
                    response.setStatus(200);
                    baseRequest.setHandled(true);
                }
            }
        }
    }
}

